# Academic Phrasebank for Computer Science

## Usage Notes

This phrasebank provides templates for common academic writing functions. These phrases are:

- **Content-neutral**: Adapt them to your specific context by replacing placeholder words
- **Starting points**: Modify to fit your voice and avoid repetitive patterns
- **Not plagiarism**: These are generic functional patterns, but always adapt and vary

**Placeholder conventions:**
- `[X]`, `[Y]` = concepts, methods, or phenomena
- `[author/year]` = citation
- Italicized words = substitute with your specific terms

---

## 1. Introducing Work

### 1.1 Establishing Territory (Context and Importance)

**Stating the general field/area:**
- Research on X has a long tradition in the field of computer science.
- Recent developments in X have heightened the need for Y.
- X has become a critical component in modern Y systems.
- The problem of X has received considerable attention in recent years.
- Over the past decade, there has been growing interest in X.

**Highlighting importance:**
- Understanding X is crucial for advancing Y.
- X plays a pivotal role in determining Y.
- The efficiency of X directly impacts the performance of Y systems.
- Accurate X is essential for reliable Y.
- X has significant implications for both theory and practice.

### 1.2 Establishing a Niche (Gap/Problem)

**Indicating a gap:**
- However, little is known about X in the context of Y.
- Despite extensive research on X, the problem of Y remains largely unaddressed.
- While previous work has focused on X, the issue of Y has received less attention.
- To date, there has been limited investigation into X.
- A key limitation of existing approaches is their inability to handle X.

**Highlighting a problem:**
- However, these methods suffer from X, which limits their applicability.
- A major challenge in X is Y.
- Current approaches fail to address X when Y occurs.
- Existing methods make strong assumptions about X, which are often violated in practice.
- One of the main obstacles to X is Y.

**Questioning existing approaches:**
- However, it remains unclear whether X can effectively handle Y.
- The extent to which X affects Y is not yet fully understood.
- It is still an open question whether X or Y provides better performance.
- There is ongoing debate about the best approach to X.

### 1.3 Occupying the Niche (Your Contribution)

**Stating purpose/aim:**
- This paper presents X, a novel approach to Y.
- In this work, we propose X to address the challenge of Y.
- The main objective of this study is to investigate X.
- This paper aims to bridge the gap between X and Y.
- We introduce X, which enables Y.

**Describing key features:**
- Our approach leverages X to achieve Y.
- The key insight is that X can be used to improve Y.
- Unlike prior work, our method does not require X.
- A distinguishing feature of our approach is its ability to handle X.
- The core idea is to reformulate X as a Y problem.

**Stating contributions:**
- We make the following contributions:
- The main contributions of this paper are:
- This work offers several key innovations:
- Our contributions are threefold:
- Specifically, we:

---

## 2. Referring to Sources

### 2.1 Integral Citations (Author as Subject)

**Reporting research:**
- [Author, year] proposed X to address Y.
- [Author, year] demonstrated that X improves Y.
- [Author, year] showed that X outperforms Y on Z.
- [Author, year] introduced the concept of X.
- In their seminal work, [Author, year] established that X.

**Comparing or contrasting:**
- While [Author1, year] focused on X, [Author2, year] investigated Y.
- In contrast to [Author, year], we consider X.
- Unlike [Author, year], our approach does not assume X.
- Building on [Author, year], we extend X to handle Y.

### 2.2 Non-Integral Citations (Claim as Focus)

**Supporting statements:**
- X has been shown to improve Y [citations].
- Recent studies have demonstrated that X [citations].
- There is growing evidence that X [citations].
- It is widely accepted that X [citations].
- Empirical results suggest that X [citations].

**Referring to multiple sources:**
- Several studies have investigated X [citations].
- Various approaches have been proposed for X [citations].
- X has been explored from multiple perspectives [citations].

---

## 3. Describing Methods

### 3.1 Describing Procedures

**Sequential actions:**
- First, we preprocess the data by X. Next, we apply Y. Finally, we evaluate Z.
- The method consists of three stages: (1) X, (2) Y, and (3) Z.
- We begin by X. We then Y. The final step is to Z.
- The algorithm proceeds as follows:

**Parallel actions:**
- Simultaneously, we X and Y.
- In parallel, the model learns X while optimizing Y.
- Concurrently, we perform X and monitor Y.

**Conditional actions:**
- If X exceeds threshold τ, we apply Y; otherwise, we use Z.
- When X is detected, the system triggers Y.
- In cases where X occurs, we resort to Y.

### 3.2 Describing Implementations

**Technologies and tools:**
- We implement X using the Y framework.
- The system is built on top of X.
- We leverage the X library for Y.
- All experiments are conducted using X version Y.
- The code is written in X and available at [URL].

**Parameters and configurations:**
- We set hyperparameter X to Y based on validation set performance.
- The model is trained with learning rate X and batch size Y.
- We use the default configuration of X unless otherwise specified.
- Following [author, year], we set X to Y.

---

## 4. Reporting Results

### 4.1 Presenting Main Findings

**Introducing results:**
- Table X shows the performance of Y on Z.
- As shown in Figure X, our method outperforms baselines.
- The results are summarized in Table X.
- Figure X illustrates the effect of X on Y.

**Highlighting key results:**
- Our method achieves X, outperforming the strongest baseline by Y%.
- The proposed approach consistently improves X across all benchmarks.
- We observe that X leads to significant gains in Y.
- Notably, our method requires only X% of the data used by Y.
- The results demonstrate that X is crucial for achieving high Y.

**Comparing to baselines:**
- Compared to X, our method achieves Y% improvement.
- Our approach outperforms all baselines in terms of X.
- While baseline X achieves Y, our method reaches Z.
- The performance gap between our method and X is statistically significant (p < 0.01).

### 4.2 Commenting on Results

**Interpreting findings:**
- This suggests that X is more effective than Y for Z.
- These results indicate that X plays a critical role in Y.
- The superior performance can be attributed to X.
- This finding is consistent with the hypothesis that X.
- One possible explanation is that X enables Y.

**Highlighting unexpected results:**
- Surprisingly, we find that X does not improve Y.
- Contrary to expectations, X performs worse than Y.
- Interestingly, increasing X beyond Y does not yield further gains.
- An unexpected finding is that X and Y have comparable performance.

---

## 5. Discussing Findings

### 5.1 Interpreting Results

**Explaining success:**
- The strong performance can be explained by X's ability to Y.
- The improvement is primarily due to X.
- We hypothesize that X captures Y, which is crucial for Z.
- This is likely because X enables the model to Y.

**Acknowledging limitations:**
- However, our method struggles when X occurs.
- One limitation is that the approach requires X.
- The model's performance degrades in the presence of X.
- It should be noted that our evaluation does not cover X.
- While effective in most cases, the method fails when X.

### 5.2 Comparing with Literature

**Consistency with prior work:**
- These findings are consistent with [author, year].
- Our results corroborate the observations of [author, year].
- This aligns with the conclusion drawn by [author, year].
- Similar trends have been reported in [citations].

**Discrepancy with prior work:**
- In contrast to [author, year], we observe that X.
- Our findings differ from those of [author, year], possibly because Y.
- While [author, year] reported X, we find Y, which may be due to Z.

### 5.3 Stating Implications

**Theoretical implications:**
- These results have important implications for X.
- This finding challenges the assumption that X.
- Our work provides evidence that X.
- This suggests that the conventional view of X may need to be revised.

**Practical implications:**
- From a practical standpoint, this means that X.
- The findings have direct applications in X.
- This approach could be used to improve X in Y systems.
- These results may inform the design of X.

---

## 6. Writing Conclusions

### 6.1 Summarizing the Study

**Restating aims:**
- In this paper, we presented X, a novel approach to Y.
- This work investigated the problem of X.
- We proposed X to address the challenge of Y.
- The goal of this study was to explore X.

**Summarizing findings:**
- We demonstrated that X significantly improves Y.
- Our experiments show that X outperforms existing methods on Y.
- The results indicate that X is effective for Y.
- We found that X is crucial for achieving high performance on Y.

### 6.2 Stating Broader Impact

**Significance:**
- This work advances the state of the art in X.
- The findings contribute to a better understanding of X.
- Our approach enables new applications in X.
- This study provides a foundation for future research on X.

### 6.3 Suggesting Future Work

**Open questions:**
- An important direction for future work is to investigate X.
- It would be valuable to explore how X performs on Y.
- Future research could examine X in the context of Y.
- An interesting question is whether X can be extended to Y.

**Limitations to address:**
- Future work should address the limitation of X.
- A natural extension is to relax the assumption that X.
- Scaling the approach to handle X remains a challenge.
- Incorporating X into the framework is a promising direction.

---

## 7. General Language Functions

### 7.1 Being Cautious (Hedging)

**Modal verbs:**
- X may/might/could improve Y.
- This approach would/should be effective for X.
- The method appears to/seems to handle X well.

**Adverbs:**
- X possibly/probably/likely improves Y.
- The results suggest that X is arguably/potentially useful for Y.
- This finding is generally/typically observed in X.

**Phrases:**
- To a certain extent, X improves Y.
- To some degree, X is influenced by Y.
- There is some evidence that X.
- It seems likely that X.
- The results tend to support the view that X.

### 7.2 Being Critical

**Identifying weaknesses:**
- A limitation of this approach is X.
- However, this method fails to address X.
- One weakness is that the evaluation does not include X.
- The study overlooks the important factor of X.
- The authors do not consider X, which may affect Y.

**Questioning validity:**
- It is unclear whether X holds for Y.
- The claim that X is not well-supported by the evidence.
- The results may be confounded by X.
- The evaluation lacks X, which limits the generalizability of the findings.

### 7.3 Classifying and Listing

**Categories:**
- X can be classified into Y and Z.
- There are two main approaches to X: Y and Z.
- Methods for X fall into three categories:
- We distinguish between X and Y.

**Enumerating:**
- First, ... Second, ... Third, ...
- On the one hand, ... On the other hand, ...
- Not only ... but also ...
- In addition to X, we also consider Y.

### 7.4 Compare and Contrast

**Similarity:**
- Similarly, X also exhibits Y.
- Likewise, Z shows comparable performance.
- X is analogous to Y in that both Z.
- Both X and Y suffer from Z.

**Difference:**
- In contrast, X does not require Y.
- Unlike X, our approach handles Y.
- Whereas X focuses on Y, we address Z.
- X differs from Y in that Z.

### 7.5 Defining Terms

**Formal definitions:**
- We define X as Y.
- Let X denote Y.
- Formally, X is defined by Y.
- X refers to Y.
- By X, we mean Y.

**Informal definitions:**
- In this paper, X represents Y.
- We use X to describe Y.
- X can be understood as Y.

### 7.6 Describing Trends

**Increasing:**
- X increases/grows/rises with Y.
- There is a positive correlation between X and Y.
- As X increases, Y also increases.
- X exhibits an upward trend.

**Decreasing:**
- X decreases/declines/falls with Y.
- There is a negative correlation between X and Y.
- As X increases, Y decreases.
- X shows a downward trend.

**Stability:**
- X remains stable/constant across Y.
- There is little variation in X.
- X plateaus at Y.

### 7.7 Describing Quantities

**Magnitudes:**
- X is significantly/substantially/considerably larger than Y.
- X is slightly/marginally/moderately higher than Y.
- X is approximately/roughly equal to Y.
- X exceeds Y by Z%.

**Proportions:**
- X accounts for Y% of Z.
- The majority/minority of X is Y.
- A substantial/significant portion of X is Y.
- X constitutes Y% of the total.

### 7.8 Explaining Causality

**Causes:**
- X causes/leads to/results in Y.
- X is responsible for Y.
- Y is caused by X.
- X triggers Y.
- Y arises from X.

**Effects:**
- X has a significant/profound/minimal effect on Y.
- X influences/affects/impacts Y.
- X is a determining factor in Y.
- Y is influenced by X.

**Conditions:**
- X depends on Y.
- Y is a prerequisite for X.
- X requires Y.
- Given X, Y follows.
- Under condition X, Y occurs.

### 7.9 Giving Examples

**Introducing examples:**
- For example, X can be used to Y.
- For instance, in the case of X, Y occurs.
- To illustrate, consider X.
- A typical example is X.
- Specifically, we observe X.

**Generalizing from examples:**
- In general, X leads to Y.
- More broadly, X applies to Y.
- This pattern holds for X.

### 7.10 Signalling Transition

**Adding information:**
- Moreover, X also improves Y.
- Furthermore, we observe that X.
- In addition, X provides Y.
- Additionally, X enables Y.

**Contrasting:**
- However, X does not address Y.
- Nevertheless, X remains effective.
- On the other hand, Y exhibits X.
- Conversely, Z shows the opposite trend.

**Sequencing:**
- Subsequently, we evaluate X.
- Next, we examine Y.
- Following X, we perform Y.
- Finally, we conclude with X.

**Emphasizing:**
- Notably, X outperforms Y.
- Importantly, Z is crucial for X.
- Particularly, X is effective when Y.
- It is worth noting that X.

---

## Tips for Using This Phrasebank

1. **Vary your expressions**: Don't use the same phrase repeatedly. Mix patterns to maintain reader interest.

2. **Adapt to context**: These are templates. Modify them to fit your specific research and maintain natural flow.

3. **Combine with clarity principles**: Use topic/stress position rules even when applying these phrases.

4. **Don't force phrases**: If a phrase doesn't fit naturally, rephrase or use your own words.

5. **Discipline-specific variation**: Some phrases are more common in certain CS subfields. Pay attention to conventions in your target venue.

6. **Avoid overuse of hedging**: Balance caution with confidence. Too many hedges weaken claims.

---

## Further Resources

- Manchester Academic Phrasebank: https://www.phrasebank.manchester.ac.uk/
- Field-specific paper reading: Study phrase patterns in top papers from your target venue
- Parallel corpus analysis: Compare your drafts with published papers to identify style patterns
