# Research Foundation: deep thinking + Verbalized Sampling

## Purpose

Enable deep, extended thinking with diverse exploration for maximum quality and innovation.

---

## Research Backing

### Verbalized Sampling (Zhang et al., 2024, arXiv:2510.01171)

- Asking models to generate multiple responses with probabilities (p<0.10) increases creative diversity by **1.6-2.1x**
- Improves quality by **25.7%**
- Circumvents "typicality bias" in alignment training data
- Forces exploration of low-probability creative options

### Extended Thinking (deep thinking)

- Deep reasoning allows unexpected connections to form
- Reduces reliance on first-thought/obvious responses
- Develops each option with depth and sophistication

---

## Why the Combined Approach Works

1. **Verbalized Sampling** forces exploration of low-probability creative options (diversity)
2. **Extended thinking** develops each option with depth and sophistication (quality)
3. Thinking blocks allow internal generation of 5 options without cluttering output
4. User receives single best response, but it's selected from diverse distribution
5. Combats both mode collapse (VS) and shallow thinking (deep thinking)

**Output Format:** Generate diversity internally via thinking blocks, output single best response to user.

---

## When to Activate This Skill

### Direct Creativity Requests
- "be creative", "be more creative", "think creatively"
- "deep thinking", "use deep thinking", "think deeply"
- "diverse ideas", "different perspectives", "varied approaches"
- "think outside the box", "unconventional approaches"
- "creative solution", "innovative approach"

### Creative Content Tasks
- Creative writing (stories, poems, jokes, narrative)
- Idea generation and brainstorming sessions
- Content creation (blog posts, social media, marketing)
- Product naming and branding
- Artistic concepts and creative direction

### Quality + Diversity Requirements
- Need to avoid formulaic or typical responses
- Want high-quality creative solutions
- Require both quality AND diversity in output
- Need unconventional thinking
- Seek breakthrough ideas

### Technical Creativity (Uses Workflow)
- Creative algorithms or data structures
- Novel system architectures
- Innovative engineering solutions
- Elegant mathematical approaches
- Non-obvious technical optimizations
