# OSINT Ethical Framework

## Authorization Requirements

**MANDATORY PRE-CHECKS:**

Every OSINT investigation requires:

1. **Explicit Authorization**
   - Written permission from authorized party
   - Clear engagement letter or scope document
   - Client signature or approval chain

2. **Defined Scope**
   - Target entities clearly identified
   - Information types specified
   - Purpose documented
   - Boundaries established

3. **Legal Compliance**
   - CFAA (Computer Fraud and Abuse Act)
   - FCRA (Fair Credit Reporting Act) for background checks
   - GDPR (if EU subjects)
   - CCPA (if California residents)
   - State-specific privacy laws
   - Anti-stalking statutes

4. **Documentation**
   - Authorization paperwork filed
   - Scope in writing
   - Legal review if applicable

**STOP if any requirement is unmet.**

---

## Ethical Boundaries

### ALWAYS:

- Use only publicly available sources
- Document all sources and methodology
- Respect platform Terms of Service
- Apply proportionality (minimum necessary)
- Protect subject privacy beyond scope
- Archive with proper metadata
- Secure collected data appropriately
- Disclose limitations in reports
- Distinguish fact from inference
- Use multiple source verification

### NEVER:

- Access private systems without authorization
- Use pretexting or impersonation
- Social engineer targets or contacts
- Circumvent access controls
- Purchase illegally obtained data
- Violate platform ToS for critical data
- Stalk or harass subjects
- Exceed authorized scope
- Share data beyond authorized recipients
- Make false representations

---

## Legal Considerations by Target Type

### People OSINT
- FCRA compliance for employment/credit
- State background check laws
- Anti-stalking statutes
- Harassment laws
- Privacy torts

### Company OSINT
- Trade secret protections
- Competitive intelligence boundaries
- Securities law (insider trading)
- CFAA for technical recon
- ToS for platform access

### Entity/Threat OSINT
- CFAA for scanning
- Authorized penetration testing scope
- Responsible disclosure obligations
- Data breach notification laws
- Export controls on threat intel

---

## Proportionality Principle

**Collect only what is necessary for the stated purpose.**

Before collecting data, ask:
1. Is this within authorized scope?
2. Is this necessary for the objective?
3. Is there a less invasive alternative?
4. Will collection harm the subject?
5. Can I justify this collection?

---

## Data Handling

### Collection
- Minimize to authorized scope
- Document sources immediately
- Timestamp all findings
- Preserve chain of custody

### Storage
- Encrypt sensitive data
- Access controls applied
- Retention limits set
- Secure destruction planned

### Sharing
- Only to authorized recipients
- Secure transmission methods
- Need-to-know basis
- Redact unnecessary PII

### Retention
- Defined retention period
- Regular review for deletion
- Secure destruction methods
- Audit trail maintained

---

## Reporting Standards

**All OSINT reports must include:**

1. **Scope Statement**
   - Authorization reference
   - Target definition
   - Information types collected
   - Time period covered

2. **Methodology**
   - Sources consulted
   - Tools used
   - Search terms employed
   - Limitations encountered

3. **Findings**
   - Clearly labeled facts vs. inferences
   - Source citations
   - Confidence levels assigned
   - Verification status noted

4. **Caveats**
   - Information gaps
   - Unverified claims
   - Potential biases
   - Currency of information

5. **Classification**
   - Handling restrictions
   - Distribution limits
   - Retention requirements

---

## Red Lines (Never Cross)

**These actions are NEVER authorized:**

- Hacking or unauthorized access
- Password cracking without authorization
- Social engineering attacks
- Physical surveillance or trespass
- Bribery or corruption
- Illegal wiretapping
- Purchasing stolen data
- Creating fake identities for access
- Threatening or coercing sources
- Sharing with unauthorized parties

---

## Professional Standards

**Adhere to:**

- OSINT practitioner codes of ethics
- Industry-specific regulations
- Client confidentiality requirements
- Professional licensing requirements
- Continuous legal education

**Maintain:**

- Professional liability insurance
- Documented training records
- Peer review processes
- Ethical review procedures

---

## Escalation Procedures

**When encountering:**

1. **Scope Uncertainty**
   - Pause collection
   - Document the question
   - Seek client clarification
   - Get written approval before proceeding

2. **Legal Concerns**
   - Stop immediately
   - Document the concern
   - Consult legal counsel
   - Do not proceed until cleared

3. **Ethical Dilemmas**
   - Apply proportionality test
   - Consider potential harm
   - Seek peer review
   - Document decision rationale

4. **Sensitive Findings**
   - Assess disclosure obligations
   - Consider subject harm
   - Consult with client
   - Follow responsible disclosure

---

## Authorization Verification Checklist

Before starting ANY OSINT investigation:

- [ ] Written authorization received
- [ ] Scope clearly defined
- [ ] Purpose documented
- [ ] Legal compliance verified
- [ ] Ethical boundaries understood
- [ ] Data handling plan in place
- [ ] Reporting requirements clear
- [ ] Escalation procedures known

**If any box is unchecked, DO NOT PROCEED.**

---

**Version:** 1.0
**Last Updated:** December 2024
**Owner:** PAI OSINT Skill
