# AI Persona Creator - Reference Guide

This reference guide provides comprehensive documentation for the 10-framework psychological analysis system (Tier 1 Foundation + Core Frameworks) and persona prompt templates.

---

## 📚 Quick Navigation

### Tier 1: Foundation Frameworks (Critical Base Layer)

**TIER 1 FOUNDATION** (Establish WHO they are, WHAT drives them, SAFETY needed):

1. **[Personality Psychology](frameworks/09_personality_psychology.md)** - WHO They Are
   - Big Five/OCEAN personality dimensions
   - Regulatory Focus (Promotion vs Prevention)
   - Type A/B personality indicators
   - Key insight: Personality shapes how all other frameworks apply

2. **[Motivational Psychology](frameworks/08_motivational_psychology.md)** - WHAT Drives Them
   - Self-Determination Theory (SDT) needs: Autonomy, Competence, Relatedness
   - McClelland's Motives: Achievement (nAch), Power (nPow), Affiliation (nAff)
   - Goal Orientation: Mastery vs Performance vs Avoidance
   - Key insight: Motivation determines which persuasion levers work

3. **[Trust & Risk Psychology](frameworks/10_trust_risk_psychology.md)** - SAFETY Foundation
   - Trust Equation: Credibility, Reliability, Intimacy, Self-Orientation
   - Loss Aversion and Risk Perception
   - Betrayal Aversion and Trust Recovery Time
   - Key insight: Trust baseline determines feasibility of persuasion approaches

**Then apply CORE FRAMEWORKS with Tier 1 context**:

---

### Core Frameworks (Applied with Tier 1 Foundation Context)

**Psychological Analysis Frameworks** (7 perspectives - contextualized by Tier 1):

1. **[Kahneman](frameworks/01_kahneman.md)** - Cognitive Biases & Dual Systems
   - System 1 vs System 2 thinking
   - Key cognitive biases (anchoring, loss aversion, etc.)
   - Decision-making style analysis

2. **[Cialdini](frameworks/02_cialdini.md)** - 6 Persuasion Principles
   - Reciprocity, Consistency, Social Proof
   - Liking, Authority, Scarcity
   - Vulnerability ranking and tactical applications

3. **[Voss](frameworks/03_voss.md)** - Tactical Empathy & Hidden Needs
   - Stated vs real needs
   - Labeling and calibrated questions
   - Black Swan discovery

4. **[Navarro](frameworks/04_navarro.md)** - Non-Verbal Behavior Analysis
   - Comfort vs discomfort signals
   - Stress triggers and comfort zones
   - Verbal pattern analysis

5. **[Ariely](frameworks/05_ariely.md)** - Predictable Irrationality
   - Relativity and comparison effects
   - Ownership effect and expectations
   - Free effect and social vs market norms

6. **[Evolutionary Psychology](frameworks/06_evolution.md)** - Primal Drives
   - Survival instincts and threat detection
   - Status, hierarchy, and tribal belonging
   - Reputation management

7. **[Organizational Psychology](frameworks/07_organization.md)** - Power Structures
   - Formal authority vs informal influence
   - Stakeholder mapping
   - Coalition building strategies

**Integration Guide**:
- **[Framework Integration](frameworks/00_integration.md)** - How to apply all 7 frameworks together
  - Step-by-step integration process
  - Situational weighting (fear-driven, ROI, routine decisions)
  - Quality checklist

---

### Templates

**Persona Prompt Template**:
- **[Persona Prompt Structure](templates/persona-prompt.md)** - Complete template for generating personas
  - Persona definition structure
  - 3-step feedback generation framework
  - Red flag detection (4 risk categories)
  - Output format and quality standards

---

## 🎯 Quick Framework Summary

| Tier | Framework | Focus | Key Output | Use When |
|------|-----------|-------|------------|----------|
| **T1** | **Personality** | WHO they are | Big Five, regulatory focus, Type A/B | Establish baseline before other frameworks |
| **T1** | **Motivation** | WHAT drives them | SDT needs, McClelland motives, goal orientation | Determine which persuasion levers work |
| **T1** | **Trust/Risk** | SAFETY foundation | Trust level, loss aversion, betrayal sensitivity | Assess feasibility of persuasion approaches |
| **C** | **Kahneman** | Emotion vs Logic | System 1/2 split, primary biases | Understanding decision-making style (with personality context) |
| **C** | **Cialdini** | Persuasion | Ranked vulnerability to 6 principles | Finding persuasion levers (filtered by motivation) |
| **C** | **Voss** | Hidden Needs | Surface vs real concerns | Uncovering unstated motivations (aligned with trust) |
| **C** | **Navarro** | Behavior | Stress triggers, comfort zones | Predicting reactions (Type A/B based) |
| **C** | **Ariely** | Irrationality | Predictable patterns | Understanding irrational decisions (personality-driven) |
| **C** | **Evolution** | Primal Drives | Survival, status, tribal | Root psychological causes (regulatory focus context) |
| **C** | **Organization** | Politics | Power structure, stakeholders | Navigating organizational dynamics |

---

## 📖 Usage Guide

### For Quick Reference

If you know which framework you need:
1. **Start with Tier 1** to establish WHO/WHAT/SAFETY foundation
2. Navigate to specific core framework file
3. Use the Output Template section for quick implementation
4. Apply with Tier 1 context in mind

### For Complete Analysis

Follow the integration process:
1. Read Tier 1 frameworks first (Personality → Motivation → Trust):
   - [Personality Psychology](frameworks/09_personality_psychology.md) - WHO
   - [Motivational Psychology](frameworks/08_motivational_psychology.md) - WHAT
   - [Trust & Risk Psychology](frameworks/10_trust_risk_psychology.md) - SAFETY
2. Then read and apply all 7 core framework files with Tier 1 context
3. Use [Framework Integration](frameworks/00_integration.md) for weighted importance
4. Generate final persona using [Persona Prompt Template](templates/persona-prompt.md)

### For Learning

Start with these in order:
1. **[Personality Psychology](frameworks/09_personality_psychology.md)** - Establish baseline WHO
2. **[Motivational Psychology](frameworks/08_motivational_psychology.md)** - Understand WHAT drives them
3. **[Trust & Risk Psychology](frameworks/10_trust_risk_psychology.md)** - Assess SAFETY feasibility
4. [Kahneman](frameworks/01_kahneman.md) - How they think (contextualized by personality)
5. [Cialdini](frameworks/02_cialdini.md) - How to persuade them (filtered by motivation)
6. [Voss](frameworks/03_voss.md) - Surface vs hidden needs (aligned with trust)
7. [Framework Integration](frameworks/00_integration.md) - How it all works together
8. Other frameworks as needed

---

## 🔍 Framework Details

### Decision-Making Analysis (WHO they are + HOW they think)
- **Tier 1 Foundation**: [Personality](frameworks/09_personality_psychology.md) (Big Five influence on System 1/2)
- **Primary**: [Kahneman](frameworks/01_kahneman.md) (contextualized by personality)
- **Supporting**: [Ariely](frameworks/05_ariely.md), [Evolution](frameworks/06_evolution.md)

### Persuasion Strategy (WHAT drives them + HOW to persuade)
- **Tier 1 Foundation**: [Motivation](frameworks/08_motivational_psychology.md) (SDT, McClelland determines which levers work)
- **Primary**: [Cialdini](frameworks/02_cialdini.md) (ranked by motivation profile)
- **Supporting**: [Voss](frameworks/03_voss.md), [Navarro](frameworks/04_navarro.md)

### Risk & Trust Assessment (SAFETY foundation for persuasion)
- **Tier 1 Foundation**: [Trust & Risk](frameworks/10_trust_risk_psychology.md) (determines feasibility)
- **Primary**: [Kahneman](frameworks/01_kahneman.md) (loss aversion context)
- **Supporting**: [Evolution](frameworks/06_evolution.md) (threat response)

### Organizational Navigation
- **Primary**: [Organization](frameworks/07_organization.md)
- **Supporting**: [Evolution](frameworks/06_evolution.md) (status, tribal dynamics)

### Hidden Motivations (aligned with Tier 1)
- **Tier 1 Foundation**: [Motivation](frameworks/08_motivational_psychology.md) (real drives)
- **Primary**: [Voss](frameworks/03_voss.md) (surface vs real needs), [Evolution](frameworks/06_evolution.md)
- **Supporting**: [Kahneman](frameworks/01_kahneman.md), [Navarro](frameworks/04_navarro.md)

---

## 💡 Common Use Cases

### High-Stakes Security Decisions (e.g., CISO approvals)

**Priority frameworks** (weighted):
1. Evolution (30%) - Survival threat, status loss
2. Kahneman (25%) - Loss aversion, System 1 dominance
3. Organization (20%) - Political cover
4. Voss (15%) - Hidden fear of blame

**Key files to read**:
- [Evolutionary Psychology](frameworks/06_evolution.md)
- [Kahneman](frameworks/01_kahneman.md)
- [Organizational Psychology](frameworks/07_organization.md)

### Investment/Budget Decisions (e.g., CFO approvals)

**Priority frameworks** (weighted):
1. Kahneman (30%) - System 2 analysis, biases
2. Organization (25%) - Stakeholder alignment
3. Cialdini (20%) - Social proof, authority
4. Ariely (15%) - Relativity, comparisons

**Key files to read**:
- [Kahneman](frameworks/01_kahneman.md)
- [Organizational Psychology](frameworks/07_organization.md)
- [Cialdini](frameworks/02_cialdini.md)

### Sales & Negotiation (e.g., winning proposals)

**Priority frameworks** (weighted):
1. Cialdini (30%) - Persuasion principles
2. Voss (25%) - Hidden needs, tactical empathy
3. Kahneman (20%) - Biases and framing
4. Navarro (15%) - Reading reactions

**Key files to read**:
- [Cialdini](frameworks/02_cialdini.md)
- [Voss](frameworks/03_voss.md)
- [Kahneman](frameworks/01_kahneman.md)

---

## 📋 Quality Checklist

When creating a persona, ensure you've:

**Framework Coverage**:
- [ ] Tier 1 Foundation fully established (Personality + Motivation + Trust)
- [ ] All 10 frameworks explicitly addressed (Tier 1 + 7 core)
- [ ] Each framework has evidence from web research
- [ ] Confidence levels (%) provided for key claims
- [ ] Integration section shows how Tier 1 shapes other frameworks

**Research Quality**:
- [ ] 3+ independent sources per major insight
- [ ] 5+ field testimonials included
- [ ] Cross-verification completed
- [ ] Source citations for all psychological claims
- [ ] Tier 1 foundation grounded in research (not assumptions)

**Actionability**:
- [ ] Tactical applications provided (not just theory)
- [ ] Alternative solutions for common objections
- [ ] Red flags clearly identified
- [ ] Specific persuasion strategies outlined

---

## 📊 Framework Comparison

### Scope of Analysis

| Framework | Individual Psychology | Group Dynamics | Organizational Politics | Role in Analysis |
|-----------|----------------------|----------------|------------------------|-------------------|
| **Personality** (T1) | ✅ Primary | ✅ Moderate | ⚠️ Limited | WHO they are (foundational) |
| **Motivation** (T1) | ✅ Primary | ✅ Moderate | ⚠️ Limited | WHAT drives them (foundational) |
| **Trust/Risk** (T1) | ✅ Primary | ⚠️ Limited | ✅ Moderate | SAFETY for persuasion (foundational) |
| Kahneman | ✅ Primary | ⚠️ Limited | ❌ No | How they think (contextualized) |
| Cialdini | ✅ Primary | ✅ Strong | ⚠️ Limited | How to persuade (filtered by motivation) |
| Voss | ✅ Primary | ⚠️ Limited | ⚠️ Limited | Hidden needs (aligned with trust) |
| Navarro | ✅ Primary | ⚠️ Limited | ❌ No | Stress/comfort (Type A/B based) |
| Ariely | ✅ Primary | ⚠️ Limited | ❌ No | Irrationality patterns (personality-driven) |
| Evolution | ✅ Primary | ✅ Strong | ⚠️ Limited | Primal drives (regulatory focus context) |
| Organization | ⚠️ Limited | ✅ Strong | ✅ Primary | Political context |

### Time to Master

| Framework | Reading Time | Application Complexity | Mastery Time | Priority |
|-----------|--------------|----------------------|--------------|----------|
| **Personality** (T1) | 15 min | Low-Medium | 2-3 weeks | **1st** - Foundation |
| **Motivation** (T1) | 15 min | Low-Medium | 2-3 weeks | **2nd** - Foundation |
| **Trust/Risk** (T1) | 15 min | Medium | 2-3 weeks | **3rd** - Foundation |
| Kahneman | 20 min | Medium | 3-4 weeks | 4th |
| Cialdini | 10 min | Low | 1-2 weeks | 5th |
| Voss | 15 min | Medium | 2-3 weeks | 6th |
| Ariely | 10 min | Low | 1-2 weeks | 7th |
| Navarro | 15 min | High | 4-6 weeks | 8th |
| Evolution | 15 min | Medium | 2-3 weeks | 9th |
| Organization | 20 min | High | 4-6 weeks | 10th |

---

## 🚀 Getting Started

**New to this system?**
1. **Start with Tier 1 Foundation** (critical base):
   - Read [Personality Psychology](frameworks/09_personality_psychology.md) - WHO they are
   - Read [Motivational Psychology](frameworks/08_motivational_psychology.md) - WHAT drives them
   - Read [Trust & Risk Psychology](frameworks/10_trust_risk_psychology.md) - SAFETY foundation
2. Then read 3 core frameworks: [Kahneman](frameworks/01_kahneman.md), [Cialdini](frameworks/02_cialdini.md), [Voss](frameworks/03_voss.md)
3. Run through one complete example from [EXAMPLES.md](EXAMPLES.md)
4. Practice with [Framework Integration](frameworks/00_integration.md) for integration logic
5. Use [SKILL.md](SKILL.md) for executable step-by-step process

**Experienced user?**
- Start with Tier 1 foundation to establish context
- Jump to specific core frameworks as needed
- Use [Persona Prompt Template](templates/persona-prompt.md) directly
- Reference [Framework Integration](frameworks/00_integration.md) for situational weighting

---

## 📝 Additional Resources

- **[SKILL.md](SKILL.md)** - Main skill file with step-by-step execution
- **[EXAMPLES.md](EXAMPLES.md)** - 3 complete persona examples with full process
- **[README.md](README.md)** - Installation and setup guide

---

**Version**: 3.0.0
**Updated**: 2025-11-09
**Structure**: Tier 1 Foundation (3 frameworks) + Core Frameworks (7 frameworks) + templates
**New in 3.0**: Tier 1 Foundation architecture (Personality + Motivation + Trust) providing context for all 7 core frameworks
