# How to Apply All 10 Frameworks (Tier 1-3 Integration)

## TIER 1: FOUNDATIONAL FRAMEWORKS (08-10) + EXISTING (01-07)

### Integration Process - Foundation Layer

**The 3-Step Tier 1 Foundation**:

1. **Start with Personality (F09)**: Establish individual baseline
   - Identify Big Five profile (OCEAN dimensions)
   - Assess Regulatory Focus (Promotion vs Prevention)
   - Detect Type A/B tendencies (Achievement-driven vs Relaxed)
   - → Establishes WHO this person is

2. **Layer in Motivation (F08)**: Understand WHAT drives them
   - Map SDT needs (Autonomy, Competence, Relatedness)
   - Profile McClelland motives (Achievement, Power, Affiliation)
   - Assess Goal Orientation (Mastery-Approach vs Performance-Approach vs Avoidance)
   - → Establishes WHAT energizes or depletes them

3. **Build Trust Foundation (F10)**: Create security for persuasion
   - Diagnose current Trust level (Credibility, Reliability, Intimacy, Self-Orientation)
   - Assess Loss Aversion & Risk Perception baseline
   - Identify Betrayal Aversion triggers (what violates their trust norms?)
   - → Establishes SAFETY required before any persuasion attempt

**Then apply existing frameworks (01-07) with Tier 1 context**:

4. **Apply Kahneman with personality context**: System 1 vs 2 dominance
   - High Conscientiousness + Prevention Focus = Strong System 2 reliance
   - High Neuroticism + Loss Aversion = Emotional System 1 override
   - Tailor cognitive bias approach based on personality-motivation profile

5. **Layer in Cialdini with motivation profile**: Which persuasion principles align with their drives?
   - High Achievement (nAch) → Authority, Social Proof of success
   - High Power (nPow) → Authority, Scarcity, Commitment/Consistency
   - High Affiliation (nAff) → Liking, Social Proof, Reciprocity

6. **Apply Voss with trust baseline**: Hidden needs reflect personality + motivation
   - Unconscious priorities = Motivation profile (what drives them)
   - Unspoken fears = Trust gaps (what creates anxiety)
   - Real interests = Personality (what genuinely matters to them)

7. **Consider Navarro through personality lens**: Body language signals personality-driven stress
   - Type A shows impatience/irritability signals under pressure
   - Prevention Focus shows anxiety signals when facing losses
   - Low Relatedness shows withdrawal signals in group settings

8. **Factor Ariely with motivation quirks**: Irrational patterns tied to personality
   - Achievement-motivated (nAch) → Anchoring effects on performance metrics
   - Power-motivated (nPow) → Status quo bias protecting current influence
   - Affiliation-motivated (nAff) → Social norms compliance

9. **Understand Evolution with personality**: Primal drives filtered through personality
   - Type A personality amplifies status threat response
   - Prevention Focus amplifies survival/loss threat response
   - Low Agreeableness amplifies tribal competition threat response

10. **Map Organization with regulatory focus**: Politics navigation depends on focus
    - Promotion Focus → Coalition building with advancement stories
    - Prevention Focus → Risk mitigation and protection of stakeholders
    - High Power motivation → Direct influence and formal channels

## TIER 1 Foundation Framework Weights by Decision Type

### High-Stakes, Fear-Driven Decisions (e.g., major technology investments, security approvals)

**Personality & Motivation Foundation (40%)**:
- Personality (F09) (15%): Type A vs B determines stress response; Neuroticism predicts anxiety
- Motivation (F08) (15%): Prevention Focus drives caution; Loss Aversion amplifies fear
- Trust (F10) (10%): Low trust baseline intensifies fear-driven reasoning

**Persuasion & Negotiation (40%)**:
- Evolutionary (15%): Survival threat, status loss, tribal protection
- Kahneman (15%): Loss aversion (2.5x pain), System 1 dominance under stress
- Voss (10%): Hidden fear of blame, unspoken worries surface here

**Context & Execution (20%)**:
- Organizational (10%): Political cover needed, stakeholder alignment
- Cialdini (5%): Authority, social proof of safety
- Navarro (3%): Stress management, body language interpretation
- Ariely (2%): Minimal—emotion overrides rationality

### Investment/ROI Decisions (e.g., budget approvals, strategic initiatives)

**Personality & Motivation Foundation (35%)**:
- Motivation (F08) (15%): Achievement focus drives ROI obsession; Power focus seeks influence
- Personality (F09) (12%): Conscientiousness determines rigor; Regulatory Focus shapes framing
- Trust (F10) (8%): Reliability track record critical for approval confidence

**Analytical & Social Persuasion (45%)**:
- Kahneman (15%): System 2 analysis for metrics, but biases remain in anchoring/framing
- Cialdini (15%): Social proof (others approved), Authority (expert recommendation)
- Organizational (10%): Stakeholder alignment, coalition building essential
- Ariely (5%): Relativity (comparative ROI), sunk cost effects

**Execution & Politics (20%)**:
- Voss (7%): Hidden agendas, real budget constraints
- Evolutionary (8%): Status concerns (who gets budget signals status)
- Navarro (3%): Minimal—usually less emotionally driven
- Navarro (2%): Stress signals during difficult questions

### Routine Operational Decisions (e.g., process changes, team adjustments)

**Personality & Motivation Foundation (30%)**:
- Personality (F09) (12%): Conscientiousness, Openness to change, Agreeableness
- Motivation (F08) (10%): Autonomy needs, Competence confidence
- Trust (F10) (8%): Existing relationship trust

**Analytical & Influence (50%)**:
- Kahneman (20%): System 2 analytical process, established procedures
- Cialdini (15%): Commitment/Consistency (prior support), Liking (relationship)
- Organizational (10%): Hierarchical approval, standard channels
- Ariely (5%): Anchoring (baseline expectations)

**Context (20%)**:
- Voss (8%): Surface needs clear; hidden agenda low
- Evolutionary (7%): Minimal status/survival concerns
- Navarro (3%): Low emotional stakes
- Evolutionary (2%): Tribal dynamics minimal

## TIER 1 Integration Quality Checklist

When applying Tier 1 frameworks, ensure:

- [ ] **Personality (F09)** fully assessed: Big Five dimensions identified with evidence
- [ ] **Motivation (F08)** mapped: SDT needs, McClelland motives, Goal Orientation clear
- [ ] **Trust (F10)** diagnosed: Credibility, Reliability, Intimacy, Self-Orientation scored
- [ ] **Frameworks 01-07 applied WITH Tier 1 context**: Not standalone—always contextualized
- [ ] **Integration points explicit**: Show HOW personality shapes Kahneman/Cialdini application
- [ ] **Weights assigned**: Situation type identified, framework importance percentages applied
- [ ] **Tactical applications provided**: Specific persuasion strategies based on Tier 1 profile
- [ ] **Confidence levels** noted: Certainty of assessments (high/medium/low)
- [ ] **No contradictions**: Personality-Motivation-Trust profile internally consistent

## Legacy Checklist (Pre-Tier 1 Frameworks 01-07 Only)

When applying original 7 frameworks (Kahneman, Cialdini, Voss, Navarro, Ariely, Evolution, Organization), ensure:

- [ ] All 7 frameworks explicitly addressed
- [ ] Each framework has evidence from web research (citations)
- [ ] Confidence levels (%) provided for key claims
- [ ] Multiple biases/patterns identified (not just one)
- [ ] Integration section shows how frameworks interact
- [ ] Tactical applications provided (not just theory)
- [ ] Situational weighting considered
