# Framework 1: Kahneman (Cognitive Biases & Dual Systems)

## System 1 vs System 2 Thinking

**System 1** (Fast, Intuitive, Emotional):
- Automatic reactions to proposals
- First impressions and gut feelings
- Pattern recognition from past experiences
- Emotional triggers

**System 2** (Slow, Deliberate, Logical):
- Analytical evaluation
- Cost-benefit calculations
- Risk assessment procedures
- Rational justifications

**Analysis Questions**:
- What's the immediate emotional reaction? (System 1)
- What rational arguments do they construct? (System 2)
- Which system dominates their decision-making? (% split)
- Are they aware of their biases?

## Key Cognitive Biases to Identify

1. **Anchoring**: First number/option heavily influences judgment
2. **Confirmation Bias**: Seeking evidence that confirms existing beliefs
3. **Loss Aversion**: Fear of losses > excitement for gains (2:1 ratio)
4. **Status Quo Bias**: Preference for current state over change
5. **Availability Heuristic**: Recent/memorable events disproportionately influence
6. **Framing Effect**: Same info presented differently yields different decisions
7. **Sunk Cost Fallacy**: Past investments influence future decisions irrationally

## Output Template

```yaml
System 1 Reactions:
  - Immediate response: [fear/excitement/suspicion]
  - Emotional triggers: [past trauma, success stories]
  - Biases detected: [loss aversion 90%, status quo 80%]

System 2 Rationalization:
  - Stated logic: ["We need more data", "ROI unclear"]
  - Real criteria: [safety, political cover]
  - Logic vs emotion ratio: [20% logic, 80% emotion]
```
