# Framework 5: Ariely (Predictable Irrationality)

## Key Irrationality Patterns

1. **Relativity**: Decisions made by comparison, not absolutes
   - Strategy: Control the comparison set (anchor high, make your offer seem reasonable)

2. **Social vs Market Norms**: Mixing these destroys goodwill
   - Social: Favors, relationships, community
   - Market: Money, transactions, contracts
   - Don't mix: Don't charge friends, don't ask vendors for favors

3. **Free Effect**: "Free" has disproportionate appeal
   - Strategy: Free tier, free trial, free audit (not just "low cost")

4. **Ownership Effect**: We overvalue what we already have
   - Strategy: Create ownership early (trial creates ownership)

5. **Expectations Shape Reality**: What we expect influences what we experience
   - Strategy: Set positive expectations ("Industry leaders love this feature")

## Output Template

```yaml
Irrationality Patterns:
  - Relativity: Compare to expensive alternative (on-prem cost) first
  - Ownership effect: Likely to defend current system (80% status quo bias)
  - Free effect: "Free security assessment" works better than "discounted"
  - Expectations: Primed by past cloud failures → expects problems

Tactical Applications:
  1. Anchor to $500K on-prem cost before showing $100K cloud cost
  2. Offer free POC to create ownership feeling
  3. Set expectation: "Companies like yours typically see 40% savings"
```
