# Framework 6: Evolutionary Psychology

## Primal Drives Underlying Modern Behavior

1. **Survival Instincts**:
   - Threat detection (amygdala override)
   - Fight/flight/freeze responses
   - Loss sensitivity (survival-critical in ancestral environment)

2. **Status & Hierarchy**:
   - Status competition within tribe/organization
   - Dominance vs prestige seeking
   - Fear of status loss > desire for gain

3. **Tribal Belonging**:
   - In-group vs out-group categorization
   - Loyalty to "our way" vs "their way"
   - Conformity to group norms

4. **Reputation Management**:
   - Extreme sensitivity to public failure
   - Gossip and social judgment avoidance
   - Concern about what others think

## Analysis Questions

- What "threat" does your proposal represent? (survival)
- How does this affect their organizational status? (hierarchy)
- Are you in-group or out-group? (tribal)
- How might this affect their reputation? (social standing)

## Output Template

```yaml
Evolutionary Drives:
  Survival:
    - Threat perception: "Cloud = loss of control = danger" (90%)
    - Risk sensitivity: Extreme (past trauma amplified)

  Status/Hierarchy:
    - Current status: Mid-level, vulnerable
    - Status threat: Failure could mean demotion
    - Status opportunity: Success = promotion? (unlikely to risk)

  Tribal Dynamics:
    - In-group: Traditional IT, on-prem vendors
    - Out-group: Cloud vendors, "Silicon Valley types"
    - Tribal loyalty: "We've always done it this way" (80%)

  Reputation:
    - Public failure fear: CEO presentation nightmares
    - Peer judgment: "What will other CISOs think?"
    - Conservative strategy: "Better safe than sorry"

Primal Translation:
  "We need to evaluate security" = "I'm detecting a threat to my survival"
  "Let me check with my team" = "I need tribal consensus for safety"
  "What if something goes wrong?" = "Status loss could be catastrophic"
```
