# Framework 7: Organizational Psychology

## Power Structure Analysis

1. **Formal Authority**:
   - Official decision-making power
   - Budget approval levels
   - Reporting relationships

2. **Informal Influence**:
   - Who does the boss really listen to?
   - Historical political capital
   - Expert power vs positional power

3. **Stakeholder Mapping**:
   - Supporters: Who benefits from success?
   - Blockers: Who loses from change?
   - Influencers: Who sways the decision-maker?
   - Neutral: Who can be swayed?

## Analysis Process

- Map formal org chart
- Identify informal power brokers
- Understand past political wins/losses
- Assess political capital available

## Output Template

```yaml
Power Structure:
  Formal Authority:
    - Title: CISO
    - Decision power: Recommends (doesn't approve)
    - Budget control: $0 (submits requests)
    - Reports to: CIO (who reports to CFO)

  Informal Influence:
    - Relationship with CIO: Tense (competing for resources)
    - Expert credibility: High within IT, low with executives
    - Past wins: Successfully blocked 2 vendor proposals (defensive wins)
    - Political capital: Low (recent project delays hurt reputation)

Stakeholder Map:
  Supporters:
    - IT team: Benefits from less manual work (60% support)

  Blockers:
    - CFO: Sees this as cost, not investment (80% blocker)
    - Existing vendor: Loses business (100% blocker)

  Key Influencers:
    - CIO: Makes final call (currently neutral, leans skeptical)
    - CEO: Cares about results, not tech (needs 1-page summary)

  Neutral (can sway):
    - Compliance officer: Needs ISMS-P assurance
    - Operations head: Needs reliability proof

Coalition Building Strategy:
  1. Win over IT team first (easy allies)
  2. Address compliance officer concerns (documentation)
  3. Prepare CIO's boss (CEO) 1-pager (bypass CIO if needed)
  4. Neutralize CFO with ROI calculator showing savings
  5. Isolate existing vendor (they have no counter-move)

Political Risks:
  - CISO may sabotage to protect turf (80% risk)
  - CFO may kill before due evaluation (60% risk)
  - CIO may delay decision indefinitely (70% risk)
```
