# Framework 8: Motivational Psychology (SDT, McClelland, Goal Orientation)

## Core Theories

**Self-Determination Theory (Deci & Ryan)**
- Autonomy: Need for choice and self-direction in actions
- Competence: Need for mastery, effectiveness, and skill development
- Relatedness: Need for connection, belonging, and social acceptance

**McClelland's Acquired Needs Theory**
- Achievement (nAch): Drive for measurable success, goal completion, performance metrics
- Power (nPow): Drive for influence, status, control, and strategic positioning
- Affiliation (nAff): Drive for relationships, harmony, cooperation, and social connection

**Goal Orientation Theory (Elliot)**
- Mastery-Approach: Driven by learning, skill acquisition, self-improvement
- Mastery-Avoidance: Driven by avoiding incompetence and failure
- Performance-Approach: Driven by competition, outperforming others, proving ability
- Performance-Avoidance: Driven by avoiding failure and hiding inadequacy

## Assessment Process

### Autonomy-Competence-Relatedness Evaluation

**Diagnostic Questions (Autonomy)**:
1. How important is independence and freedom of choice to this stakeholder?
2. Do they resist directive leadership or thrive with clear guidance?
3. Do they prefer flexibility in how tasks are accomplished?
4. How do they react when their input isn't sought in decisions?
5. Do they demonstrate self-direction or wait for instructions?

**Diagnostic Questions (Competence)**:
1. How much do they value mastery and skill development?
2. Do they seek feedback on performance and learning progress?
3. How important are challenging projects and growth opportunities?
4. Do they feel motivated by expanding their expertise?
5. How do they respond to skill gaps - address them or avoid them?

**Diagnostic Questions (Relatedness)**:
1. How much do they prioritize social connection and team belonging?
2. Do they prefer collaborative work or individual contribution?
3. How important is being part of a like-minded community?
4. Do they seek recognition from peers or from formal authority?
5. How much do they value relationships in professional decisions?

### Achievement-Power-Affiliation Profiling

**Diagnostic Questions (Achievement)**:
1. Do they focus on measurable results and performance metrics?
2. How much do they enjoy competitive scenarios and winning?
3. Do they set high personal standards and goals?
4. How important are achievements and milestones to their identity?
5. Do they prefer working on complex, challenging problems?

**Diagnostic Questions (Power)**:
1. How much do they value influence, status, and control?
2. Do they seek leadership roles and decision-making authority?
3. How important is being recognized as an expert or authority?
4. Do they want to impact strategic direction and organizational decisions?
5. How do they respond to hierarchies - respect or challenge them?

**Diagnostic Questions (Affiliation)**:
1. How much do they value harmonious relationships and team cohesion?
2. Do they prioritize consensus and agreement in decisions?
3. How important is being liked and accepted by colleagues?
4. Do they prefer collaborative decisions or swift individual action?
5. How do they respond to conflict - seek resolution or avoid?

### Goal Orientation Assessment

**Diagnostic Questions (Mastery vs Performance)**:
1. Are they more motivated by learning new skills or proving existing abilities?
2. Do they view challenges as learning opportunities or threats to competence?
3. How do they respond to setbacks - persist and improve or retreat?
4. Do they compare themselves to others or to their own growth?
5. Is their feedback-seeking about improvement or validation?

**Diagnostic Questions (Approach vs Avoidance)**:
1. What drives them more: achieving gains or avoiding losses?
2. Do they focus on opportunities or threats in new initiatives?
3. Are they proactive in pursuing goals or reactive in avoiding problems?
4. How do they frame decisions: "what could we gain" vs "what could we lose"?
5. Do they take calculated risks or play it safe?

## Tactical Application

### For High Autonomy Stakeholders
- Frame proposals as **choices**: "You could choose to..." vs "You must..."
- **Emphasize agency**: Highlight their control over implementation approach
- **Provide options**: Multiple valid paths showing their influence
- **Respect independence**: Avoid micromanagement language
- **Recognize self-direction**: "You recognized that..." not "We told you..."

### For High Competence Seekers
- **Lead with learning**: "You'll master cutting-edge techniques..."
- **Emphasize growth**: Position as skill-building opportunity
- **Provide challenge**: Show meaningful problem-solving
- **Enable expertise**: "This leverages your deep knowledge and expands it..."
- **Support mastery**: Clear progression from novice to expert

### For High Relatedness Prioritizers
- **Highlight collaboration**: "You'll work closely with [team/community]..."
- **Emphasize belonging**: "You'll be part of a community of..."
- **Show social benefits**: Team alignment, shared mission, mutual support
- **Create connection**: Point to peers also involved
- **Foster inclusion**: "This brings everyone together around..."

### For High Achievement Motivation
- **Lead with metrics**: "This will increase [metric] by X%..."
- **Competitive framing**: "Beat [competitor], exceed [benchmark]..."
- **Milestone emphasis**: "Here are concrete deliverables..."
- **Win-loss clarity**: "This positions us to win in [market]..."
- **Goal focus**: Clear, measurable, ambitious targets

### For High Power Motivation
- **Authority expansion**: "This positions you as the authority in..."
- **Influence expansion**: "You'll lead the strategic direction for..."
- **Status recognition**: "This establishes your reputation as..."
- **Control emphasis**: "You determine the approach and pace..."
- **Strategic positioning**: "This secures your place in the leadership structure..."

### For High Affiliation Motivation
- **Team benefits**: "Your team will be stronger because..."
- **Harmony emphasis**: "This aligns everyone around shared values..."
- **Relationship building**: "You'll strengthen bonds with [key stakeholders]..."
- **Consensus framing**: "Everyone benefits when we..."
- **Social good**: "This is good for the community/team/organization..."

### For Mastery-Approach Orientation
- **Learning emphasis**: "Gain expertise in emerging [field]..."
- **Growth trajectory**: "Progress from [current] to [advanced]..."
- **Deep knowledge**: "Build comprehensive understanding of..."
- **Continuous improvement**: "Ongoing development and refinement..."
- **Stretch challenge**: "Take your skills to the next level..."

### For Performance-Approach Orientation
- **Competitive advantage**: "Outperform [competitors] by [metric]..."
- **Public recognition**: "Visible success in [domain]..."
- **Winning focus**: "This positions you to win..."
- **Benchmark beating**: "Exceed industry standards..."
- **Status achievement**: "Establish reputation as top performer..."

### For Performance-Avoidance Orientation
- **Risk mitigation**: "Prevent falling behind [competition]..."
- **Competence protection**: "Avoid [specific failure scenario]..."
- **Safe success**: "Proven approach reduces failure risk..."
- **Reputation protection**: "Maintain your standing in..."
- **Failure prevention**: "This prevents the [specific problem] that could derail..."

### For Mastery-Avoidance Orientation
- **Competence maintenance**: "Keep your skills current and relevant..."
- **Obsolescence prevention**: "Prevent technology/skills from becoming outdated..."
- **Capability preservation**: "Maintain what you've built..."
- **Expertise relevance**: "Ensure your expertise stays in demand..."
- **Knowledge protection**: "Stay ahead of disruption by..."

## Framework Integration

**With Kahneman (Cognitive Biases)**: Achievement motivation drives System 1 decisions (quick wins); competence motivation engages System 2 analysis (mastery of complexity)

**With Cialdini (Persuasion)**: Social proof works powerfully for high-affiliation; scarcity/authority resonate with high-power; consistency/commitment with high-achievement

**With Traits & Values**: High openness + achievement = entrepreneurial drive; high conscientiousness + competence = technical mastery; high agreeableness + affiliation = team leadership

**With Regulatory Focus**: Achievement motivation aligns with promotion focus (gains); power motivation with control; affiliation with relationship security

## Output Template

```yaml
Motivational Profile:
  autonomy_level: "X/10" (independence orientation)
  competence_level: "X/10" (mastery/growth orientation)
  relatedness_level: "X/10" (social connection orientation)

  achievement_drive: "X/10" (goal completion focus)
  power_orientation: "X/10" (influence/status focus)
  affiliation_priority: "X/10" (relationship/harmony focus)

  dominant_goal_orientation: "mastery-approach | mastery-avoidance | performance-approach | performance-avoidance"
  approach_avoidance_ratio: "X% approach, Y% avoidance"

Behavioral Implications:
  - Primary motivator: [what moves them to action]
  - Demotivators: [what discourages them]
  - Decision driver: [what they prioritize]
  - Risk approach: [how they handle uncertainty]

Persuasion Strategy:
  primary_frame: [autonomy | competence | relatedness | achievement | power | affiliation | mastery | performance]
  messaging:
    - Lead with: "[specific motivation]"
    - Emphasize: "[what matters to them]"
    - Avoid: "[what demotivates them]"
    - Connect to: "[their goals/values]"

  tactical_actions:
    - [Concrete action aligned with motivation]
    - [Concrete action aligned with motivation]
    - [Concrete action aligned with motivation]

Caution Flags:
  - [Avoid this approach if motivation is X]
  - [This messaging may backfire with Y profile]
  - [Watch for these contradictions]
```

## Example Profiles

### Profile A: High Autonomy + Achievement + Performance-Approach
**Who**: Entrepreneurial executive, startup founder, independent contributor with high standards
**Motivation**: Freedom to pursue ambitious goals on own terms, measurable success, competitive positioning
**Persuade by**: "You decide the strategy and timeline. This gives you the competitive edge to dominate [market]."
**Avoid**: "We've established the process for this..." (too directive)

### Profile B: High Competence + Mastery-Approach + Affiliation
**Who**: Senior technical leader, mentor, expert who values growth and collaboration
**Motivation**: Deepening expertise, building team capabilities, continuous learning through others
**Persuade by**: "You'll develop advanced expertise and help your team grow alongside you."
**Avoid**: "This is simple and straightforward..." (too easy, not growth)

### Profile C: High Relatedness + Affiliation + Power
**Who**: Team leader, community builder, influential networker
**Motivation**: Strengthening relationships, being valued by peer group, organizing others
**Persuade by**: "You'll bring key people together and strengthen the entire community."
**Avoid**: "This requires individual effort with minimal collaboration..." (too isolating)

### Profile D: High Achievement + Performance-Approach + Power
**Who**: Rising executive, ambitious performer, competitive achiever
**Motivation**: Measurable wins, status advancement, visible success, competitive advantage
**Persuade by**: "This beats [competitor] and positions you as the leader in [domain]."
**Avoid**: "We all succeed together..." (dilutes personal achievement)

## Research Sources

- Self-Determination Theory: selfdeterminationtheory.org (95% credibility)
- McClelland's Acquired Needs: PeopleShift, BusinessBalls (75-80% credibility)
- Goal Orientation Theory: Educational Psychology, PMC (85-90% credibility)
- Regulatory Fit & Motivation Integration: Columbia Business School (90% credibility)
