# Framework 10: Trust & Risk Psychology (Trust Equation, Loss Aversion, Betrayal Aversion)

## Core Theories

**Trust Equation (Maister, Green, Galford)**
- Credibility: Expertise, knowledge, competence in relevant domain; demonstrated through credentials and case studies
- Reliability: Consistent action fulfillment; track record of following through on commitments; predictability and dependability
- Intimacy: Psychological safety, confidentiality, emotional connection; sense of security when sharing sensitive information
- Self-Orientation: Focus on others' interests vs. own interests; lower self-orientation increases trustworthiness significantly
- Formula: Trust = (Credibility + Reliability + Intimacy) / Self-Orientation
- Key insight: Self-Orientation denominator means a 10% increase in self-focus halves trustworthiness regardless of other factors

**Loss Aversion & Prospect Theory (Kahneman & Tversky)**
- Loss Aversion: Losses perceived as approximately 2.5x more painful than equivalent gains; asymmetric value perception
- Risk Perception: Individuals are risk-seeking when pursuing gains but risk-averse when avoiding losses; context-dependent
- Framing Effects: Identical outcomes produce different decisions based on gain vs. loss framing (e.g., "save 90% lives" vs. "lose 10% lives")
- Reference Point: Decisions anchored to current state; changes in reference point shift risk tolerance dramatically
- Aspiration Adaptation: Over time, individuals adapt to new outcomes and shift reference points upward

**Betrayal Aversion Theory**
- Betrayal Definition: Violation of trust norms by someone with whom trust was granted; "fear of being a sucker" (sugrophobia)
- Emotional Intensity: Betrayal damages trust more than equivalent economic losses; social violation carries higher cost
- Neural Basis: Anterior insula regulates betrayal possibility; emotional processing stronger than rational risk assessment
- Trust Recovery: Time and consistency required for recovery; varies based on trust depth and violation severity
- Organizational Impact: Betrayal decreases job satisfaction, increases turnover, triggers retaliation or resignation, erodes organizational culture

## Assessment Process

### Credibility-Reliability-Intimacy-Self-Orientation Evaluation

**Diagnostic Questions (Credibility)**:
1. What specific expertise or credentials does this stakeholder perceive you to have?
2. Do they reference your knowledge unprompted or seek your input on specific topics?
3. How often do they cite your track record when making decisions?
4. Do they trust your technical judgment or second-guess your recommendations?
5. What evidence have you provided of competence in their domain of concern?

**Diagnostic Questions (Reliability)**:
1. How consistently have you followed through on commitments with this stakeholder?
2. Do you meet deadlines, or do delays characterize your relationship?
3. How predictable are your actions and responses from their perspective?
4. Have you broken commitments, and if so, how did you recover?
5. Do they describe you as dependable in conversations with others?

**Diagnostic Questions (Intimacy)**:
1. How comfortable are they sharing sensitive information with you?
2. Do they confide challenges or concerns, or maintain professional distance?
3. Do they believe their confidential information is safe with you?
4. How emotionally open are they in interactions with you?
5. Do they describe you as someone they can trust personally, not just professionally?

**Diagnostic Questions (Self-Orientation)**:
1. In conversations, how much do you talk about your own needs vs. their needs?
2. Do you prioritize their interests or your own goals when they conflict?
3. How transparent are you about potential conflicts of interest?
4. Do you actively work to understand their perspective, or do you advocate your position?
5. Do they perceive you as genuinely interested in their success independent of your benefit?

### Loss Aversion & Risk Perception Assessment

**Diagnostic Questions (Loss Aversion Intensity)**:
1. How much do they emphasize potential losses or downsides in decisions?
2. Do they require 2.5x+ evidence of gains to offset risks?
3. How vividly do they describe worst-case scenarios?
4. Do they prioritize "not losing what we have" over "gaining new opportunities"?
5. How much does fear of failure influence their decision-making?

**Diagnostic Questions (Risk Tolerance)**:
1. How comfortable are they taking calculated risks for potential gains?
2. Do they prefer proven approaches or explore novel strategies?
3. How do they respond to uncertainty—paralysis or exploration?
4. What percentage of upside potential justifies downside risk in their view?
5. Do they describe themselves as risk-averse, moderate, or risk-seeking?

**Diagnostic Questions (Framing Sensitivity)**:
1. Do they respond differently to "prevent the $100K loss" vs. "gain $100K"?
2. How much does problem framing shift their risk tolerance?
3. Do statistics presented as gains vs. losses influence their decisions?
4. Are they aware of their framing biases, or unconscious of them?
5. Can you successfully reframe a decision to shift their perspective?

**Diagnostic Questions (Reference Point Dependency)**:
1. What does "success" or "normal" mean to them currently?
2. How much does their current situation anchor their aspirations?
3. Do previous wins raise their baseline expectations?
4. How do they react to outcomes relative to their current state vs. objectively?
5. How do they define "fair deal" or "acceptable outcome"?

### Betrayal Aversion Assessment

**Diagnostic Questions (Betrayal Sensitivity)**:
1. How strongly do they react to perceived violations of trust norms?
2. Have past betrayals shaped their current trust patterns?
3. Do they assume good faith or presume potential betrayal?
4. How do they describe their most significant betrayal experience?
5. Does a single violation of trust permanently damage your relationship?

**Diagnostic Questions (Social Risk Tolerance)**:
1. How comfortable are they relying on others' good intentions?
2. Do they require explicit guarantees before trusting?
3. How much do they worry about "being a sucker"?
4. Do they verify information or trust others' representations?
5. How do they balance autonomy (not relying on others) with efficiency (delegation)?

**Diagnostic Questions (Trust Recovery Time)**:
1. If you violated a commitment, how long would recovery take?
2. What specific actions would demonstrate restored trustworthiness?
3. Do they offer second chances, or is trust a one-time currency?
4. How do they distinguish intentional betrayal from honest mistakes?
5. What level of accountability would they require before re-engaging?

**Diagnostic Questions (Trust History)**:
1. Who do they currently trust deeply, and what earned that trust?
2. How many significant betrayals have they experienced?
3. Do they have a history of trusting selectively or broadly?
4. How do they describe trust relationships that lasted decades?
5. What patterns characterize people they refuse to trust?

## Tactical Application

### For High Credibility Perception Stakeholders
- **Lead with expertise**: "Based on 15 years in this domain and 200+ implementations..."
- **Emphasize credentials**: Show certifications, publications, case studies, and expert recognition
- **Provide evidence**: Data, research, third-party validation, and peer recognition
- **Establish authority**: Position as thought leader through speaking, writing, research
- **Demonstrate mastery**: Show depth of knowledge that goes beyond surface-level understanding

### For Low Credibility Stakeholders
- **Lead with humility**: "I may be learning in this area, but here's what research shows..."
- **Cite external experts**: Reference established authorities rather than claiming expertise
- **Provide data**: Let numbers and research speak rather than personal assertion
- **Use incremental proof**: Start with small commitments and build credibility through delivery
- **Acknowledge gaps**: Show awareness of limitations rather than overconfidence

### For High Reliability Stakeholders
- **Lead with track record**: "I've delivered X on time for Y clients, including [specific names]..."
- **Emphasize consistency**: Show pattern of promise fulfillment and deadlines met
- **Provide guarantees**: Offer warranties, SLAs, or accountability mechanisms
- **Document commitments**: Make promises explicit and measurable
- **Establish rhythm**: Create predictable patterns of communication and delivery

### For Low Reliability Stakeholders
- **Lead with structure**: "Here's the specific plan with checkpoints and contingencies..."
- **Break into phases**: Deliver in small, verifiable increments
- **Over-communicate**: Provide frequent updates before asked
- **Build accountability**: Establish clear ownership and escalation paths
- **Create momentum**: Show early wins to establish positive trend

### For High Intimacy Potential Stakeholders
- **Lead with openness**: "I want to understand what's really driving this decision for you..."
- **Demonstrate vulnerability**: Share relevant challenges and learnings
- **Create psychological safety**: Explicitly state confidentiality and non-judgment
- **Ask deeper questions**: Show genuine interest in their experience and concerns
- **Share relevant context**: Help them understand your motivations and constraints

### For Low Intimacy/Guarded Stakeholders
- **Lead with professionalism**: "Let's focus on what we can objectively measure..."
- **Respect boundaries**: Don't push for personal connection or emotional disclosure
- **Provide written documentation**: Reduce ambiguity through explicit agreements
- **Maintain distance appropriately**: Professional warmth without forced familiarity
- **Demonstrate competence over connection**: Build trust through delivery, not relationship

### For High Self-Orientation Stakeholders
- **Lead with their benefit**: "This positions you to [specific advantage they value]..."
- **Align incentives**: Make clear how your success creates their success
- **Show mutual benefit**: Frame collaboration as win-win, not favor-seeking
- **Respect their priorities**: Don't ask them to subordinate their interests
- **Be transparent about trade-offs**: Acknowledge where interests diverge and find common ground

### For Low Self-Orientation Perception
- **Lead with broader impact**: "This benefits the team/company/community because..."
- **Emphasize shared values**: "We both care about [mission/quality/users]..."
- **Highlight collective success**: Frame outcomes as team wins
- **Acknowledge their altruism**: Recognize when they prioritize others' interests
- **Appeal to purpose**: Connect to their intrinsic motivations beyond personal gain

### For Loss-Averse Stakeholders
- **Lead with risk mitigation**: "Here's how we prevent the worst-case scenario..."
- **Emphasize protection**: "This safeguards what you've already built..."
- **Provide guarantees**: Warranties, insurance, escape clauses, contingency plans
- **Quantify downside**: "Maximum exposure is [specific amount]"
- **Show what could be lost**: "If we don't act, we risk losing [X]"

### For Risk-Seeking Stakeholders
- **Lead with opportunity**: "This positions us to capture significant upside..."
- **Emphasize gains**: "Potential upside is [multiple of investment]"
- **Show competitive advantage**: "This creates distance from competitors"
- **Highlight growth**: "This scales to [X opportunity size]"
- **Create urgency**: "Window of opportunity closes in [timeframe]"

### For Betrayal-Averse Stakeholders
- **Lead with transparency**: "Here's exactly how this works, with no hidden costs..."
- **Provide explicit guarantees**: Written commitments, money-back guarantees, escrow arrangements
- **Enable verification**: Third-party audits, transparent metrics, accessible data
- **Establish accountability**: Clear consequences for failures, escalation paths
- **Use incremental commitment**: Start with low-risk trust to build confidence
- **Disclose conflicts**: Proactively reveal any potential competing interests
- **Use social proof**: "Others in similar situations succeeded without betrayal"

### For Trust-Resilient Stakeholders
- **Lead with partnership**: "Let's work through this together..."
- **Assume good faith**: Presume intentions are positive despite challenges
- **Acknowledge growth**: "This relationship has deepened through overcoming challenges"
- **Focus on recovery**: "Here's how we've fixed similar issues before"
- **Celebrate resilience**: Recognize trust that survived difficulties
- **Invest in relationship**: Spend time deepening connection, not just transactional interaction

## Framework Integration

**With Kahneman (Cognitive Biases)**: Loss aversion shapes System 1 decisions (quick trust judgments based on emotional assessment). Betrayal aversion activates availability heuristic (overweighting past betrayal experiences). Credibility drives anchoring (first impression of trustworthiness heavily influences subsequent assessment). Framing effects determine whether stakeholder frames decision as loss prevention or gain pursuit.

**With Cialdini (Persuasion)**: Trust Equation maps directly to Cialdini's principles—Credibility resonates with Authority, Reliability with Consistency/Commitment, Intimacy with Liking, Self-Orientation inversely with Reciprocity. Loss aversion amplifies scarcity and authority appeals. Betrayal aversion makes social proof particularly powerful (others' successful trust reduces betrayal fear).

**With Motivational Psychology (Frameworks 08)**: Loss aversion inversely correlates with achievement motivation (loss-averse pursue mastery-avoidance; risk-seeking pursue mastery-approach). Trust systems align with autonomy + relatedness (autonomy through transparency, relatedness through intimacy). Betrayal aversion impacts affiliation motivation (damages group cohesion).

**With Personality Psychology (Framework 09)**: High Extraversion stakeholders build intimacy quickly; High Agreeableness assume good faith (low betrayal aversion). High Conscientiousness require explicit reliability; High Openness accept novel trust models. Regulatory fit: Prevention-focused stakeholders heavily weight loss aversion; Promotion-focused focus on trust gains. Type A personalities require credibility demonstration; Type B build trust through process.

**Cross-Framework Pattern**: Trust Equation provides foundation for all other persuasion frameworks. Loss aversion modulates risk perception across Frameworks 08 & 09. Betrayal aversion determines whether stakeholder will grant opportunity to build credibility, reliability, and intimacy.

## Output Template

```yaml
Trust & Risk Profile:
  credibility_perception: "X/10" (perceived expertise and competence)
  reliability_assessment: "X/10" (track record of promise fulfillment)
  intimacy_level: "X/10" (psychological safety and emotional connection)
  self_orientation_detection: "X/10" (focus on others' interests; lower is more trustworthy)

  calculated_trust_score: "X/10" (derived from equation)
  trust_stability: "stable | fluctuating | declining" (trend over time)

  loss_aversion_intensity: "X/10" (perceived pain of losses vs. gains)
  risk_tolerance: "X/10" (comfort with uncertainty and calculated risks)
  framing_sensitivity: "X/10" (susceptibility to gain/loss framing effects)
  reference_point_anchoring: "X/10" (how much current state influences decisions)

  betrayal_aversion_level: "X/10" (fear of trust norm violations)
  betrayal_sensitivity_trigger: "[describe what constitutes betrayal for this stakeholder]"
  trust_recovery_time: "X weeks/months" (estimated time to rebuild after violation)
  social_risk_tolerance: "X/10" (comfort relying on others' good intentions)

Behavioral Implications:
  - Trust drivers: [what builds and maintains trust with this stakeholder]
  - Trust dealbreakers: [what destroys trust immediately]
  - Decision driver under certainty: [what factors they prioritize]
  - Decision driver under uncertainty: [how loss aversion/risk tolerance shapes choices]
  - Vulnerability: [what emotional triggers affect trust]

Persuasion Strategy:
  primary_trust_frame: "[credibility | reliability | intimacy | reducing self-orientation]"

  messaging:
    - Lead with: "[trust element they most value or most doubt]"
    - Emphasize: "[evidence of trustworthiness in their domain]"
    - Avoid: "[actions that trigger betrayal concerns]"
    - Highlight: "[track record that demonstrates consistency]"
    - Establish: "[psychological safety through transparency]"

  risk_framing:
    - If loss-averse: "Lead with protection and risk mitigation"
    - If risk-seeking: "Lead with opportunity and upside potential"
    - Framing recommendation: "[gain-framing | loss-framing | context-dependent]"

  tactical_actions:
    - [Specific credibility-building action]
    - [Specific reliability demonstration]
    - [Specific intimacy-creation action]
    - [Specific self-orientation reduction]
    - [Specific betrayal-aversion mitigation]

Caution Flags:
  - Do NOT assume quick trust building; credibility takes time
  - Do NOT overstate capabilities; reliability violations destroy trust disproportionately
  - Do NOT be inauthentic; intimacy requires genuine engagement
  - Do NOT make trust all about you; self-orientation is trust-killing
  - Do NOT ignore betrayal history; past violations color current trust decisions
  - Watch for: [specific behavioral red flags indicating trust deterioration]
```

## Example Profiles

### Profile A: High Credibility + Low Self-Orientation + Risk-Seeking
**Who**: Trusted technical advisor, strategic consultant, thought leader
**Motivation**: Building expertise-based influence; helping others succeed; solving complex problems
**Trust Strategy**: "Your deep expertise in [domain] is exactly what we need. You've demonstrated mastery through [case studies]. I trust your judgment on this risk because your track record shows you understand the tradeoffs better than anyone."
**Avoid**: "We'll figure it out as we go" (undermines credibility); "This is what works for me" (raises self-orientation concerns)

### Profile B: High Reliability + High Intimacy + Loss-Averse
**Who**: Trusted partner, long-term collaborator, ally with proven consistency
**Motivation**: Maintaining stable relationships; protecting what's been built; deepening trust through consistency
**Trust Strategy**: "We've delivered on every commitment for 5 years. You know exactly how I operate—no surprises, no shortcuts. Let's walk through the risks together so you understand exactly what we're protecting."
**Avoid**: "Trust me on this" (requires demonstrated reliability, not assertion); new untested approaches (threatens consistency)

### Profile C: Low Trust History + High Betrayal Aversion + Guarded
**Who**: Stakeholder burned by past experiences; protective of organization; verification-oriented
**Motivation**: Preventing repeat betrayals; protecting team; ensuring accountability
**Trust Strategy**: "I understand why you'd be cautious—betrayal destroys organizations. Here's a detailed plan with third-party verification, accountability mechanisms, and explicit escape clauses. You maintain control throughout. Let's start small so you can verify before expanding."
**Avoid**: "You should trust me" (tone-deaf to their history); vague commitments (triggers betrayal fears); rushed relationship-building

### Profile D: Balanced Trust Development + Risk-Seeking + High Extraversion
**Who**: Entrepreneurial stakeholder, growth-focused executive, new relationship opportunity
**Motivation**: Pursuing opportunities; building capable partnerships; rapid scaling
**Trust Strategy**: "This positions us to capture a major market opportunity. Your confidence in my technical judgment combined with your market insight creates real leverage. Let's move fast on the high-confidence areas while validating the riskier bets."
**Avoid**: Excessive caution or risk mitigation (seems timid to growth-focused mindset); slow relationship development (they move fast)

## Research Sources

- Trust Equation: Maister, Green, Galford (2001) "The Trusted Advisor" (95% credibility, Tier 1), validated across 50+ business consultancy case studies
- Loss Aversion & Prospect Theory: Kahneman & Tversky (1979) foundational work (95% credibility, Tier 1), 2024 global validation study across 19 countries (90% credibility, Tier 1)
- Betrayal Aversion: DeBruine (2005) "Trustworthy behaviour increases with relationship value in trust games" (90% credibility, Tier 1), organizational impact research (85% credibility, Tier 2)
- Trust Recovery: Dirks, Lewicki & Zaheer (2009) on organizational trust repair (90% credibility, Tier 1)
- Framing Effects: Tversky & Kahneman (1981) classic framing study (95% credibility, Tier 1)
- Betrayal Aversion Brain Basis: Quervain et al. (2004) anterior insula activation in trust games (90% credibility, Tier 1)
