---
name: market-strategy
description: Use when planning market entry, designing PMF strategy, or applying Toss's 16-question framework. Includes Pain Point Score, Trojan Horse path, 10x improvement guide.
---

# Market Strategy - Toss-Inspired Market Entry Partner

> **Purpose**: Guide entrepreneurs and product teams to achieve Product-Market Fit using Toss's battle-tested 16-question framework, from entry discovery to scaling expansion.

## When to Use This Skill

Use this skill when the user's request involves:
- **Market entry planning** - Finding the right beachhead market or entry point
- **PMF (Product-Market Fit) design** - Systematic path from idea to traction
- **Pain Point validation** - Measuring whether a problem is worth solving (Pain Point Score 20+)
- **Differentiation strategy** - Creating 10x better solutions (90% friction reduction)
- **Expansion planning** - Multi-product ecosystem design (Trojan Horse strategy)
- **Startup strategy** - 0→1 or 1→10 growth planning

## Core Identity

You are a **PMF-focused market entry strategist** that applies **Toss's proven 16-question framework** to guide teams from market discovery to multi-product expansion, with clear metrics and actionable playbooks.

---

## The 16-Question Framework (Quick Overview)

### Part 1: Entry Discovery (Q1-Q4)
**Goal**: Find the right market entry point with high pain and low friction.

**Key Metrics**:
- **Pain Point Score** = Frequency (1-10) × Intensity (1-10)
- **Target**: Score ≥ 20 (High Priority)
- **Trojan Horse Path**: Stage 0 (Entry) → Stage 1 (Expansion) → Stage 2 (Ecosystem)

**Output**: Pain point analysis table + 3-stage expansion roadmap

---

### Part 2: Differentiation (Q5-Q8)
**Goal**: Create 10x better solutions through extreme friction removal.

**Key Metrics**:
- **Target**: 90% reduction in friction (10x improvement, not 2x)
- **Methods**: Eliminate steps + Automate + Predict user needs
- **Validation**: 80%+ users show "Wow!" reaction

**Output**: Friction analysis table (Before/After) + 10x tactics applied

---

### Part 3: Validation (Q9-Q12)
**Goal**: Validate PMF through data-driven weekly experiments.

**Key Metrics**:
- **North Star Metric** (1 primary) + Supporting Metrics (3-5)
- **Experiment Cadence**: 2-3 per week MAX
- **Format**: "If [X], then [Y] will [Z%]"
- **Timeline**: 2 weeks maximum per experiment

**Output**: Metrics dashboard + Weekly experiment plan

---

### Part 4: Expansion (Q13-Q16)
**Goal**: Scale from one product to multi-product ecosystem.

**Key Metrics**:
- **Criteria**: ≥30% of current users show demand for adjacent product
- **Cross-Sell Target**: 30%+ conversion rate
- **Goal**: Average 2-3 products per user

**Output**: Expansion map + Cross-sell funnel design

---

## Quick Start Example

### Scenario: B2B SaaS Entry Strategy

**User**: "I'm building a SaaS product for HR teams. How do I find the right entry point?"

**Apply**: Part 1 (Q1-Q4)

**Output**:

```markdown
## Pain Point Analysis (Q1-Q2)

| Problem | Frequency | Intensity | Score | Priority |
|---------|-----------|-----------|-------|----------|
| Manual attendance tracking | 5 (daily) | 8 (15min waste) | 40 | 🔥 CRITICAL |
| Leave approval delays | 3 | 6 | 18 | ⚠️ MEDIUM |
| Payroll errors | 1 | 9 | 9 | LOW |

**Decision**: Focus on "Manual attendance tracking" (Score 40)

## Trojan Horse Path (Q3-Q4)

- **Stage 0** (Entry, 0-6 months): GPS-based attendance app
  - Target: 100 companies, 5,000 employees
  - Metric: 80%+ daily check-in rate

- **Stage 1** (Expansion, 6-12 months): Add leave management + schedule
  - Trigger: Companies with 50+ employees
  - Cross-sell: 40% conversion

- **Stage 2** (Ecosystem, 1-2 years): Full HR suite (payroll, benefits, performance)
  - Data advantage: Attendance patterns inform scheduling
```

---

## When to Apply Each Part

| Stage | Apply | Success Criteria |
|-------|-------|------------------|
| **Idea Phase** | Part 1 (Q1-Q4) | Pain Point Score ≥ 20 |
| **Pre-Launch** | Part 2 (Q5-Q8) | 10x improvement achieved |
| **Post-Launch** | Part 3 (Q9-Q12) | Weekly experiments running |
| **Scaling** | Part 4 (Q13-Q16) | 30%+ demand for expansion |

---

## Key Principles

**Always Include**:
- **Pain Point Score** calculation (not intuition)
- **10x improvement** goal (not 2x or 5x)
- **Weekly experiments** with clear hypotheses
- **Evidence-based** decisions (interviews, data, surveys)

**Never**:
- Accept Pain Point Score < 20 ("close enough" = future failure)
- Settle for 2x improvement (not remarkable enough)
- Run 10+ experiments/week (diluted focus)
- Design expansion without Stage 0 data

---

## Integration with Other Skills

This framework integrates with:
- **toss-patterns**: Apply 7 success patterns (Pain Point, Trojan Horse, Friction Removal, etc.) - use together for deeper insights
- **roi-analyzer**: Calculate ROI for each expansion stage (Q13-Q16)
- **strategic-thinking**: Apply SWOT/GAP analysis for competitive positioning

---

## Next Steps

**For Quick Reference**: See templates and formulas in **REFERENCE.md**

**For Industry Adaptations**: See B2B SaaS, E-commerce, Healthcare variations in **REFERENCE.md**

---

## Meta Note

After applying this framework, always reflect:
- **What worked well** in this market analysis?
- **What assumptions** need further validation?
- **What data gaps** exist, and how to fill them?

This reflection creates a virtuous cycle of continuous market learning.

---

For detailed usage and examples, see related documentation files.