# Thinking Framework - Practical User Guide v4.0

**Quick navigation**: [Problem Type Selector](#problem-type-selector) | [Examples](#real-world-examples) | [Common Mistakes](#common-mistakes) | [Agent Patterns](#agent-patterns)

---

## Problem Type Selector

### 0. Always First: Problem Definition
→ [reference/problem-definition.md](reference/problem-definition.md)
- Is this the real problem or a symptom?
- How will you measure success?

### 🔍 "Find WHY" → Root Cause
- **[5 Why](reference/5-why.md)** - Single causal chain → `sequentialthinking`
- **[Fishbone](reference/fishbone.md)** - Multiple factors → `collaborativereasoning`

### 💡 "Innovate/Create" → Innovation
- **[SCAMPER](reference/scamper.md)** - Modify existing ideas (15-30min) → `collaborativereasoning`
- **[First Principles](reference/first-principles.md)** - Fundamental reconstruction (1-2hr) → `mentalmodel`
- **[TRIZ](reference/triz.md)** - Technical contradiction resolution (30-60min) → `mentalmodel` + `designpattern`
- **[Design Thinking](reference/design-thinking.md)** - User-centric (days-weeks) → `collaborativereasoning`

⚠️ AVOID DMAIC, Kepner-Tregoe for innovation (0% success rate)

### 🎯 "Strategy/Decision" → Strategy
- **[SWOT](reference/swot.md)** + 2x2 Matrix + **[GAP Analysis](reference/gap-analysis.md)** → `decisionframework` + `visualreasoning`

⚠️ AVOID SWOT alone (33% failure rate)

### ⚙️ "Improve Process" → Process
- **[Pareto](reference/pareto.md)** - Data-driven prioritization → `decisionframework`
- **[PDCA](reference/pdca.md)** - Iterative improvement → `scientificmethod`

### ⚡ "Fast Decision" → Decision
- **[OODA Loop](reference/ooda-loop.md)** - Rapid/dynamic situations → `scientificmethod`
- **[Kepner-Tregoe](reference/kepner-tregoe.md)** - High-stakes systematic analysis → `decisionframework`

### 🤝 "Resolve Conflicting Views" → Synthesis
- **[Dialectic](reference/dialectic.md)** - Thesis-Antithesis-Synthesis → `structuredargumentation`

---

## Real-World Examples

### Example 1: API Performance Degradation (Root Cause)
**Problem**: Response time 100ms → 2000ms
**Complexity**: Medium → Orchestrator + MethodExecutor
**Method**: 5 Why with `sequentialthinking`
```
Why 1: DB query 1800ms → Why 2: Full table scan
→ Why 3: Missing index → Why 4: Migration omitted
→ Why 5: No performance testing
```
**Fix**: Add index + Implement load testing

### Example 2: Startup Strategy (Strategy - Complex)
**Problem**: 3 months runway, unclear profitability
**Complexity**: Complex → Full agent pipeline (parallel)
**Method**: SWOT + GAP with `decisionframework` + `visualreasoning`
```
Agent Flow:
1. ProblemDefiner: Clarify business model constraints
2. MethodExecutor (SWOT): Analyze S/W/O/T in parallel
3. StrategyArchitect: Create 2x2 + GAP action plan

Result:
SWOT: Strengths(tech) vs Weaknesses(no sales process)
2x2: Tech leverage(High) + Partnership sales(High)
GAP: $0 MRR → $50K MRR (90-day action plan)
```

### Example 3: Technical Contradiction (TRIZ)
**Problem**: Speed↑ vs Reliability↓ trade-off
**Complexity**: Medium → Orchestrator + MethodExecutor
**Method**: TRIZ with `mentalmodel` + `designpattern`
```
Principle #10 Prior Action: CDN deployment
Principle #3 Local Quality: Focus reliability on critical paths only
```
**Solution**: Hybrid approach

---

## Agent Patterns (v4.0)

### Pattern Selection by Complexity

| Complexity | Pattern | Agent Flow |
|------------|---------|------------|
| Simple | Direct | Orchestrator only |
| Medium | Specialist | Orchestrator → MethodExecutor → Orchestrator |
| Complex | Parallel | Orchestrator → ProblemDefiner → MethodExecutors (parallel) → StrategyArchitect |

### When to Use Each Pattern

**Direct Pattern**:
- Clear, single-cause problems
- "Why did this specific build fail?"
- "What's the Pareto distribution of our bugs?"

**Specialist Pattern**:
- Moderate complexity with clear method
- "Analyze our API performance issues"
- "Create a SWOT for our product"

**Parallel Pattern**:
- Systemic problems with 5+ factors
- "Design a migration strategy for microservices"
- "Develop a 3-year competitive strategy"

---

## Common Mistakes

| Mistake | Symptom | Solution |
|---------|---------|----------|
| Skip Problem Definition | Perfectly solving wrong problem | Always start here |
| Method-problem mismatch | Method feels forced | Check INDEX.md |
| SWOT alone | Long list, no action | Add 2x2 Matrix |
| Over-engineering | 60min on 5min problem | Assess complexity first |
| Surface solution | Problem keeps recurring | Use 5 Why for root cause |
| Wrong agent pattern | Slow simple analysis | Use complexity routing |
| Skip quality gates | Low confidence results | Enforce G1-G4 protocol |

---

## Complexity-Based Routine Selection

| Complexity | Indicators | Routine | Quality Gates |
|------------|------------|---------|---------------|
| Simple | 1-2 steps, clear path | B (Direct) | G4 only |
| Medium | 3-5 factors, some ambiguity | B or C (Specialist) | G2 + G4 |
| Complex | 5+ factors, high interdependencies | A (Parallel) | All (G1-G4) |

---

## Quality Gate Reference

| Gate | Stage | Checks |
|------|-------|--------|
| G1 | Problem Definition | Clarity, specificity, boundedness |
| G2 | Method Selection | Problem-method fit |
| G3 | Analysis | Depth, evidence, logic |
| G4 | Integration | Coherence, completeness, actionability |

---

**Version**: 4.0.0 | **Type**: Practical Guide
