# Thinking Methods Reference - Index

Catalog of 15 proven thinking methodologies

---

## Quick Selection

### By Problem Type

| Problem Type | Recommended Methods |
|--------------|---------------------|
| **Problem Clarification** | [Problem Definition](problem-definition.md) ← Always first |
| **Root Cause** | [5 Why](5-why.md) • [Fishbone](fishbone.md) |
| **Creative Innovation** | [SCAMPER](scamper.md) • [TRIZ](triz.md) • [Design Thinking](design-thinking.md) |
| **Strategic Planning** | [SWOT](swot.md) • [GAP Analysis](gap-analysis.md) |
| **Technical Problems** | [First Principles](first-principles.md) • [TRIZ](triz.md) |
| **Process Improvement** | [Pareto](pareto.md) • [PDCA](pdca.md) • [GAP Analysis](gap-analysis.md) |
| **Decision Making** | [OODA Loop](ooda-loop.md) • [Kepner-Tregoe](kepner-tregoe.md) |
| **Quality Control** | [DMAIC](dmaic.md) • [PDCA](pdca.md) |
| **View Integration** | [Dialectic](dialectic.md) |

---

## Method Catalog

### 0. Foundational (Required Starting Point)
- **[Problem Definition](problem-definition.md)** - Define the real problem | 30-60min | 100%

### 1. Root Cause Analysis
- **[5 Why](5-why.md)** - Repeated Why questions | 5-15min | 100%
- **[Fishbone](fishbone.md)** - Multi-dimensional cause analysis | 20-40min | 100%

### 2. Innovation & Breakthrough
- **[First Principles](first-principles.md)** - Reconstruct from basic truths | 1-2hr | 100%
- **[Design Thinking](design-thinking.md)** - User-centric innovation | days-weeks | 100%
- **[TRIZ](triz.md)** - Technical contradiction resolution | 30-60min | 100%
- **[SCAMPER](scamper.md)** - Creative modification prompts | 15-30min | 100%

### 3. Strategic Planning
- **[SWOT](swot.md)** - Strengths/Weaknesses/Opportunities/Threats | 30-45min | 75%*
- **[GAP Analysis](gap-analysis.md)** - Current→Target planning | 20-40min | 100%

### 4. Process Improvement
- **[Pareto](pareto.md)** - 80/20 Rule | 30-45min | 100%
- **[PDCA](pdca.md)** - Plan-Do-Check-Act | ongoing | 100%
- **[DMAIC](dmaic.md)** - Six Sigma | weeks-months | N/A**

### 5. Decision Making
- **[OODA Loop](ooda-loop.md)** - Observe-Orient-Decide-Act | min-hr | 100%
- **[Kepner-Tregoe](kepner-tregoe.md)** - Systematic analysis | 1-2hr | N/A**

### 6. Synthesis
- **[Dialectic](dialectic.md)** - Thesis-Antithesis-Synthesis | 30-60min | N/A***

---

## Anti-Patterns

| Problem Type | Avoid | Reason |
|--------------|-------|--------|
| Creative Innovation | DMAIC, Kepner-Tregoe | 0% success rate |
| Simple Problems | Divide & Conquer, Dialectic | Over-engineering |
| Strategic Decisions | SWOT alone | 33% failure rate* |

*Without 2x2 priority matrix
**Not suitable for creative innovation
***Over-engineering for simple problems

---

## Recommended Workflow

```
1. Problem Definition (30-60min) ← Always start here
   ↓
2. Select method by problem type (see table above)
   ↓
3. Execute & Validate
```

→ Quick selection: [QUICK_SELECTOR.md](QUICK_SELECTOR.md)
→ Method combinations: [METHOD_COMBINATIONS.md](METHOD_COMBINATIONS.md)

---

**Version**: 3.1.0 | **Total Methods**: 15

