# Method Combinations - Multi-Method Workflow Patterns

**Purpose**: Chain multiple thinking methods for complex problems requiring multiple perspectives.

**When to use**: Single method insufficient; problem requires analysis → ideation → execution phases.

---

## Core Principles

**Why Combine?**
- 5 Why finds cause but doesn't create solutions
- SWOT identifies situation but doesn't plan execution
- SCAMPER generates ideas but doesn't validate them

**Rules**:
- ✅ Use methods in logical sequence (analysis → ideation → execution)
- ✅ Let each method's output inform the next
- ✅ Validate outputs between methods
- ❌ Don't combine incompatible methods (DMAIC + SCAMPER)
- ❌ Don't use >4 methods (over-engineering)

---

## 5 Standard Patterns

### Pattern 1: Root Cause → Breakthrough → Iteration
**Workflow**: `5 Why → First Principles → PDCA`
**Use when**: Technical problem needs innovative solution
**Time**: 2-3 hours

```
5 Why → Find fundamental cause
  ↓
First Principles → Reconstruct innovative solution
  ↓
PDCA → Implement and iterate until stable
```

---

### Pattern 2: Strategic Planning Full Stack
**Workflow**: `Problem Definition → SWOT → 2x2 → GAP → OODA`
**Use when**: Business strategy from assessment to execution
**Time**: 3-5 hours

```
Problem Definition → Clarify true challenge
  ↓
SWOT → Assess situation
  ↓
2x2 Matrix → Prioritize actions
  ↓
GAP Analysis → Create execution plan
  ↓
OODA Loop → Monitor and adapt
```

---

### Pattern 3: Innovation Pipeline
**Workflow**: `Design Thinking → SCAMPER → TRIZ → Pareto`
**Use when**: User-centric product development
**Time**: 1-2 weeks

```
Design Thinking → Understand users, define problem
  ↓
SCAMPER → Generate variations
  ↓
TRIZ → Resolve technical contradictions
  ↓
Pareto → Prioritize critical 20% features
```

---

### Pattern 4: Complex System Debugging
**Workflow**: `Fishbone → Pareto → 5 Why → First Principles`
**Use when**: Multi-factor systemic issues
**Time**: 2-4 hours

```
Fishbone → Map all factors (People/Process/Tech/Env)
  ↓
Pareto → Find top 20% causing 80% impact
  ↓
5 Why → Drill down root causes
  ↓
First Principles → Redesign to prevent recurrence
```

---

### Pattern 5: Crisis Response
**Workflow**: `OODA → Fishbone → 5 Why → PDCA`
**Use when**: Fast-moving situation + need permanent fix
**Time**: Hours (immediate) + Days (follow-up)

```
OODA Loop → Immediate response (contain crisis)
  ↓
Fishbone → Map contributing factors
  ↓
5 Why → Find root cause
  ↓
PDCA → Implement permanent fix
```

---

## Selection Matrix

| Problem Type | Pattern | Methods | Time |
|--------------|---------|---------|------|
| Technical debt | 1 | 5 Why → First Principles → PDCA | 2-3h |
| Business strategy | 2 | SWOT → 2x2 → GAP → OODA | 3-5h |
| Product innovation | 3 | Design Thinking → SCAMPER → Pareto | 1-2w |
| System failure | 4 | Fishbone → Pareto → 5 Why | 2-4h |
| Crisis | 5 | OODA → Fishbone → PDCA | Hours-Days |

---

## Anti-Patterns

| Mistake | Why Bad | Fix |
|---------|---------|-----|
| Using all 15 methods | Analysis paralysis | Select 2-4 max |
| DMAIC + SCAMPER | Incompatible approaches | Check method compatibility |
| Skip validation between | Garbage in, garbage out | Validate each output |
| Force linear sequence | Real problems aren't linear | Adapt with OODA mindset |

---

## Best Practices

1. **Always start with Problem Definition**
2. **Map phases**: Analysis → Ideation → Execution → Synthesis
3. **Validate between methods** before proceeding
4. **Use OODA mindset** - adapt sequence based on results
5. **Stop at 2-4 methods** - more = likely over-engineering

---

**Version**: 3.1.0 | **Purpose**: Multi-method workflow patterns
