# Quick Method Selector - 60-Second Decision Guide

**Purpose**: Select the right thinking method in under 60 seconds

---

## 3-Step Selection Process

### STEP 1: Problem Definition (Required)
→ **[Problem Definition](problem-definition.md)** ← START HERE

✅ Checklist:
- Is this the real problem or just a symptom?
- How will you measure success?

---

### STEP 2: Classify Your Goal

| Goal | Category |
|------|----------|
| Find WHY | → ROOT CAUSE |
| Create something new | → INNOVATION |
| Strategy/big decision | → STRATEGY |
| Improve existing process | → PROCESS |
| Fast decision-making | → DECISION |
| Resolve conflicting views | → SYNTHESIS |

---

### STEP 3: Assess Complexity

| Complexity | Indicators | Time |
|------------|------------|------|
| Simple | Single cause, 1-2 steps | <30min |
| Medium | 3-5 factors, some ambiguity | 30-45min |
| Complex | 5+ factors, high interdependencies | 45-60min |

---

## Quick Selection Matrix

### 🔍 ROOT CAUSE
| Complexity | Method |
|------------|--------|
| Simple | [5 Why](5-why.md) |
| Medium | [Fishbone](fishbone.md) |
| Complex | 5 Why + First Principles |

### 💡 INNOVATION
| Complexity | Method |
|------------|--------|
| Simple | [SCAMPER](scamper.md) |
| Medium | [TRIZ](triz.md) |
| Complex | [Design Thinking](design-thinking.md) / [First Principles](first-principles.md) |

⚠️ **AVOID**: DMAIC, Kepner-Tregoe (0% success rate for innovation)

### 🎯 STRATEGY
| Complexity | Method |
|------------|--------|
| Simple | [GAP Analysis](gap-analysis.md) |
| Medium | [SWOT](swot.md) + 2x2 Matrix |
| Complex | SWOT + GAP |

⚠️ **CRITICAL**: SWOT requires 2x2 Priority Matrix (33% failure rate without)

### ⚙️ PROCESS
| Complexity | Method |
|------------|--------|
| Simple | [Pareto](pareto.md) |
| Medium | [PDCA](pdca.md) / [GAP Analysis](gap-analysis.md) |
| Complex | [DMAIC](dmaic.md) |

### ⚡ DECISION
| Complexity | Method |
|------------|--------|
| Simple-Medium | [OODA Loop](ooda-loop.md) |
| Complex | [Kepner-Tregoe](kepner-tregoe.md) |

### 🤝 SYNTHESIS
| Complexity | Method |
|------------|--------|
| Medium-Complex | [Dialectic](dialectic.md) |

---

## ⚠️ Common Mistakes

| Mistake | Solution |
|---------|----------|
| Skip Problem Definition | Always start here |
| Over-engineer simple problems | Assess complexity first |
| Use SWOT alone | Add 2x2 Matrix |
| Use DMAIC for innovation | Use SCAMPER/TRIZ instead |

---

**Version**: 3.1.0 | **Purpose**: 60-second method selection

