# Design Thinking

## Definition
User-centric innovation methodology: Empathize → Define → Ideate → Prototype → Test.

## Steps
1. **Empathize**: Observe and engage with users to understand their needs
2. **Define**: Articulate the problem from user perspective
3. **Ideate**: Generate wide range of creative solutions
4. **Prototype**: Build quick, low-cost versions of top ideas
5. **Test**: Get user feedback and iterate

## Pros
- Deeply user-centric
- Encourages creativity and experimentation
- Reduces risk through rapid prototyping

## Cons
- Resource-intensive (time, people, materials)
- Can be slow for fast-moving markets
- Requires access to real users

## Example
**Problem**: Hospital navigation is confusing for elderly patients

- **Empathize**: Shadow elderly patients, observe confusion and stress
- **Define**: Elderly patients can't read complex maps and get lost easily
- **Ideate**: Color-coded floors, audio guides, volunteer escorts, visual floor markers
- **Prototype**: Paint colored lines on floor leading to different departments
- **Test**: Observe patient navigation improved 70%, get feedback → adjust colors for color-blind patients

## When to Use
- User experience design
- Product development
- Service design
- Innovation projects

## Success Context
- **creative_innovation**: 100% success rate
- Best for: Human-centered problem solving
- Use with: Rapid prototyping and user testing
