# GAP Analysis

## Definition
Analyze the gap between current state (AS-IS) and desired state (TO-BE), then plan how to close it.

## Steps
1. **Current State**: Where are we now? (objective metrics)
2. **Target State**: Where do we want to be? (specific goals)
3. **Gap Identification**: What's missing? What needs to change?
4. **Action Plan**: How do we close each gap? (resources, timeline, responsibilities)

## Pros
- Clear improvement direction
- Actionable and results-oriented
- Easy to measure progress

## Cons
- Requires clear, well-defined goals
- Doesn't help discover what goals should be
- Can miss opportunities outside the defined gap

## Example
**Company Revenue Goal**:

- **Current State (AS-IS)**: $5M annual revenue, 200 customers, 20% churn
- **Target State (TO-BE)**: $10M annual revenue, 500 customers, 10% churn
- **Gap Analysis**:
  - Revenue gap: $5M (need to double)
  - Customer gap: 300 new customers (net)
  - Churn gap: Reduce 10 percentage points
- **Action Plan**:
  - Increase marketing spend 3x
  - Launch customer success program to reduce churn
  - Expand sales team from 2 to 5
  - Timeline: 12 months

## When to Use
- Goal-oriented planning
- Performance improvement
- Strategic execution
- Capability development

## Success Context
- **strategic_planning, process_improvement**: 100% success rate
- Best for: Clear goals with measurable outcomes
- Combines well with: SWOT for strategic foundation
