# PDCA Cycle (Plan-Do-Check-Act)

## Definition
Iterative four-step cycle for continuous improvement.

## Steps
1. **Plan**: Identify problem, analyze, plan solution
2. **Do**: Implement plan on small scale (test)
3. **Check**: Measure results, compare to goals
4. **Act**: If successful, standardize; if not, adjust plan and repeat

*Repeat cycle continuously for ongoing improvement*

## Pros
- Systematic continuous improvement
- Iterative, so failures are learning opportunities
- Widely applicable (quality, process, product development)

## Cons
- Can be slow if cycles are long
- Initial plan failure can lead to cycle of failures
- Requires discipline to complete full cycle

## Example
**Customer Service Improvement**:

- **Plan**: Train CS team on empathy and conflict resolution (goal: 20% satisfaction increase)
- **Do**: Run training for 1 team (10 people), deploy for 1 month
- **Check**: Survey results show 15% satisfaction increase, but 30% increase in call time
- **Act**: Adjust training to include efficiency techniques; standardize for all teams
- **Next PDCA**: Plan to implement AI chatbot to handle routine queries, freeing CS for complex issues

## When to Use
- Continuous improvement initiatives
- Process optimization
- Quality management
- Agile/iterative development

## Success Context
- **process_improvement**: 100% success rate
- Best for: Iterative improvement with feedback loops
- Use when: You can test changes incrementally
