# TRIZ (Theory of Inventive Problem Solving)

## Definition
Russian methodology using 40 inventive principles to resolve technical contradictions.

## Steps
1. Define the problem and identify contradictions (improving X worsens Y)
2. Generalize the problem into TRIZ's standard form
3. Consult TRIZ contradiction matrix
4. Apply recommended inventive principles (e.g., segmentation, local quality, asymmetry)
5. Generate specific solutions from principles

## Pros
- Systematic approach to invention
- Leverages patterns from 200,000+ patents
- Breaks through mental blocks

## Cons
- Steep learning curve
- Can be complex and abstract
- Best suited for technical/engineering problems

## Example
**Problem**: Saw blade needs to cut faster (increase speed), but that causes it to dull faster (decrease durability)

- **Contradiction**: Speed vs. Durability
- **TRIZ Principles** (from matrix): #35 Parameter changes, #3 Local quality, #27 Composite materials
- **Solution**: Use composite blade material (tungsten carbide teeth on steel body) → achieves high cutting speed + durability

## When to Use
- Technical innovation
- Engineering problem-solving
- Product design
- Patent development

## Success Context
- **creative_innovation**: 100% success rate
- Best for: Technical contradictions and engineering challenges
- Requires: TRIZ training or reference materials
- Combines well with: First Principles for fundamental analysis
