# Thinking Framework v4.0

> Systematic problem-solving with multi-agent orchestration and Clear-Thought MCP integration

---

## What's New in v4.0

- **Multi-Agent Architecture**: Orchestrator + Specialist agents for enhanced analysis
- **Clear-Thought MCP Integration**: 11 specialized reasoning tools
- **Parallel Execution**: Complex problems analyzed simultaneously
- **Quality Gates**: Systematic validation at each stage

---

## Quick Start

### 1. Problem Definition (Required)
→ [reference/problem-definition.md](reference/problem-definition.md)

### 2. Identify Problem Type
- 🔍 **"Why did this happen?"** → [5 Why](reference/5-why.md) / [Fishbone](reference/fishbone.md)
- 💡 **"How to innovate?"** → [SCAMPER](reference/scamper.md) / [First Principles](reference/first-principles.md)
- 🎯 **"What's my strategy?"** → [SWOT](reference/swot.md) + [GAP Analysis](reference/gap-analysis.md)
- ⚙️ **"How to improve?"** → [Pareto](reference/pareto.md) / [PDCA](reference/pdca.md)

### 3. Complexity-Based Routing (v4.0)

| Complexity | Agent Configuration |
|------------|---------------------|
| Simple | Orchestrator only |
| Medium | + 1 Specialist |
| Complex | + 2-3 Specialists (parallel) |

---

## Documentation

| Purpose | Document |
|---------|----------|
| **AI execution (core)** | [SKILL.md](SKILL.md) |
| **60-sec method selection** | [reference/QUICK_SELECTOR.md](reference/QUICK_SELECTOR.md) |
| **Practical guide** | [GUIDE.md](GUIDE.md) |
| **Method combinations** | [reference/METHOD_COMBINATIONS.md](reference/METHOD_COMBINATIONS.md) |
| **Method catalog** | [reference/INDEX.md](reference/INDEX.md) |
| **Agent patterns (v4.0)** | [reference/AGENT_PATTERNS.md](reference/AGENT_PATTERNS.md) |
| **Agent prompts** | [agents/](agents/) |

---

## Architecture (v4.0)

```
User Request
     ↓
┌────────────────────────────────────┐
│  Orchestrator (Tier 1)             │
│  - Complexity assessment           │
│  - Agent coordination              │
│  - Quality gates                   │
└────────────────────────────────────┘
     ↓           ↓           ↓
┌──────────┐ ┌──────────┐ ┌──────────┐
│ Problem  │ │ Method   │ │ Strategy │
│ Definer  │ │ Executor │ │ Architect│
│ (Tier 2) │ │ (Tier 2) │ │ (Tier 2) │
└──────────┘ └──────────┘ └──────────┘
     │           │           │
     └───────────┴───────────┘
              ↓
     Clear-Thought MCP Tools
```

---

## 15 Methods

**Foundational**: Problem Definition

**Root Cause**: 5 Why • Fishbone

**Innovation**: First Principles • Design Thinking • TRIZ • SCAMPER

**Strategy**: SWOT • GAP Analysis

**Process**: Pareto • PDCA • DMAIC

**Decision**: OODA Loop • Kepner-Tregoe

**Synthesis**: Dialectic

---

## Clear-Thought MCP Tools

| Tool | Primary Use |
|------|-------------|
| `sequentialthinking` | Step-by-step reasoning (5 Why) |
| `collaborativereasoning` | Multi-perspective analysis (Fishbone) |
| `decisionframework` | Option evaluation (SWOT, Kepner-Tregoe) |
| `scientificmethod` | Hypothesis testing (OODA, PDCA) |
| `structuredargumentation` | Dialectical reasoning |
| `mentalmodel` | First Principles, Pareto |
| `metacognitivemonitoring` | Quality validation |
| `visualreasoning` | GAP Analysis mapping |

---

## Installation

```bash
# Using prpm (recommended)
prpm install thinking-framework

# Or manual installation
# Copy thinking-framework/ directory to Claude skills
```

---

## Key Features

- **Multi-Agent Orchestration**: Specialized agents for each analysis phase
- **Clear-Thought MCP Integration**: 11 structured reasoning tools
- **Complexity-based routing**: Automatic agent configuration
- **Quality gates**: Systematic validation at G1-G4 checkpoints
- **Parallel execution**: Complex problems analyzed simultaneously
- **Method-problem matching**: Evidence-based recommendations

---

**Version**: 4.0.0 | **Methods**: 15 | **Agents**: 4 | **Target Success**: 95%+
