# DMAIC (Six Sigma)

## Definition
Data-driven quality improvement method: Define → Measure → Analyze → Improve → Control.

## Steps
1. **Define**: Define problem, goals, customer requirements
2. **Measure**: Collect data on current performance
3. **Analyze**: Identify root causes of defects
4. **Improve**: Implement solutions, test changes
5. **Control**: Standardize improvements, monitor ongoing performance

## Pros
- Highly data-driven and rigorous
- Reduces variation and defects
- Proven in manufacturing and services

## Cons
- Resource-intensive (time, cost, expertise)
- Overkill for simple problems
- Requires significant data collection

## Example
**Manufacturing Defect Reduction**:

- **Define**: Reduce defect rate from 5% to 1% in product line X
- **Measure**: Collect data on defects (types, frequency, timing) over 1 month
- **Analyze**: Statistical analysis shows 80% of defects occur during welding step; root cause is inconsistent temperature
- **Improve**: Install automated temperature control; defect rate drops to 0.8%
- **Control**: Implement temperature monitoring dashboard, standard operating procedures, monthly audits

## When to Use
- Quality improvement projects
- Manufacturing optimization
- Process standardization
- Defect reduction

## Success Context
- **process_improvement**: High success for quality control
- ⚠️ **NOT for creative_innovation** (0% success rate)
- Best for: Data-rich environments requiring statistical rigor
- Avoid for: Creative problem-solving or innovation
