# First Principles Thinking

## Definition
Break down a problem to its fundamental elements, verify facts, and reconstruct from the ground up (used by Elon Musk, Aristotle).

## Steps
1. Define the problem clearly
2. Identify all assumptions
3. Decompose into basic elements/facts
4. Verify which are true facts vs. assumptions
5. Reconstruct solution from verified fundamentals

## Pros
- Enables breakthrough innovation
- Challenges conventional wisdom
- Finds non-obvious solutions

## Cons
- Time-consuming and mentally demanding
- Requires deep domain knowledge
- May reinvent the wheel unnecessarily

## Example
**Problem**: Electric car batteries are too expensive

- **Conventional thinking**: Batteries cost $600/kWh, so EVs will always be expensive
- **First Principles decomposition**:
  - What are battery materials? Cobalt, nickel, lithium, aluminum, carbon, polymers
  - What do these cost on commodities market? ~$80/kWh worth of materials
- **Insight**: Material costs are 1/7 of final price. Problem is manufacturing/supply chain, not fundamental limits.
- **Innovation**: Vertically integrate manufacturing, create new battery chemistry (e.g., silicon anode)

## When to Use
- Innovation and breakthrough thinking
- Challenging industry assumptions
- Technology development
- Strategic reinvention

## Success Context
- **technical_problem**: 100% success rate
- Best for: Paradigm-shifting innovations
- Combines well with: TRIZ for technical contradictions
