# OODA Loop (Observe, Orient, Decide, Act)

## Definition
Fast decision-making cycle developed by military strategist John Boyd: Observe → Orient → Decide → Act, then repeat.

## Steps
1. **Observe**: Collect current information from environment
2. **Orient**: Analyze and synthesize information in context (past experience, culture, new info)
3. **Decide**: Determine course of action
4. **Act**: Execute decision
5. **Loop**: Immediately observe results and begin cycle again

*Key: Speed of loop iteration is competitive advantage*

## Pros
- Rapid adaptation to changing conditions
- Emphasizes speed over perfection
- Good for dynamic, uncertain environments

## Cons
- Can prioritize speed over deep analysis
- May miss long-term strategic thinking
- Requires high situational awareness

## Example
**Startup MVP Launch**:

- **Observe**: Market research shows demand for mobile payment in underserved market
- **Orient**: We have technical capability, competitors are slow, but market regulations unclear
- **Decide**: Build MVP with minimal features, launch in beta to small user group
- **Act**: Release beta to 100 users
- **Observe** (next loop): Users love core feature but find onboarding confusing
- **Orient**: Onboarding is critical for viral growth
- **Decide**: Simplify onboarding, cut 2 non-essential features
- **Act**: Update and relaunch to wider audience

*Rapid iteration beats competitors who spend months planning*

## When to Use
- Fast-paced environments
- Competitive markets
- Crisis response
- Agile/lean development

## Success Context
- **decision_making**: 100% success rate
- Best for: Dynamic situations requiring rapid adaptation
- Use when: Speed and iteration are competitive advantages
- Combines well with: Lean Startup methodology
