# Pareto Analysis (80/20 Rule)

## Definition
80% of effects come from 20% of causes. Identify and focus on the critical few.

## Steps
1. List all problems/causes
2. Collect data on frequency or impact of each
3. Sort by impact (descending)
4. Calculate cumulative percentage
5. Identify top 20% causing 80% of problems
6. Prioritize resources on these critical items

## Pros
- Focus on highest-impact items
- Efficient resource allocation
- Data-driven prioritization

## Cons
- Requires quantitative data
- May neglect important long-tail issues
- Percentages are guideline, not exact

## Example
**Product Defects**:

| Defect Type | Occurrences | % of Total | Cumulative % |
|-------------|-------------|------------|--------------|
| Software bug A | 450 | 45% | 45% |
| Hardware fault B | 280 | 28% | 73% |
| User error C | 120 | 12% | 85% |
| Design issue D | 80 | 8% | 93% |
| Other | 70 | 7% | 100% |

**Insight**: Bug A + Fault B = 73% of defects. Fix these two issues first for maximum impact.

## When to Use
- Resource prioritization
- Quality improvement
- Problem triage
- Efficiency optimization

## Success Context
- **process_improvement**: 100% success rate
- Best for: Data-driven prioritization with clear metrics
- Use when: You have quantitative data on impact/frequency
