---
name: toss-patterns
description: Use when planning market strategy, learning from Toss's 7 success patterns (Pain Point, Trojan Horse, Friction Removal, Viral Loop, Data-Driven, Ecosystem, Regulation).
---

# Toss Success Patterns - Proven Market Entry Partner

> **Purpose**: Apply Toss's battle-tested 7 success patterns to achieve market entry, differentiation, and scaling, learning from Korea's fintech unicorn that grew from 0 to 20M+ users.

## When to Use This Skill

Use this skill when the user's request involves:
- **Market entry strategy** - Finding the right approach (Pattern 1, 2)
- **Product differentiation** - Creating 10x better solutions (Pattern 3, 4)
- **PMF achievement** - Data-driven iteration (Pattern 5)
- **Scaling strategy** - Multi-product expansion (Pattern 6, 7)
- **Success case study** - Learning from proven fintech patterns

## Core Identity

You are a **Toss success pattern expert** that applies **7 battle-tested patterns** (Pain Point, Trojan Horse, Friction Removal, Viral Loop, Data-Driven, Ecosystem, Regulation) to guide teams from 0 to market dominance, following Korea's fintech unicorn playbook.

---

## Quick Reference

| Pattern | Focus | Key Metric | When to Apply |
|---------|-------|------------|---------------|
| **1. Small Problem, Big Pain** | Entry point | Pain Point Score 20+ | All stages |
| **2. Trojan Horse** | Expansion path | 3-stage roadmap | Entry → Scale |
| **3. Friction Removal** | 10x improvement | 90% reduction | All stages |
| **4. Product = Marketing** | Viral loop | Viral Coef 1.0+ | Growth stage |
| **5. Data-Driven** | Fast learning | Weekly experiments | All stages |
| **6. Ecosystem** | Multi-product | 30%+ cross-sell | Scale stage |
| **7. Regulation → Opportunity** | Market timing | Regulatory monitoring | Industry-specific |

### Pattern Combinations

**For Entry** (Patterns 1+2+3):
- Find Pain Point 20+
- Design Trojan Horse path
- Achieve 10x improvement

**For Growth** (Patterns 4+5):
- Build viral loops
- Implement weekly experiments

**For Scale** (Patterns 6+7):
- Cross-selling paths
- Regulatory opportunities

---

## Quick Start Example

### Toss's Market Entry Journey

**Pattern 1 (Pain Point)**:
```
Problem: Money transfer complexity
- Frequency: 3 times/week = 3 points
- Intensity: 9/10 (certificate frustration)
- Score: 27 🔥 CRITICAL PRIORITY
```

**Pattern 2 (Trojan Horse)**:
```
Stage 0 (Entry): Simple transfer (0-6 months)
→ Stage 1 (Expand): Payment + Card (6-12 months)
→ Stage 2 (Ecosystem): Bank/Investment/Insurance (1-2 years)
```

**Pattern 3 (Friction Removal)**:
```
Before: 90 seconds, 10 clicks, certificate needed
After: 3 seconds, 3 clicks, no certificate
Improvement: 96% reduction ✅ (30x faster)
```

---

## Industry Adaptations

| Industry | Essential Patterns | Key Adjustments |
|----------|-------------------|-----------------|
| **Fintech** | 1, 2, 3, 5, 7 | Pattern 7 critical (regulation-heavy) |
| **B2B SaaS** | 1, 3, 5 | Pattern 4: K=0.3 is good (not 1.0) |
| **E-commerce** | 1, 3, 4, 5 | Pattern 4: Focus on repeat purchase |
| **Healthcare** | 1, 3, 5, 7 | Pattern 3: Trust > Speed |
| **Education** | 1, 3, 4, 5 | Pattern 4: Strong viral (students share) |

---

## Pattern Checklists

### Pattern 1: Pain Point Score
- [ ] Frequency measured (1-10 scale)
- [ ] Intensity measured (1-10 scale)
- [ ] Score calculated (Frequency × Intensity)
- [ ] Score ≥ 20 (High Priority threshold)
- [ ] Evidence collected (interviews, surveys)

### Pattern 2: Trojan Horse
- [ ] Entry product provides standalone value
- [ ] 3-stage expansion path defined
- [ ] Each stage prerequisites identified
- [ ] Natural progression (users don't question it)
- [ ] Data accumulates for expansion

### Pattern 3: 10x Improvement
- [ ] Current friction measured (time, clicks, cognitive load)
- [ ] 10x goal set (90% reduction target)
- [ ] 3 methods applied (eliminate, automate, predict)
- [ ] User testing validates improvement
- [ ] "Wow" reactions from 80%+ testers

### Pattern 4: Viral Loop
- [ ] Referral motivation identified
- [ ] Referral mechanism designed (in-product)
- [ ] Reward structure set (for both sides)
- [ ] Viral Coefficient calculated
- [ ] K ≥ 0.3 (initial), K → 1.0 (goal)

### Pattern 5: Data-Driven
- [ ] North Star Metric defined
- [ ] 3-5 supporting metrics tracked
- [ ] Weekly experiment cycle established
- [ ] 2-3 experiments per week (max)
- [ ] Hypothesis format: "If X, then Y will Z%"

### Pattern 6: Ecosystem
- [ ] Adjacent markets identified
- [ ] Cross-selling paths mapped
- [ ] Conversion triggers defined
- [ ] Target: 30%+ cross-sell rate
- [ ] Average 2-3 products per user (goal)

### Pattern 7: Regulation
- [ ] Related regulations listed
- [ ] Change likelihood assessed (High/Med/Low)
- [ ] Impact evaluated (Opportunity/Threat)
- [ ] Weekly monitoring established
- [ ] Roadmap adjusted based on changes

---

## Pro Tips

1. **Start with 1+3**: Pain Point + Friction Removal are mandatory for all markets
2. **Pattern 2 from Day 1**: Design Trojan Horse expansion path early, not after launch
3. **Pattern 5 always**: Weekly experiments never stop, regardless of stage
4. **Industry matters**: B2B ≠ B2C (adapt viral coefficients and timelines)
5. **Combinations win**: Use 3-5 patterns together for compounding effects

---

## Common Mistakes

**Mistake 1**: Pain Point Score 15 = "close enough"
**Fix**: 15 < 20 = Medium Priority. Find stronger pain or increase frequency.

**Mistake 2**: "10x is impossible, let's aim for 2x"
**Fix**: 2x is incremental, not remarkable. Use all 3 methods (eliminate + automate + predict).

**Mistake 3**: Designing expansion path after launch
**Fix**: Trojan Horse needs Stage 0→1→2 roadmap from Day 1 for data accumulation.

**Mistake 4**: Running 10+ experiments per week
**Fix**: Focus on 2-3 high-impact experiments. Quality > Quantity.

---

## Integration with Other Skills

This framework integrates with:
- **market-strategy**: Apply Toss patterns to Q1-Q4 (entry), Q13-Q16 (expansion) of 16-question framework
- **roi-analyzer**: Calculate ROI for each Trojan Horse stage (Pattern 2)
- **strategic-thinking**: Use SWOT for competitive analysis, Divide & Conquer for complex launches

---

## Next Steps

**For Detailed Patterns**: See **REFERENCE.md** for:
- Complete Toss timeline (2013-2025)
- All 7 patterns with deep-dive analysis
- Advanced pattern combinations
- Regulatory opportunity framework
- Industry-specific best practices

**For Real-World Examples**: See **EXAMPLES.md** for:
- 5+ comprehensive case studies
- Multiple industries (fintech, SaaS, e-commerce, healthcare)
- Pattern combinations in action
- Failure scenarios and how to avoid them

---

## Meta Note

After applying these patterns, always reflect:
- **Which patterns** worked best for your context?
- **What industry adaptations** were needed?
- **What assumptions** need validation through experiments?

This reflection creates a virtuous cycle of continuous pattern learning and application.

---

For detailed usage and examples, see related documentation files.