# Web Research Reference Guide

Complete templates, examples, and checklists for conducting credible web research.

---

## Standard Research Templates

### Template 1: Full Research Report

```markdown
# [Research Topic]

**Date**: YYYY-MM-DD
**Purpose**: [Why this research was conducted]
**Scope**: [What was included/excluded]

---

## 📊 Executive Summary

**Key Finding 1**: [Metric/fact] - [Implication]
**Source**: [Publisher] ([Date])

**Key Finding 2**: [Metric/fact] - [Implication]
**Source**: [Publisher] ([Date])

**Key Finding 3**: [Metric/fact] - [Implication]
**Source**: [Publisher] ([Date])

**Recommendation**: [1-2 sentence actionable recommendation]

---

## 🔍 Detailed Findings

### 1. [Topic Area 1]

[2-3 paragraphs of analysis]

**Key Points**:
- Point 1
- Point 2
- Point 3

**Source**: [Title] - [Publisher] ([Date])
**Link**: [URL]
**Credibility**: [Official/Academic/Media]

### 2. [Topic Area 2]

[2-3 paragraphs of analysis]

**Key Points**:
- Point 1
- Point 2

**Source**: [Title] - [Publisher] ([Date])
**Link**: [URL]
**Credibility**: [Official/Academic/Media]

---

## 💡 Insights & Implications

### Strategic Implications
- **Implication 1**: [What this means for strategy]
- **Implication 2**: [What this means for execution]

### Tactical Recommendations
1. **Short-term (0-3 months)**: [Action items]
2. **Medium-term (3-6 months)**: [Action items]
3. **Long-term (6-12 months)**: [Action items]

### Risks & Considerations
- **Risk 1**: [Description and mitigation]
- **Risk 2**: [Description and mitigation]

---

## 📚 Complete References

| # | Title | Publisher | Type | Date | URL |
|---|-------|-----------|------|------|-----|
| 1 | [Document Title] | [Publisher] | Official | YYYY-MM-DD | [URL] |
| 2 | [Document Title] | [Publisher] | Academic | YYYY-MM-DD | [URL] |
| 3 | [Document Title] | [Publisher] | Media | YYYY-MM-DD | [URL] |

**Source Breakdown**:
- Official sources: X
- Academic papers: Y
- Media articles: Z
- Total: N sources

---

**Prepared by**: Claude Code
**Last Updated**: YYYY-MM-DD
**Review Date**: [Next review date if applicable]
```

### Template 2: Quick Research Brief

```markdown
# [Topic] - Research Brief

**Date**: YYYY-MM-DD | **Reading Time**: 5 min

## Quick Summary

[2-3 sentence overview of findings]

## Top 3 Findings

1. **[Finding 1]** - [Publisher, Date]
   - [Key detail]

2. **[Finding 2]** - [Publisher, Date]
   - [Key detail]

3. **[Finding 3]** - [Publisher, Date]
   - [Key detail]

## What This Means

[1-2 paragraphs on implications and recommendations]

## Sources

1. [Title] - [Publisher] ([Date]) - [URL]
2. [Title] - [Publisher] ([Date]) - [URL]
3. [Title] - [Publisher] ([Date]) - [URL]

---

**Next Steps**: [Recommended actions]
```

### Template 3: Comparison Analysis

```markdown
# [Option A] vs [Option B]: Comparison Analysis

**Date**: YYYY-MM-DD
**Purpose**: [Decision context]
**Methodology**: Evaluated [N] sources across [X] criteria

---

## Quick Comparison

| Criterion | [Option A] | [Option B] | Winner | Source |
|-----------|------------|------------|--------|--------|
| Performance | [Value/Rating] | [Value/Rating] | [A/B/Tie] | [Publisher] |
| Cost | [Value] | [Value] | [A/B/Tie] | [Publisher] |
| Scalability | [Rating] | [Rating] | [A/B/Tie] | [Publisher] |
| Support | [Rating] | [Rating] | [A/B/Tie] | [Publisher] |
| **Overall** | **X/4** | **Y/4** | **[Winner]** | - |

---

## Detailed Analysis

### Performance
**[Option A]**: [Details with metrics]
**[Option B]**: [Details with metrics]
**Source**: [Citation]
**Winner**: [A/B/Tie] because [reason]

### Cost
**[Option A]**: [Details]
**[Option B]**: [Details]
**Source**: [Citation]
**Winner**: [A/B/Tie] because [reason]

[Continue for each criterion]

---

## Recommendation

### Choose [Option A] if:
- [Criterion 1 is priority]
- [Criterion 2 applies]
- [Use case description]

### Choose [Option B] if:
- [Different criterion is priority]
- [Different use case]

### Key Deciding Factors:
1. [Factor 1]
2. [Factor 2]

---

## References
[Full source list]
```

---

## Real-World Examples

### Example 1: Technology Research

```markdown
# AI in Pharmaceutical Drug Discovery - 2024 State of the Industry

**Date**: 2024-10-27
**Purpose**: Evaluate AI adoption and ROI for pharma proposal
**Scope**: Top 20 pharmaceutical companies, 2022-2024 data

---

## 📊 Executive Summary

**Key Finding 1**: 68% adoption rate among top pharma companies
**Source**: McKinsey Pharma AI Report (2024-02-10)

**Key Finding 2**: Average 30% reduction in preclinical development time
**Source**: Nature Medicine AI Review (2024-03-15)

**Key Finding 3**: $2.5B invested in pharma AI in 2023, up 89% from 2022
**Source**: PharmaExec Industry Analysis (2024-01-20)

**Recommendation**: AI investment shows strong ROI; recommend pilot in
molecular screening with 6-month evaluation period.

---

## 🔍 Detailed Findings

### 1. Adoption Rates & Trends

As of Q1 2024, 68% of the top 20 global pharmaceutical companies have
implemented AI tools in their drug discovery pipelines, representing a
significant increase from 32% in 2022. The primary applications are
molecular screening (85% of adopters), clinical trial optimization (67%),
and patient recruitment (54%).

**Key Points**:
- Adoption doubled from 2022 to 2024 (32% → 68%)
- Molecular screening is #1 use case (85% of AI adopters)
- ROI typically realized within 18 months

**Source**: "AI in Pharmaceutical Manufacturing: 2024 Industry Report" -
McKinsey & Company (2024-02-10)
**Link**: https://mckinsey.com/industries/pharma/ai-2024
**Credibility**: Official (Tier-1 Consulting Firm)

### 2. Performance Metrics & ROI

Companies implementing AI in preclinical research reported an average 30%
reduction in development time and 45% improvement in successful compound
identification rates. Pfizer's partnership with IBM Watson demonstrated
these gains in a real-world setting, with their platform processing
10,000+ molecular structures per day.

**Key Points**:
- 30% faster preclinical development
- 45% higher success rate in compound ID
- 10,000+ compounds screened daily (Pfizer case)

**Source**: "Machine Learning in Drug Discovery: A Systematic Review" -
Nature Medicine (2024-03-15)
**Link**: https://nature.com/articles/s41591-024-02847
**Credibility**: Academic (Peer-reviewed journal)

---

## 💡 Insights & Implications

### Strategic Implications
- **Market momentum**: 68% adoption indicates AI is now standard practice,
  not experimental
- **Competitive necessity**: Non-adopters risk falling behind in time-to-market

### Tactical Recommendations
1. **Short-term (0-3 months)**:
   - Pilot AI molecular screening with existing compound library
   - Budget $500K-$1M for initial implementation

2. **Medium-term (3-6 months)**:
   - Evaluate pilot results against 30% efficiency benchmark
   - Decide on full rollout vs. iteration

3. **Long-term (6-12 months)**:
   - Expand to clinical trial optimization if pilot succeeds
   - Build internal AI expertise (hire 2-3 specialists)

---

## 📚 Complete References

| # | Title | Publisher | Type | Date | URL |
|---|-------|-----------|------|------|-----|
| 1 | AI in Pharmaceutical Manufacturing 2024 | McKinsey | Official | 2024-02-10 | [URL] |
| 2 | ML in Drug Discovery: Systematic Review | Nature Medicine | Academic | 2024-03-15 | [URL] |
| 3 | Pharma AI Investment Trends Q1 2024 | PharmaExec | Media | 2024-01-20 | [URL] |

**Source Breakdown**: Official: 1, Academic: 1, Media: 1, Total: 3 sources
```

### Example 2: Market Research

```markdown
# Digital MR Platform Market Analysis - 2024

**Date**: 2024-10-27
**Purpose**: Size TAM for MR SaaS product pitch

---

## Quick Summary

Global digital MR platform market valued at $2.8B in 2023, projected to
reach $7.2B by 2028 (CAGR 20.7%). Key drivers: remote work adoption,
compliance requirements, AI integration.

## Top 3 Findings

1. **$7.2B market size by 2028** - Grand View Research (2024-01)
   - 20.7% CAGR from 2023-2028

2. **73% of pharma companies plan MR digital transformation by 2025** -
   Gartner Survey (2024-03)
   - Primary driver: post-COVID remote work sustainability

3. **Average deal size $250K-$500K for mid-market pharma** - SaaS Capital
   Benchmarks (2024-02)
   - Sales cycle: 4-6 months

## What This Means

Strong market tailwinds support aggressive growth targets. TAM large enough
to support multiple players. Recommend positioning as AI-first solution to
differentiate from legacy competitors.

## Sources

1. "Digital Health in Pharma Sales Report" - Grand View Research (2024-01) - [URL]
2. "2024 Pharma Technology Survey" - Gartner (2024-03) - [URL]
3. "B2B SaaS Benchmarks Q1 2024" - SaaS Capital (2024-02) - [URL]

---

**Next Steps**:
1. Refine ICP based on $250K+ deal size
2. Build competitive matrix vs. top 3 incumbents
3. Develop AI differentiation messaging
```

---

## Credibility Assessment Guide

### Source Type Matrix

| Source Type | Trustworthiness | Best For | Verification Needed |
|-------------|----------------|----------|---------------------|
| **Government (.gov)** | Very High | Regulations, statistics | Low - generally reliable |
| **Academic (.edu, journals)** | Very High | Technical claims, research | Low - peer-reviewed |
| **Official Corporate** | High | Company data, announcements | Medium - may be biased |
| **Consulting Firms** | High | Market analysis, trends | Medium - check methodology |
| **Industry Media** | Medium-High | News, trends | Medium - verify with other sources |
| **Expert Blogs** | Medium | Opinions, insights | High - check credentials |
| **Forums/Community** | Low-Medium | Troubleshooting, sentiment | High - anecdotal only |
| **Unknown Sites** | Low | Avoid | Very High |

### Red Flags Checklist

When evaluating sources, watch for:

- [ ] **No author name** - Anonymous content is less credible
- [ ] **No publication date** - Can't assess currency
- [ ] **Broken external links** - Poor maintenance suggests unreliable
- [ ] **Excessive ads/clickbait** - Content farm indicator
- [ ] **No methodology disclosed** - Can't validate claims
- [ ] **Extreme language** - "Revolutionary", "catastrophic" without evidence
- [ ] **Single source** - Fact not corroborated elsewhere
- [ ] **Conflict of interest** - Vendor reviewing own product

### Green Flags Checklist

Indicators of credible sources:

- [x] **Named author with credentials** - Expert in the field
- [x] **Recent publication date** - Within 1-2 years for fast-moving topics
- [x] **References cited** - Links to primary sources
- [x] **Methodology described** - Clear research process
- [x] **Peer-reviewed** - Academic validation
- [x] **Multiple corroborating sources** - Fact confirmed elsewhere
- [x] **Neutral tone** - Balanced analysis
- [x] **Author disclosure** - Conflicts of interest noted

---

## Source Attribution Examples

### Format: Official Document

```markdown
**Source**: "FDA Guidance on AI/ML in Medical Devices" - U.S. Food and Drug
Administration (2024-04-15)
**Link**: https://fda.gov/medical-devices/software-medical-device-samd/ai-ml-guidance-2024
**Credibility**: Official (Government regulatory agency)
**Notes**: Final guidance; supersedes 2023 draft
```

### Format: Academic Paper

```markdown
**Source**: "Transformer Models in Drug Discovery: A Meta-Analysis" -
Journal of Chemical Information and Modeling, Vol. 64, Issue 3 (2024-03-20)
**Link**: https://pubs.acs.org/doi/10.1021/acs.jcim.4c00123
**Credibility**: Academic (Peer-reviewed, ACS journal, Impact Factor: 5.6)
**Notes**: Meta-analysis of 47 studies, n=15,000 compounds
```

### Format: Industry Report

```markdown
**Source**: "State of SaaS 2024: Growth Metrics & Benchmarks" - SaaStr
Annual Report (2024-02-01)
**Link**: https://saastr.com/annual-report-2024
**Credibility**: Industry (Leading SaaS community, 10+ year track record)
**Notes**: Survey of 1,200 SaaS companies; median ARR $5M
```

### Format: News Article

```markdown
**Source**: "Pfizer Announces $500M AI Drug Discovery Initiative" -
Reuters (2024-01-10)
**Link**: https://reuters.com/article/pfizer-ai-initiative-2024
**Credibility**: Media (Tier-1 news agency, fact-checked)
**Notes**: Press release confirmed by Pfizer investor relations
```

### Format: Expert Opinion

```markdown
**Source**: "Why Most Pharma AI Projects Fail" by Dr. Sarah Chen, PhD -
In Vivo Blog (2024-03-05)
**Link**: https://invivoblog.com/pharma-ai-failures-chen
**Credibility**: Expert Blog (Author: 15 years pharma R&D, former Novartis)
**Notes**: Opinion piece; anecdotal evidence; cross-reference with data
```

---

## Quality Checklists

### Pre-Research Checklist

Before starting research:

- [ ] Research question clearly defined
- [ ] Scope boundaries set (what's in/out)
- [ ] Success criteria identified (what makes this "good enough")
- [ ] Credibility standards agreed upon
- [ ] Time budget allocated
- [ ] Output format chosen (brief, full report, comparison)

### During Research Checklist

While researching:

- [ ] 3-5 search queries prepared
- [ ] Multiple source types consulted (official, academic, media)
- [ ] Facts verified from 2+ independent sources
- [ ] Publication dates checked (<2 years for trends)
- [ ] URLs tested and working
- [ ] Screenshots taken for key data (backup if link breaks)
- [ ] Notes organized by topic/theme
- [ ] Sources tracked in references list

### Post-Research Checklist

Before delivering:

- [ ] Executive summary written (3-5 key findings)
- [ ] All claims have sources cited
- [ ] All sources have full attribution (title, publisher, date, URL)
- [ ] Credibility level noted for each source
- [ ] Links tested (no 404s)
- [ ] Dates formatted consistently (YYYY-MM-DD)
- [ ] Insights/implications section included
- [ ] Recommendations are actionable
- [ ] References table completed
- [ ] Document metadata added (date, author, source count)
- [ ] Spelling/grammar checked
- [ ] Technical accuracy verified

---

## Common Pitfalls & Solutions

| Pitfall | Problem | Solution |
|---------|---------|----------|
| **Vague search queries** | Too broad, irrelevant results | Use specific terms, add year, try multiple phrasings |
| **Single-source facts** | Can't verify accuracy | Always confirm from 2+ independent sources |
| **Outdated information** | No longer relevant | Check dates; prefer <2 years for trends |
| **Missing attribution** | Can't verify or cite | Note source immediately when finding info |
| **Broken links** | Source becomes inaccessible | Use Web Archive; take screenshots |
| **Paywalled content** | Can't access | Look for press releases, summaries, alternative sources |
| **Bias not noted** | Misleading conclusions | Always note potential conflicts of interest |
| **No executive summary** | Reader doesn't know key points | Start with 3-5 sentence summary |
| **Data without context** | Metric means nothing alone | Add comparison, baseline, or trend |
| **No recommendations** | Research doesn't drive action | End with "What this means" and next steps |

---

## Advanced Research Techniques

### Technique 1: Triangulation

Verify important facts from 3 different source types:

```
Claim: "AI reduces drug discovery time by 30%"

Verification:
1. Academic: Nature Medicine meta-analysis (peer-reviewed)
2. Official: Pfizer investor presentation (company data)
3. Media: TechCrunch interview with Novartis CIO (expert opinion)

→ Claim verified ✓
```

### Technique 2: Time-Bounded Search

For fast-moving topics, restrict by date:

```
Query: "large language models benchmark 2024"
NOT: "large language models benchmark" (may return 2020 results)
```

### Technique 3: Domain-Specific Search

Use site: operator for authoritative domains:

```
site:nih.gov clinical trial AI
site:nature.com drug discovery machine learning
site:fda.gov medical device software
```

### Technique 4: Reverse Citation

Start with one good source, check its references:

```
Found: Great McKinsey report on pharma AI
→ Check references section
→ Find 5 more academic papers cited
→ Follow those for deeper dive
```

---

**Version**: 1.0.0
**Last Updated**: 2025-10-27
**Maintained by**: Claude Code