# Web Research Skill Strategic Utilization Guide

Strategic and tactical utilization methods and real-world scenarios for the web-research skill.

---

## 📋 Table of Contents

1. [Overview](#overview)
2. [Strategic vs Tactical Research Mapping](#strategic-vs-tactical-research-mapping)
3. [Domain-Specific Research Workflows](#domain-specific-research-workflows)
4. [4-Tier Credibility Framework in Practice](#4-tier-credibility-framework-in-practice)
5. [Real-World Scenarios (15 Examples)](#real-world-scenarios-15-examples)
6. [Advanced Integration Methodology](#advanced-integration-methodology)
7. [Practical Templates and Checklists](#practical-templates-and-checklists)
8. [Learning Roadmap](#learning-roadmap)

---

## Overview

### What is the Web Research Skill?

The **web-research skill** is a systematic methodology for reliable information gathering and structured research.

**Core Values**:
- ⚡ **Efficiency**: 50% reduction in research time with 4-step process
- 🎯 **Reliability**: Information quality assurance with 4-Tier credibility framework
- 🔄 **Reproducibility**: Consistent quality with standardized templates
- 🤖 **Automation**: Automate repetitive tasks with structured workflows

### 4-Step Research Process

```yaml
Step 1: Search Query Design
  input: Research topic
  task: Extract keywords → Generate 3-5 search queries
  output: Search query list
  tools: Analysis tools (complex topics), Manual design (simple topics)

Step 2: Research Execution
  input: Search query list
  task: Web search → Credibility filtering → Detailed information extraction
  output: Raw research results (URLs, summaries, credibility)
  tools: Web search tools, Real-time search

Step 3: Source Documentation
  input: Raw research results
  task: Summarize + Cite sources + Include URLs + Assess credibility
  output: Structured notes
  tools: Analysis tools, Official documentation verification

Step 4: Document Creation
  input: Structured notes
  task: Use standard template → Add insights → Present recommendations
  output: Final research report
  tools: Comprehensive analysis, Manual writing
```

---

## Strategic vs Tactical Research Mapping

### Strategic Research

**Purpose**: Long-term decision-making, market entry, technology selection

| Characteristic | Description |
|----------------|-------------|
| **Time Range** | 1-3 weeks (10-30 hours) |
| **Credibility Requirement** | Tier 1-2 focus (90%+ credibility) |
| **Research Tools** | Official documentation + Deep analysis tools |
| **Output Format** | Full Research Report (15-30 pages) |
| **Validation Level** | Cross-verify with 3+ independent sources |

**Strategic Research Use Cases**:
1. **Technology Stack Selection**: React vs Vue vs Angular (3-year roadmap)
2. **Market Entry Strategy**: Healthcare SaaS market TAM/SAM/SOM analysis
3. **Regulatory Compliance**: HIPAA compliance requirements comprehensive research
4. **M&A Due Diligence**: Target company financial/technical/legal comprehensive analysis
5. **Long-term Investment**: AWS vs Azure vs GCP 5-year TCO comparison

**Strategic Research Workflow**:
```yaml
Week 1: Foundation Research
  - Collect official documentation
  - Collect industry reports
  - Build initial analysis framework

Week 2: Deep Dive
  - Track latest trends
  - Competitor analysis
  - Perform comparative analysis

Week 3: Validation and Documentation
  - Cross-verification (3+ independent sources)
  - Comprehensive analysis and recommendations
  - Final report (Full Research Report template)
```

### Tactical Research

**Purpose**: Immediate problem-solving, troubleshooting, quick decision-making

| Characteristic | Description |
|----------------|-------------|
| **Time Range** | 1-2 hours |
| **Credibility Requirement** | Tier 2-3 acceptable (70%+ credibility) |
| **Research Tools** | Real-time search + Quick web search |
| **Output Format** | Quick Research Brief (1-2 pages) |
| **Validation Level** | Verify with 2+ sources |

**Tactical Research Use Cases**:
1. **Error Troubleshooting**: "Django CSRF token missing" solution methods
2. **Quick Comparison**: "Python asyncio vs threading" performance differences
3. **Latest Information**: "React 19 new features" (November 2024)
4. **Best Practices**: "PostgreSQL connection pool optimal settings"
5. **Immediate Response**: "OpenAI API rate limit workaround methods"

**Tactical Research Workflow**:
```yaml
10 minutes: Query Design
  - Extract keywords (3-5)
  - Generate search queries

20 minutes: Research Execution
  - Real-time search (5-10 results)
  - Read top 3 URLs in detail
  - Credibility assessment (Tier 2-3)

20 minutes: Documentation
  - Use Quick Research Brief template
  - 3 key findings + sources
  - Immediately actionable recommendations

10 minutes: Validation
  - Verify with 2+ independent sources
  - Save final document
```

### Strategic vs Tactical Selection Criteria

| Question | Strategic Research | Tactical Research |
|----------|-------------------|------------------|
| **Decision impact > 6 months?** | ✅ Yes | ❌ No |
| **Cost impact > $10,000?** | ✅ Yes | ❌ No |
| **Irreversible if failed?** | ✅ Yes | ❌ No |
| **Team-wide impact?** | ✅ Yes | ❌ No |
| **Immediate resolution needed?** | ❌ No | ✅ Yes |

---

## Domain-Specific Research Workflows

### 1. Technical Documentation Research

**Objective**: Accurate implementation, official recommendations

**Required Tools**:
- Primary: Official documentation sources
- Secondary: Best practices research
- Validation: Analysis tools

**Workflow**:
```yaml
Step 1: Official Documentation (30 min)
  Query official docs
  Example: "React 18 concurrent features"
  Output: Official implementation guide

Step 2: Best Practices (20 min)
  Industry best practices research
  Example: "React performance optimization 2024"
  Output: Expert recommendations

Step 3: Validation (20 min)
  Check community adoption
  Stack Overflow → Troubleshooting tips
  Output: Practical considerations

Step 4: Synthesis (10 min)
  Comprehensive analysis
  Output: Implementation plan with caveats
```

### 2. Market Research

**Objective**: Market size, growth rate, competitive landscape

**Required Tools**:
- Primary: Industry reports and research
- Secondary: Latest trends tracking
- Validation: Company data sources

**Workflow**:
```yaml
Step 1: Industry Reports (60 min)
  Gartner, Forrester, IDC reports
  Query: "Healthcare SaaS market size 2024"
  Output: TAM/SAM/SOM data

Step 2: Competitive Analysis (40 min)
  Competitor news and funding
  Company websites, pricing
  Output: Competitive landscape map

Step 3: Trend Analysis (30 min)
  Latest market trends
  Industry expert blogs
  Output: Growth drivers and trends

Step 4: Synthesis (30 min)
  Market opportunity analysis
  Output: Market entry recommendations
```

### 3. Troubleshooting Research

**Objective**: Quick problem resolution

**Required Tools**:
- Primary: Fast web search
- Secondary: Community resources
- Validation: Official documentation

**Workflow**:
```yaml
Step 1: Quick Search (10 min)
  Search exact error message
  Filter: Recent (within 6 months)
  Output: 5-10 potential solutions

Step 2: Community Solutions (15 min)
  Stack Overflow, GitHub Issues
  Filter: High votes (10+)
  Output: Verified community solutions

Step 3: Official Verification (10 min)
  Check official documentation
  Verify: Solution aligns with best practices
  Output: Validated solution

Step 4: Test and Document (5 min)
  Test solution locally
  Document for future reference
```

---

## 4-Tier Credibility Framework in Practice

### Tier 1 (90-100%): Official/Academic

**When to Use**:
- Technical implementation
- Regulatory compliance
- Critical decisions
- Legal/financial matters

**Example Workflow**: HIPAA Compliance Research
```yaml
Step 1: Official Sources Only
  HHS.gov HIPAA regulations
  NIST security frameworks
  Credibility: Tier 1 (100%)

Step 2: Academic Validation
  Healthcare security journals
  Focus: Peer-reviewed only
  Credibility: Tier 1 (95%)

Step 3: Documentation
  Template: Compliance Research Report
  Citation: Every claim sourced
  No Tier 2-4 sources allowed
```

### Tier 2 (70-90%): Expert/Media

**When to Use**:
- Technology trends
- Best practices
- Market analysis
- Strategic planning

**Example Workflow**: Technology Stack Selection
```yaml
Step 1: Industry Analysis
  Gartner Magic Quadrant
  ThoughtWorks Tech Radar
  Credibility: Tier 2 (85%)

Step 2: Expert Opinions
  Martin Fowler blog
  Conference talks (AWS re:Invent)
  Credibility: Tier 2 (80%)

Step 3: Cross-Validation
  Official documentation
  Verify: Expert claims against official docs
  Final Credibility: Tier 1-2 mix (85%)
```

### Tier 3 (50-70%): Community

**When to Use**:
- Troubleshooting
- Quick comparisons
- Diverse perspectives
- Initial exploration

**Example Workflow**: Error Resolution
```yaml
Step 1: Community Search
  Stack Overflow answers
  Filter: Upvotes 10+, Recent
  Credibility: Tier 3 (60%)

Step 2: Multiple Sources
  GitHub Issues
  Dev.to articles
  Verify: Consistent across 3+ sources

Step 3: Official Validation (Required)
  Check official docs
  Verify: Solution aligns with best practices
  Upgrade Credibility: Tier 2-3 (70%)
```

### Tier 4 (30-50%): Unverified

**When to Use** (with extreme caution):
- Brainstorming
- Initial hypotheses
- Broad exploration
- Non-critical decisions

**Example Workflow**: Feature Ideation
```yaml
Step 1: Broad Collection
  Social media discussions
  Personal blogs
  Purpose: Idea collection only

Step 2: Pattern Recognition
  Identify common themes
  No citations from Tier 4 sources

Step 3: Tier 1-2 Validation (Mandatory)
  Validate feasible ideas
  Industry validation
  Final Decision: Only on Tier 1-2 evidence
```

---

## Real-World Scenarios (15 Examples)

### Scenario 1: API Integration Research

**Context**: Need to integrate Stripe payment API

**Research Plan**:
```yaml
Strategic Classification: Tactical (2 hours)
Primary Tool: Official documentation
Credibility Target: Tier 1 (95%+)

Hour 1: Official Documentation
  "Stripe API documentation"
  "Stripe payment intents guide"
  Stripe official code examples

Hour 2: Implementation Best Practices
  "Stripe integration best practices"
  "Stripe error handling patterns"
  Security considerations analysis
```

**Output Template**: Technical Implementation Brief
**Success Criteria**: Working integration with proper error handling

---

### Scenario 2: Market Sizing Research

**Context**: Calculate TAM/SAM/SOM for Healthcare SaaS

**Research Plan**:
```yaml
Strategic Classification: Strategic (2 weeks)
Primary Tools: Industry research + Analysis tools
Credibility Target: Tier 1-2 (85%+)

Week 1: Industry Data Collection
  "Healthcare SaaS market size 2024"
  Output: TAM calculations

  "Healthcare IT spending trends"
  Output: Growth rates

  "Healthcare industry statistics"
  Source: Official government statistics
  Output: Tier 1 data validation

Week 2: Competitive Analysis
  Top 10 healthcare SaaS companies
  Competitor pricing and positioning
  SAM/SOM calculation
```

**Output**: Full Market Research Report (20 pages)

---

### Scenario 3: Compliance Research

**Context**: Prepare for ISO 27001 certification

**Research Plan**:
```yaml
Strategic Classification: Strategic (3 weeks)
Primary Tools: Official sources + Document retrieval
Credibility Requirement: Tier 1 ONLY (100%)

Week 1: Official Standards
  ISO 27001:2022 official document
  NIST cybersecurity framework
  Industry-specific addendums

Week 2: Implementation Guidance
  "ISO 27001 implementation checklist"
  Filter: Only from certified consultants
  Credibility: Tier 2 (85%)

Week 3: Case Studies
  "Successful ISO 27001 certification case studies"
  Focus: Companies in same industry
  Purpose: Reference only (not cited)
```

**Output**: Compliance Roadmap Document

---

### Scenario 4: Technology Comparison

**Context**: Choose between PostgreSQL and MongoDB

**Research Plan**:
```yaml
Strategic Classification: Strategic (1 week)
Primary Tools: Official docs + Analysis tools + Real-time search
Credibility Target: Tier 1-2 (80%+)

Day 1-2: Official Documentation
  PostgreSQL official docs (focus: performance, scaling)
  MongoDB official docs (focus: query patterns)

Day 3-4: Benchmarks and Analysis
  "PostgreSQL vs MongoDB benchmarks 2024"
  Real-world performance comparisons
  Use case alignment analysis

Day 5: Decision Framework
  Create decision matrix
  Factors: Performance, scalability, maintenance, cost, team skills
  Output: Recommendation with rationale
```

**Output**: Technology Comparison Report

---

### Scenario 5: Emergency Troubleshooting

**Context**: Production down - "503 Service Unavailable" error

**Research Plan**:
```yaml
Strategic Classification: Tactical (30 minutes)
Primary Tools: Real-time search + Web search
Credibility: Tier 2-3 acceptable (60%+)

0-5 min: Initial Search
  "503 error {your_tech_stack} common causes"
  Focus: Most recent posts

5-15 min: Solution Collection
  Stack Overflow (sort by votes)
  GitHub Issues (official repo)
  Collect: 5-10 potential solutions

15-25 min: Validation
  Official error documentation
  Verify: Solutions align with official guidance

25-30 min: Implementation
  Test: Solution in staging
  Document: For postmortem analysis
```

**Output**: Quick Resolution + Incident Documentation

---

### Scenario 6-15: Additional Scenarios

Due to length, here are summary outlines:

**6. Competitive Intelligence**: Research competitor's tech stack and strategy
**7. Hiring Research**: Evaluate market salary ranges for engineering roles
**8. Vendor Selection**: Choose between SaaS providers
**9. Architecture Design**: Research microservices patterns
**10. Security Audit**: Research latest security vulnerabilities
**11. Performance Optimization**: Research database optimization techniques
**12. Framework Migration**: Research migration path from legacy framework
**13. Feature Feasibility**: Research technical feasibility of new feature
**14. Cost Analysis**: Research cloud infrastructure costs
**15. Regulatory Change**: Research impact of new data protection regulations

---

## Advanced Integration Methodology

### Multi-Tool Orchestration

**Pattern**: Official docs → Industry research → Deep analysis → Real-world validation

**Use Case**: Comprehensive technology evaluation

```yaml
Stage 1: Foundation
  Purpose: Official capabilities and limitations
  Output: Feature matrix from official docs
  Credibility: Tier 1 (95%)

Stage 2: Expert Analysis
  Purpose: Industry adoption and best practices
  Output: Expert recommendations and patterns
  Credibility: Tier 2 (85%)

Stage 3: Deep Reasoning
  Purpose: Trade-off analysis and decision framework
  Output: Comparative analysis matrix
  Method: Multi-step reasoning

Stage 4: Real-World Validation
  Purpose: Current adoption and recent experiences
  Output: Community feedback and gotchas
  Credibility: Tier 2-3 (70%)

Stage 5: Final Synthesis
  Purpose: Comprehensive recommendation
  Output: Decision with confidence level
```

### Confidence Scoring System

```yaml
Confidence Calculation:
  Tier 1 sources: 100 points each
  Tier 2 sources: 85 points each
  Tier 3 sources: 60 points each
  Tier 4 sources: 30 points each

Formula:
  Confidence = (Sum of source scores) / (Number of sources) / 100

Example:
  Sources: 2 Tier 1 (200) + 3 Tier 2 (255) + 1 Tier 3 (60)
  Calculation: (200 + 255 + 60) / 6 / 100 = 85.8%
  Confidence: High (85%)
```

---

## Practical Templates and Checklists

### Quick Research Brief Template

```markdown
# [Topic] - Quick Research Brief

**Date**: YYYY-MM-DD
**Research Time**: [X hours]
**Confidence**: [%]

## Key Findings

**Finding 1**: [Main point]
- Source: [Title] ([Tier X])
- URL: [Link]
- Date: YYYY-MM-DD

**Finding 2**: [Main point]
- Source: [Title] ([Tier X])
- URL: [Link]
- Date: YYYY-MM-DD

**Finding 3**: [Main point]
- Source: [Title] ([Tier X])
- URL: [Link]
- Date: YYYY-MM-DD

## Recommendation

[1-2 sentence actionable recommendation]

## Next Steps

1. [Immediate action]
2. [Follow-up action]
3. [Long-term consideration]

---

**Sources**: [X Tier 1] | [Y Tier 2] | [Z Tier 3]
**Confidence**: [High/Medium/Low]
```

### Research Quality Checklist

```yaml
Before Starting:
  □ Clear research objective defined
  □ Strategic vs Tactical classification done
  □ Time budget allocated
  □ Research tools available and tested

During Research:
  □ Minimum 3 sources per claim
  □ Credibility tier documented for each source
  □ Publication dates checked (prefer <1 year)
  □ Author credentials verified
  □ URLs captured and tested

Before Completion:
  □ Cross-verification performed
  □ Confidence score calculated
  □ All claims have sources
  □ Recommendations are actionable
  □ Template filled completely

Quality Gates:
  □ Strategic research: 85%+ confidence
  □ Tactical research: 70%+ confidence
  □ Compliance research: 95%+ confidence
  □ All Tier 3-4 validated with Tier 1-2
```

---

## Learning Roadmap

### Level 1: Fundamentals (Week 1-2)

**Objectives**:
- Understand 4-step research process
- Learn 4-Tier credibility framework
- Practice with Quick Research Brief template

**Practice Projects**:
1. Research a new JavaScript framework
2. Compare two similar technologies
3. Troubleshoot a common error

**Success Criteria**:
- Complete 5 tactical research briefs
- Achieve 70%+ confidence consistently
- Use research tools effectively

### Level 2: Integration (Week 3-4)

**Objectives**:
- Master research tool integration patterns
- Learn strategic research methodology
- Practice multi-tool orchestration

**Practice Projects**:
1. Conduct a 1-week market research
2. Perform technology stack evaluation
3. Research regulatory compliance requirements

**Success Criteria**:
- Complete 2 strategic research reports
- Achieve 85%+ confidence consistently
- Effectively combine multiple research tools

### Level 3: Mastery (Week 5-8)

**Objectives**:
- Develop domain-specific workflows
- Optimize research efficiency
- Create custom templates

**Practice Projects**:
1. Design custom research workflow for your domain
2. Create organization-specific credibility criteria
3. Build research knowledge base

**Success Criteria**:
- Reduce research time by 50%
- Maintain 90%+ confidence
- Train others in research methodology

---

## Appendix: Tool Quick Reference

### When to Use Which Approach

| Situation | Best Approach | Why |
|-----------|---------------|-----|
| Need official documentation | Official documentation sources | Direct access to authoritative docs |
| Need latest news/trends | Real-time search | Current information with filtering |
| Need deep analysis | Multi-step analysis | Systematic reasoning capability |
| Need quick answer | Quick web search | Fastest, most accessible |
| Need multiple perspectives | Comprehensive search | Diverse viewpoints |
| Need to verify claims | Cross-reference sources | Compare official vs community sources |

### Credibility Quick Check

```yaml
Ask yourself:
  - Is the author identified? (Unknown = Tier 3-4)
  - Is it from official source? (Yes = Tier 1)
  - Is it peer-reviewed? (Yes = Tier 1)
  - Is it from industry expert? (Yes = Tier 2)
  - Is it recent (<1 year)? (No = Downgrade)
  - Does it cite sources? (No = Downgrade)
  - Is it promotional? (Yes = Tier 4)
```

---

**Version**: 1.0
**Last Updated**: 2025-11-05
**Maintained by**: Claude Code
**Next Review**: 2025-12-05

For latest updates and additional scenarios, refer to the main web-research skill documentation.
