# 代码质量标准参考（已迁移 - 按需加载）

> ⚠️ **重要通知**：为了优化 token 效率，本文件已拆分为专用标准文件。
>
> 请使用 `references/quality_standards/README.md` 作为入口，然后按需加载具体标准文件。

## 📚 可用标准文件（按需加载）

| 文件名 | 用途 | Token 估算 |
|--------|------|-----------|
| `global_rules.md` | G1-G8 全局规则（文档一等公民、知识库策略、安全合规等） | ~1K |
| `core_principles.md` | 核心开发原则（伦理审查、可复现性、模型选择等） | ~800 |
| `p3_constraints_and_quality.md` | P3执行方案约束+代码质量检查项（低风险判断、质量检查清单） | ~1.2K |
| `commit_and_quality_gates.md` | Conventional Commits规范+质量门槛（提交格式、SLO阈值） | ~600 |
| `error_handling_and_usage.md` | P4错误处理原则+使用建议（MRE、归因、优先级） | ~500 |

**Token 节省**：从 ~7K tokens（完整文档）降至 ~2.5-5K tokens（按需加载），节省约 40-60%。

## 🚀 使用指南

### 方式 1：从索引入口开始（推荐）

```markdown
请先阅读 references/quality_standards/README.md，了解标准文件的整体结构和索引。
然后根据需要加载具体的标准文件。
```

### 方式 2：直接加载特定标准

根据检查需求直接加载对应文件：

- **全局规则检查** → `global_rules.md`
- **核心原则审查** → `core_principles.md`
- **P3 执行约束** → `p3_constraints_and_quality.md`
- **提交规范检查** → `commit_and_quality_gates.md`
- **错误处理指导** → `error_handling_and_usage.md`

## 📖 详细信息

查看 `references/quality_standards/README.md` 获取：
- 完整的标准文件索引
- 每个标准文件的详细说明
- 搜索模式和关键词引导
