# 核心开发原则 (Core Development Principles)

> **用途**: 提供伦理与偏见审查、可复现性与可解释性、模型选择与构建的核心原则。

---


## 二、核心开发原则（来自 CLAUDE.md）

### 原则一：伦理与偏见审查
- **数据偏见检查**: 识别数据集中可能存在的偏见（性别、地域、种族）
- **模型用途声明**: 明确模型的预期应用场景，评估滥用风险

### 原则二：可复现性与可解释性

#### 可复现性
- 代码规范：清晰、可读，附有必要注释
- 实验文档化：创建并维护"模型卡片"或"运行记录"
  - 训练环境（软件版本）
  - 依赖库
  - 数据集的确切版本或来源
  - 关键超参数配置
  - 最终的评估结果

#### 可解释性
- 方法透明：优先选择可解释的模型/工具（如 SHAP, LIME）
- 结果分析：对于"黑箱"模型，必须提供可解释性分析报告

### 原则三：模型的选择与构建

#### 数据驱动
- 数据特性决定起点（表格数据→集成树模型；图像→CNN；序列/文本→RNN/Transformer）
- 数据规模影响选择（小数据集避免过于复杂的模型）

#### 目标导向
- 权衡核心指标：可解释性、预测性能、推理速度

#### 基线优先原则
- 先简单，后复杂：从基线模型开始
- 只有在证明基线模型无法满足需求时，才引入更复杂的模型

