# 错误处理原则与使用建议 (Error Handling and Usage Guidelines)

> **用途**: 定义 P4 阶段的错误处理原则（MRE、快速归因、修复方案）和代码审查的使用建议（检查优先级、搜索模式）。

---



## 七、错误处理原则（P4）

### MRE（可复现的最小示例）
- 记录依赖版本
- 记录配置
- 记录输入数据
- 记录原始错误信息（含运行环境）

### 快速归因
- 语法错误
- 类型错误
- 依赖问题
- 资源问题
- 并发问题
- 数据问题
- 兼容性问题
- 环境问题
- 权限问题
- 网络问题

### 修复方案
- 尽量缩小修改范围
- 必要时补充测试
- 添加类型约束或调整配置
- 评估影响范围与回归风险

## 使用建议

### 检查优先级
1. **严重（Critical）**: 安全漏洞、数据丢失风险、系统崩溃
2. **高（High）**: 功能错误、性能严重下降、架构违反
3. **中（Medium）**: 代码质量问题、轻微性能问题、文档不一致
4. **低（Low）**: 代码风格、命名规范、注释不足

### 搜索模式
在本文档中搜索关键词：
- `G1|G2|G3|G4|G5|G6|G7|G8` - 全局规则
- `核心原则|伦理|可复现|可解释` - 开发原则
- `安全|密钥|敏感信息` - 安全相关
- `文档|PROJECTWIKI|CHANGELOG` - 文档相关
- `测试|覆盖率` - 测试相关
- `性能|效率|资源` - 性能相关
