# P3执行方案约束与代码质量检查 (P3 Constraints and Code Quality Checks)

> **用途**: 定义 P3 阶段的前置约束（低风险判断、最小写入）和代码质量具体检查项（质量、安全、性能、架构、文档、测试）。

---


## 三、阶段三（P3）执行方案的约束

### 前置约束（低风险判断）
1. 变更代码行数 ≤ 200 且 文件数 ≤ 5
2. 不涉及对外契约（API/Schema）的破坏性变更
3. 无权限/密钥/生产配置改动
4. 无在线数据迁移，或仅"可逆迁移"且提供回滚脚本
5. 具备测试计划（含回归范围）

### 最小写入与原子追溯
- `PROJECTWIKI.md` 至少更新一处与本次变更直接相关内容
- `CHANGELOG.md` 新增条目（遵循 Keep a Changelog + SemVer）
- 代码与文档同一原子提交（Conventional Commits）

### 不可豁免清单
触及以下内容时一律不豁免文档更新：
- 行为/逻辑
- 对外契约
- 依赖/安全/合规
- 架构/ADR
- 权限/配置
- 数据结构/迁移

## 四、代码质量具体检查项

### 1. 代码质量
- **可读性**: 变量命名清晰、函数职责单一
- **可维护性**: 避免重复代码（DRY 原则）
- **复杂度**: 圈复杂度 ≤ 10（平均）
- **注释**: 关键逻辑有适当注释

### 2. 安全性
- **敏感信息**: 无明文密码、密钥、令牌
- **输入验证**: 用户输入需验证和清理
- **依赖安全**: 第三方库无已知漏洞
- **权限控制**: 适当的访问控制和授权检查

### 3. 性能
- **效率**: 避免不必要的循环和计算
- **资源使用**: 内存和 CPU 使用合理
- **关键接口**: P95 ≤ 200ms（测试环境）
- **数据库查询**: 避免 N+1 查询问题

### 4. 架构
- **模块化**: 代码组织清晰，职责分离
- **耦合度**: 低耦合，高内聚
- **设计模式**: 适当使用设计模式
- **扩展性**: 易于扩展和修改

### 5. 文档同步
- **代码注释**: 关键函数有文档字符串
- **PROJECTWIKI.md**: 架构、API、流程图与代码一致
- **CHANGELOG.md**: 记录所有重要变更
- **README**: 安装、配置、使用说明完整

