# 全局规则 (Global Rules)

> **用途**: 定义代码审查的全局规则（G1-G8），涵盖文档同步、安全合规、架构决策等基本要求。

---


# 代码质量标准参考

本文档汇总了从 CLAUDE.md 中提取的代码质量标准，供 codex 代码审查时参考。

## 一、全局规则（来自 CLAUDE.md）

### G1｜文档一等公民
- 凡涉及代码变更必须同步维护 `PROJECTWIKI.md` 和 `CHANGELOG.md`
- 提交记录需遵循 **Conventional Commits** 规范
- 建立代码 ↔ `PROJECTWIKI.md` 的双向关联

### G2｜知识库文档策略
- 代码实现必须与知识库保持一致
- 新功能需同步更新知识库相关章节
- 架构设计图、流程图必须使用 **Mermaid** 绘制

### G3｜无执行许可场景
- 未获用户明确同意前，禁止任何文件系统的写入操作

### G4｜一致性与质量
- API 定义和数据模型必须与实际代码实现保持一致
- 所有链接和引用必须有效且可追溯
- 确保知识库文档中的所有链接都指向正确的文件

### G5｜安全与合规
- 禁止连接未经授权的外部生产服务或资源
- 不得在代码库中明文保存密码、密钥等敏感信息（应使用环境变量）
- 新增或升级第三方依赖时，必须记录版本变更并验证兼容性及授权协议

### G6｜遵循既有架构决策
- 严格遵循 `PROJECTWIKI.md` 中已记录的架构设计、规范约定与 ADR
- 若需变更，须充分论证并取得用户确认

### G7｜敏感信息与输出脱敏
- 禁止在对话或文档输出中泄露密钥、令牌、生产连接信息等敏感数据
- 日志/配置/错误栈输出时须进行脱敏

### G8｜思考与更改
- 在给出解释之前，需要仔细阅读所有相关代码，不要猜测
- 创建详细的实施计划，不要直接进行代码更改
- 积极主动地做出大胆改变，并尽量减少确认

