# 文档模板集合（已迁移 - 按需加载）

> ⚠️ **重要通知**：为了优化 token 效率，本文件已拆分为专用模板文件。
>
> 请使用 `references/doc_templates/README.md` 作为入口，然后按需加载具体模板文件。

## 📚 可用模板文件（按需加载）

| 文件名 | 用途 | Token 估算 |
|--------|------|-----------|
| `projectwiki_template.md` | PROJECTWIKI.md 标准模板（12 章节完整结构） | ~4K |
| `changelog_template.md` | CHANGELOG.md 标准模板（Keep a Changelog + SemVer） | ~1.5K |
| `readme_template.md` | README.md 模板（快速开始、安装、配置） | ~1.2K |
| `api_doc_template.md` | API 文档模板（接口签名、参数、示例） | ~800 |
| `architecture_template.md` | 架构设计章节模板（总体架构、关键流程） | ~700 |
| `mermaid_examples.md` | Mermaid 图表示例（flowchart、sequenceDiagram 等） | ~2K |

**Token 节省**：从 ~18K tokens（完整文档）降至 ~3-8K tokens（按需加载），节省约 55-85%。

## 🚀 使用指南

### 方式 1：从索引入口开始（推荐）

```markdown
请先阅读 references/doc_templates/README.md，了解模板文件的整体结构和索引。
然后根据需要加载具体的模板文件。
```

### 方式 2：直接加载特定模板

根据文档生成需求直接加载对应文件：

- **生成 PROJECTWIKI.md** → `projectwiki_template.md`
- **生成 CHANGELOG.md** → `changelog_template.md`
- **生成 README.md** → `readme_template.md`
- **生成 API 文档** → `api_doc_template.md`
- **设计架构章节** → `architecture_template.md`
- **绘制 Mermaid 图** → `mermaid_examples.md`

## 📖 详细信息

查看 `references/doc_templates/README.md` 获取：
- 完整的模板文件索引
- 每个模板文件的详细说明和使用场景
- 模板使用最佳实践
- 文档生成工作流指南

## 🔄 与其他参考文件的关系

- **test_patterns.md**：测试代码生成模板（独立文件，可直接使用）
- **auto_log_skeleton_example.md**：自动化决策日志示例（独立文件）
