# Execute (E) - 执行开发阶段

## 目标
按 TODO 列表高质量完成所有开发任务。

## 核心原则
1. **先读后写**: 修改前必须读取文件
2. **最小变更**: 只改必要的部分
3. **质量优先**: 每次修改都要符合标准
4. **实时同步**: 及时更新 kanban 状态

## 执行流程

### 单任务执行
```
1. 从 kanban TODO 移到 DOING
2. 读取目标文件
3. 执行修改
4. 本地验证
5. 从 DOING 移到 DONE
6. 更新 TODO.md 打勾
```

### 代码修改规范
```yaml
工具选择:
  - str_replace: 精确替换（优先）
  - create_file: 新建文件
  - bash: 批量操作

禁止:
  - 盲写整个文件
  - 未读取就修改
  - 大范围无关改动
```

## MCP 工具使用

### codex - 代码生成 (可选)
```yaml
适用场景:
  - 大量样板代码
  - 标准 CRUD 实现
  - 类型定义生成

调用方式:
  参考 skills/codex/SKILL.md
```

### sequential-thinking - 复杂逻辑
```javascript
// 复杂算法实现
sequential_thinking({
  problem: "实现高效的缓存淘汰策略",
  context: "现有数据结构...",
  steps: [
    "分析需求",
    "设计算法",
    "实现代码",
    "验证正确性"
  ]
})
```

## 代码质量检查

### 每次修改后
```yaml
检查项:
  - TypeScript 类型正确
  - 无 lint 错误
  - 逻辑正确

工具:
  - tsc --noEmit
  - eslint
  - prettier
```

### Linus 品味清单
```
修改前问自己:
✓ 这个改动是最简单的方式吗？
✓ 代码是否清晰易读？
✓ 有没有引入不必要的复杂性？
✓ 命名是否准确表达意图？
```

### 精简检查 (参考 code-quality.md)
```yaml
检查:
  - 是否有重复代码
  - 是否有未使用的代码
  - 抽象层次是否合适
  - 函数是否过长 (>50行警告)
```

## 重构规范

### 何时重构
```yaml
信号:
  - 代码重复 > 2处
  - 函数过长 > 50行
  - 嵌套过深 > 3层
  - 命名不清晰
```

### 重构步骤
```
1. 确保有测试覆盖
2. 小步修改
3. 每步验证
4. 保持功能不变
```

### MCP 增强重构
```javascript
// 复杂重构推理
sequential_thinking({
  problem: "重构这个 200 行函数",
  steps: [
    "识别职责边界",
    "提取子函数",
    "简化控制流",
    "验证等价性"
  ]
})
```

## 状态同步

### kanban 更新
```markdown
执行任务时:
1. TODO → DOING (开始)
2. DOING → DONE (完成)

格式:
### DOING
- [ ] [file.ts] 当前任务

### DONE
- [x] [file.ts] 已完成任务
```

### TODO.md 更新
```markdown
完成一项:
- [x] [file.ts] 任务描述 ✓
```

## 错误处理

### 遇到错误时
```yaml
步骤:
  1. 记录到 errors.md
  2. 分析根因
  3. 决定: 重试/跳过/求助

错误记录格式:
  时间: [timestamp]
  任务: [task]
  错误: [error]
  根因: [analysis]
  处理: [action]
```

### 触发寸止 (严重错误)
```
[VERIFICATION_FAILED]
输出: 错误描述 + 建议方案
等待: 用户决策
```

## 输出规范

### 每个任务完成后
```
✓ [file.ts] 任务描述
  - 改动: 具体改了什么
  - 验证: 通过/失败
```

### 阶段完成后 (Path C)
```
## Phase N 完成

### 已完成
- [x] 任务1
- [x] 任务2

### 验证结果
- 类型检查: ✓
- Lint: ✓
- 测试: ✓

### 下一阶段
Phase N+1: [阶段名]
```
