# Innovate (I) - 方案设计阶段

## 目标
设计最优实现方案，做出关键技术决策。

## 适用路径
- Path B: 简要设计
- Path C: 完整架构设计

## 执行步骤

### 1. 方案探索
```yaml
输入: Research 阶段的上下文
过程: 
  - 列举可行方案 (至少2个)
  - 分析每个方案的优劣
  - 考虑可维护性和扩展性

MCP增强:
  - sequential-thinking: 深度推理复杂设计
    调用时机: 涉及架构决策或多方案权衡
```

### 2. 技术选型
```yaml
决策点:
  - 设计模式选择
  - 数据结构选择
  - API 设计
  - 错误处理策略

参考:
  - references/backend-standards.md
  - references/frontend-standards.md
```

### 3. 接口设计 (Path C)
```yaml
定义:
  - 模块边界
  - 接口契约
  - 数据流向

输出: 接口定义文档
```

### 4. 风险评估
```yaml
识别:
  - 技术风险
  - 性能风险
  - 兼容性风险

缓解策略: 每个风险对应一个缓解方案
```

## MCP 工具使用

### sequential-thinking - 深度推理
```javascript
// 复杂架构决策
sequential_thinking({
  problem: "需要设计一个可扩展的插件系统",
  context: "当前系统结构...",
  constraints: ["向后兼容", "性能要求"],
  steps: [
    "分析现有架构",
    "列举设计选项",
    "评估每个选项",
    "选择最优方案"
  ]
})
```

### memory - 存储决策
```javascript
// 记录架构决策
memory_store({
  category: "architecture_decision",
  title: "插件系统设计",
  content: "选择方案A因为...",
  tags: ["plugin", "architecture"]
})
```

## 设计原则 (Linus 哲学)

### 简洁优先
- 选择最简单可行的方案
- 避免过度设计
- YAGNI: 不需要就不加

### 可读性
- 代码是给人看的
- 清晰的命名
- 最小惊讶原则

### 品味清单
```
✓ 这个设计是否足够简单？
✓ 有没有更直接的方式？
✓ 未来的我能理解这个设计吗？
✓ 这个抽象值得引入吗？
```

## 输出模板

### Path B (简要设计)
```markdown
## 设计方案

### 选定方案
[方案描述]

### 主要改动
1. [改动1]
2. [改动2]

### 技术决策
- [决策1]: 原因
- [决策2]: 原因
```

### Path C (架构设计)
```markdown
## 架构设计

### 系统概览
[架构图/描述]

### 模块划分
| 模块 | 职责 | 接口 |
|:---|:---|:---|
| ModuleA | ... | ... |

### 数据流
[数据流描述]

### 接口契约
[接口定义]

### 技术选型
| 决策点 | 选择 | 原因 |
|:---|:---|:---|
| ... | ... | ... |

### 风险与缓解
| 风险 | 缓解策略 |
|:---|:---|
| ... | ... |
```

## 寸止点 (Path C)
设计完成后触发 `[DESIGN_FREEZE]`:
```
输出: 架构设计摘要
等待: 用户确认设计方案
确认后: 进入 Plan 阶段
```
