# Gap Analysis Template

**Feature Request:** [Brief description of what user wants]

**Date:** [YYYY-MM-DD]

---

## 🔍 Search Strategy

**Keywords identified:**
- Functional: [e.g., "authentication", "payment", "analytics"]
- Technical: [e.g., "modal", "form", "chart"]
- Component types: [e.g., "button", "service", "hook"]

**Search commands used:**
```bash
# Component search
glob "**/*[keyword]*.tsx"
glob "**/*[keyword]*.ts"

# Service search
glob "**/services/*[keyword]*"
glob "**/lib/*[keyword]*"

# Content search
grep "[keyword]" --output_mode files_with_matches
```

---

## 📋 Search Results

### Existing Code Found:

#### 1. [File Path/Name]
- **Location:** `[path/to/file.tsx]`
- **Description:** [What it does]
- **Similarity:** [Exact match / Similar / Different]
- **Reusability Assessment:**
  - ✅ Can reuse as-is
  - ⚠️ Can extend/customize
  - ❌ Too different, need new implementation

#### 2. [File Path/Name]
- **Location:** `[path/to/file.tsx]`
- **Description:** [What it does]
- **Similarity:** [Exact match / Similar / Different]
- **Reusability Assessment:**
  - ✅ Can reuse as-is
  - ⚠️ Can extend/customize
  - ❌ Too different, need new implementation

### Related Libraries/Patterns Available:

#### [Library/Pattern Name]
- **What it provides:** [Description]
- **Pros:** [Benefits]
- **Cons:** [Limitations]
- **Recommendation:** [Use / Don't use / Consider]

---

## 💡 Gap Analysis Results

### ✅ Existing Code to Reuse:
- **[Component/Service Name]:** [How to reuse]
- **[Component/Service Name]:** [How to reuse]

### ⚠️ Code to Extend/Customize:
- **[Component/Service Name]:** [What to customize]
- **[Component/Service Name]:** [What to customize]

### ❌ Genuine Gaps Identified:
- **[What's missing]:** [Why new code is needed]
- **[What's missing]:** [Why new code is needed]

---

## 🎯 Recommendation

### Approach:
- [ ] **Reuse Existing:** Use [component/service] as-is
- [ ] **Extend Existing:** Customize [component/service] by adding [features]
- [ ] **Create New:** Build new [component/service] because [reason]

### Justification:
[Explain why this approach is optimal based on gap analysis]

### Estimated Time Saved:
- **Reusing existing code:** Saves ~[X] hours (vs. building from scratch)
- **Code duplication avoided:** [X] lines not duplicated

---

## 📊 DRY Principle Compliance

**Code Duplication Check:**
- **Target:** < 5% duplication (SonarQube standard)
- **Current status:** [X]% duplication in related code
- **This approach:** Will [maintain / improve / worsen] duplication rate

**Research Citation:**
> "One of the most effective ways to avoid code duplication is through abstraction and modularity, where developers identify common patterns or logic and extract them into separate functions or modules for reuse."
> — MetriDev, "Code Duplication Best Practices" (2024)

---

## ✅ User Confirmation Required

**Present this analysis to user BEFORE proceeding to Phase 2 (Planning).**

**Questions for user:**
1. Do you agree with the approach recommendation?
2. Is there any existing code I missed that should be considered?
3. Should I proceed with [Reuse / Extend / Create New] approach?

---

**Next Steps:**
- [ ] Get user approval
- [ ] Proceed to Phase 2: Implementation Planning
- [ ] Update this analysis if user provides additional information
