# Increment Completion Checklist

**Feature:** [Feature name]
**Increment:** [Step N of M]: [Description]
**Date:** [YYYY-MM-DD]
**Status:** [Not Started / In Progress / Complete / Failed]

---

## 📋 Pre-Implementation

### Before Writing Code:

- [ ] **TodoWrite updated** - Marked this increment as "in_progress"
- [ ] **Scope understood** - Clear on what to build in THIS increment only
- [ ] **Files identified** - Know which files to create/modify
- [ ] **File size checked** - Confirmed target files < 200 lines
  ```bash
  wc -l [file-to-edit]
  # If > 150 lines, plan extraction
  # If > 200 lines, extract before adding
  # If > 300 lines, MUST refactor first
  ```

---

## 💻 Implementation

### During Coding:

- [ ] **Scope maintained** - Only implementing THIS increment (not adding extras)
- [ ] **Size limit respected** - Keeping changes < 100 lines
- [ ] **Patterns followed** - Using existing code patterns/conventions
- [ ] **Types added** - TypeScript interfaces/types defined
- [ ] **Imports clean** - No file extensions, using path aliases (@/...)
- [ ] **No debug code** - No console.log, debugger statements

### Code Quality Checks:

- [ ] **DRY principle** - Not duplicating existing code
- [ ] **Single responsibility** - Function/component does one thing well
- [ ] **Descriptive naming** - Variables/functions clearly named
- [ ] **Comments added** - Complex logic explained
- [ ] **Error handling** - Try/catch blocks where needed

### React-Specific (if applicable):

- [ ] **React.memo()** - Applied to:
  - Components with Framer Motion animations
  - Components rendered in loops
  - Expensive render components

- [ ] **useMemo()** - Applied to:
  - Expensive computations (> 10ms)
  - Complex filtering/sorting large arrays
  - Object creation passed as props

- [ ] **useCallback()** - Applied to:
  - Functions passed to memoized children
  - Functions in dependency arrays
  - Event handlers for optimized components

### Accessibility (if UI changes):

- [ ] **Keyboard accessible** - Tab, Enter, Esc, Arrow keys work
- [ ] **ARIA labels** - Added for icon buttons/interactive elements
- [ ] **Form labels** - Associated with inputs (for/htmlFor)
- [ ] **Color contrast** - 4.5:1 normal text, 3:1 large text
- [ ] **Focus indicators** - Visible 2px outline minimum
- [ ] **Reduced motion** - Respects prefers-reduced-motion

---

## 🧪 Testing (MANDATORY)

### Automated Tests:

```bash
# All three MUST pass before proceeding
npm run lint          # Status: [ ] Pass / [ ] Fail
npm run type-check    # Status: [ ] Pass / [ ] Fail
npm run test         # Status: [ ] Pass / [ ] Fail (if tests exist)
```

**If any fail:**
- ❌ DO NOT proceed to next increment
- ❌ DO NOT mark this increment as complete
- ✅ Fix issues first
- ✅ Re-run all tests
- ✅ Only continue after ALL pass

### Manual Verification:

```bash
npm run dev
```

- [ ] **Navigate to:** [URL or component location]
- [ ] **Action:** [What to do]
- [ ] **Expected:** [What should happen]
- [ ] **Actual:** [What actually happened]
- [ ] **Result:** ✅ Pass / ❌ Fail

### Increment-Specific Tests:

- [ ] **Test 1:** [Specific functionality to verify]
  - Status: ✅ Pass / ❌ Fail
  - Notes: [Any observations]

- [ ] **Test 2:** [Specific functionality to verify]
  - Status: ✅ Pass / ❌ Fail
  - Notes: [Any observations]

---

## ✅ Verification

### Code Quality:

- [ ] **No console logs** - All debug statements removed
- [ ] **No commented code** - Removed or explained why kept
- [ ] **No TODO comments** - Either done or tracked separately
- [ ] **Imports organized** - React → Third-party → Internal → Relative → Styles
- [ ] **Formatting consistent** - Matches project style

### Functionality:

- [ ] **Feature works** - This increment's functionality complete
- [ ] **No regressions** - Existing features still work
- [ ] **Error handling** - Errors handled gracefully
- [ ] **Loading states** - Loading indicators where needed

### Performance:

- [ ] **No console errors** - Browser console clean
- [ ] **No console warnings** - Dev warnings addressed
- [ ] **Fast render** - No noticeable lag/delay
- [ ] **No memory leaks** - Cleanup functions added (useEffect return)

---

## 📦 Commit (If Appropriate)

### Commit Guidelines:

- [ ] **Small, atomic commit** - This increment only (not multiple features)
- [ ] **Clear message** - Follows Conventional Commits format
- [ ] **Files staged** - Only files changed in THIS increment

### Commit Message Format:

```bash
git add [specific-files-only]

git commit -m "[type]: [clear description]

[Optional body explaining what and why]

[Optional breaking change notice]"
```

**Types:**
- `feat:` New feature
- `fix:` Bug fix
- `refactor:` Code restructure
- `perf:` Performance improvement
- `test:` Add/update tests
- `docs:` Documentation

**Examples:**
```bash
git commit -m "feat: add user authentication with email/password"
git commit -m "fix: resolve session persistence issue"
git commit -m "refactor: extract form validation to custom hook"
```

### Commit Checklist:

- [ ] **Tests passing** - All three (lint, type-check, test)
- [ ] **Message descriptive** - Clear what changed and why
- [ ] **Atomic** - Single logical change
- [ ] **Revertable** - Can be undone without breaking other work

---

## 🎯 Post-Implementation

### TodoWrite Update:

- [ ] **Status updated** - Marked as "completed" (not stuck in "in_progress")
- [ ] **Timestamp** - Note completion time for tracking

### Documentation (if needed):

- [ ] **Code comments** - Complex logic explained
- [ ] **README updated** - If functionality changed
- [ ] **API docs updated** - If endpoints added/modified

### Cleanup:

- [ ] **Temporary files removed** - No test files, nul files
- [ ] **Debug code removed** - No console.log left behind
- [ ] **Imports cleaned** - Removed unused imports

---

## 🚦 Decision Point

### Can I Proceed to Next Increment?

**Check ALL of these:**
- ✅ All automated tests passing (lint, type-check, test)
- ✅ Manual verification passed
- ✅ No console errors/warnings
- ✅ TodoWrite updated to "completed"
- ✅ Code committed (if appropriate)

**If ALL checked:**
- ✅ **PROCEED** to next increment
- Update next increment's status to "in_progress"

**If ANY unchecked:**
- ❌ **DO NOT PROCEED**
- Fix issues first
- Re-check this list
- Only continue after everything passes

---

## 📊 Research-Backed Standards

This checklist follows industry research:

**Testing Between Increments:**
> "Small problems are easier to fix than big problems, and frequent commits make bugs easier to identify because there's less code to sort through."
> — Harness.io, CI Best Practices (2024)

**Code Review Size:**
> "Reviewing 200–400 lines of code at a time detects up to 90% of defects, with defect detection rates dropping beyond this amount."
> — Microsoft Research, Code Review Study

**Continuous Integration:**
> "Research shows that CI leads to higher levels of throughput, more stable systems, and higher quality software."
> — ResearchGate, CI Research (2024)

---

## ⚠️ Common Mistakes to Avoid

### ❌ Don't Do This:

1. **Skipping tests** - "I'll test it all at the end"
   - Problem: Bug might be in earlier increment
   - Fix: Test after EACH increment

2. **Large commits** - "I'll commit when feature is done"
   - Problem: Hard to revert, hard to review
   - Fix: Commit after each increment

3. **Scope creep** - "While I'm here, I'll also add X"
   - Problem: Increments become too large
   - Fix: Stick to plan, add to backlog instead

4. **Ignoring lint errors** - "I'll fix them later"
   - Problem: Accumulates technical debt
   - Fix: Fix immediately, update config if needed

5. **Proceeding with failures** - "Tests pass locally, that's enough"
   - Problem: Might break CI/CD pipeline
   - Fix: ALL tests must pass, including CI

---

## 🎓 Learning & Improvement

### After Completing Increment:

**Reflect:**
- Was time estimate accurate? ✅ Yes / ❌ No
  - If no: Actual time was [X] min (vs [Y] estimated)
  - Reason: [What took longer/shorter]

- Did I follow the plan? ✅ Yes / ❌ No
  - If no: [What deviated and why]

- Any surprises? ✅ Yes / ❌ No
  - If yes: [What surprised me]

**Improve:**
- What went well? [Note successes to repeat]
- What could be better? [Note improvements for next time]
- Any blockers encountered? [Document for future reference]

---

## 📝 Notes & Observations

[Free-form space for any additional notes, observations, or lessons learned during this increment]

---

**Next Increment:** [Step N+1 of M]: [Description]
**Estimated Time:** [X] minutes
**Ready to start:** [ ] Yes / [ ] No (reason: _________)
