# Shownotes Generator

A Claude Code skill that transforms longform content into comprehensive, structured "shownotes" summaries following the mdynotes.com format.

## Overview

This skill generates professional episode summaries from podcasts, videos, articles, papers, and transcripts. It creates engaging hooks, detailed takeaways with proper attribution, memorable quotes, and comprehensive references—perfect for content creators, researchers, and knowledge workers who need structured summaries that provide real value to their audience.

## When to Use

Use this skill when you need:
- **Episode summaries** for podcasts or video content with engaging hooks and takeaways
- **Structured summaries** of research papers, articles, or longform content
- **Content with attribution** - quotes and insights properly credited to speakers/authors
- **Multi-perspective analysis** - balanced representation of multiple contributors
- **Reference cataloging** - comprehensive links to authors, tools, and resources mentioned

**Not suitable for:**
- Quick, brief summaries (use standard summarization instead)
- Short-form content (tweets, brief posts)
- Content without speaker/author attribution needs

## Installation

```bash
git clone https://github.com/WomenDefiningAI/claude-code-skills.git
cp -r claude-code-skills/shownotes-generator ~/.claude/skills/
```

Or manually download the `shownotes-generator/` directory to your `~/.claude/skills/` folder.

## Usage

Simply provide your content and ask Claude to generate shownotes:

```
I have a podcast transcript about AI alignment. Can you create shownotes for this?
```

The skill will:
1. Analyze the content and infer metadata (content type, topic, audience, authors)
2. Confirm details with you before proceeding
3. Generate complete shownotes with:
   - Engaging hook question
   - Summary with topics discussed
   - 4-10 detailed takeaways (130-170 words each)
   - Relevant quotes with context
   - Author references and social links
   - Related resources mentioned

## Key Features

- **Structured format** - Consistent, professional shownotes structure
- **Concise yet nuanced** - Eliminates verbosity while preserving depth (130-170 words per takeaway)
- **Multi-author attribution** - Properly credits all speakers and perspectives
- **Hook-driven takeaways** - Every insight supports the central question
- **Strategic formatting** - Paragraphs, bullets, and tables for maximum readability
- **Markdown-compatible** - Standard markdown formatting (hyphens for bullets, table support)
- **Comprehensive references** - Author social links and all mentioned resources

## Requirements

- Content must be longform (articles, papers, transcripts, videos, audio)
- Works best with multi-author/speaker content
- Requires identifiable authors or speakers for proper attribution

## Attribution

Created by: [mdynotes](https://mdynotes.com/)
License: Creative Commons Attribution 4.0 International (CC BY 4.0)
Version: 1.7 || Last updated: 2025-Nov-16 

For the latest version and examples, visit [mdynotes.com/resources](https://mdynotes.com/resources)
