# Skill Builder

A meta-skill for creating well-structured Claude Code Skills with proper validation and best practices.

## What is This?

This skill helps Claude guide you through creating new Claude Code Skills. It provides:

- Step-by-step creation workflow
- Templates for common skill patterns
- Validation tools to ensure proper structure
- Best practices and examples
- Progressive disclosure strategies

## Installation

### Quick Install

Copy this skill to your personal Claude Code skills directory:

```bash
# From the repository root
cp -r skill-builder ~/.claude/skills/

# Or clone and copy directly
git clone https://github.com/WomenDefiningAI/claude-code-skills.git
cp -r claude-code-skills/skill-builder ~/.claude/skills/
```

### Project-Specific Install

For project-specific use:

```bash
cp -r skill-builder /path/to/your/project/.claude/skills/
```

### Verify Installation

Check that the skill is installed correctly:

```bash
ls -la ~/.claude/skills/skill-builder/SKILL.md
```

You should see the SKILL.md file.

## What's Included

### Core Files

- **SKILL.md** - Main instructions for Claude on how to build skills
  - Creation workflow
  - Best practices
  - Validation checklist
  - Common patterns

- **REFERENCE.md** - Comprehensive technical reference
  - Frontmatter specifications
  - File organization patterns
  - Progressive disclosure details
  - Troubleshooting guide

- **FORMS.md** - Templates and quick-reference
  - SKILL.md templates (minimal, standard, advanced)
  - REFERENCE.md and FORMS.md templates
  - Script templates (Python, Bash)
  - Directory structure examples

### Supporting Files

- **scripts/validate-skill.py** - Validation script to check skill structure
- **templates/** - Ready-to-use skill templates:
  - `basic-skill-template.md` - Simple skill template
  - `advanced-skill-template.md` - Complex skill with supporting files

## Usage

Once installed, Claude will automatically use this skill when you ask to create or build a new skill.

### Example Requests

- "Create a skill for code reviews"
- "Help me build a skill for generating documentation"
- "Make a skill that automates testing workflows"
- "I need a skill to help with API documentation"

### What Claude Will Do

When you request a new skill, Claude will:

1. Ask you questions to understand requirements
2. Help you choose the appropriate location (project vs personal)
3. Create the directory structure
4. Write the SKILL.md with proper frontmatter
5. Add supporting files (REFERENCE.md, FORMS.md, scripts) as needed
6. Validate the structure
7. Show you how to test it

## Validating Skills

Use the included validation script to check any skill structure:

```bash
python3 ~/.claude/skills/skill-builder/scripts/validate-skill.py <path-to-skill>
```

### Example

```bash
# Validate a skill
python3 ~/.claude/skills/skill-builder/scripts/validate-skill.py ~/.claude/skills/my-new-skill/

# Validate the skill-builder itself
python3 ~/.claude/skills/skill-builder/scripts/validate-skill.py ~/.claude/skills/skill-builder/
```

### What Gets Validated

- Required files exist (SKILL.md)
- YAML frontmatter is valid
- Name follows rules (lowercase, alphanumeric, hyphens, max 64 chars)
- Description is valid (non-empty, max 1024 chars)
- File references in instructions are correct
- Scripts are executable
- Recommended sections are present

## Skill Structure

Skills created with this builder typically follow this structure:

```
skill-name/
├── SKILL.md              # Main instructions (required)
├── REFERENCE.md          # Detailed reference (optional)
├── FORMS.md              # Templates (optional)
├── scripts/              # Executable scripts (optional)
│   └── utility.py
└── resources/            # Static resources (optional)
    └── templates/
```

## Requirements

- Claude Code CLI
- Python 3.8+ (for validation script)
- PyYAML (for validation script)

Install PyYAML if needed:
```bash
pip install pyyaml
```

## Tips for Great Skills

1. **Clear Descriptions**: Make it obvious when Claude should use the skill
2. **Step-by-Step**: Write procedures as numbered steps
3. **Examples First**: Show examples before explaining
4. **Minimize Context**: Use progressive disclosure extensively
5. **Self-Contained**: Don't assume external resources are available
6. **Tested Procedures**: Ensure instructions actually work

## Common Patterns

The skill-builder includes templates for common patterns:

- **Simple Command Skills**: Execute specific commands with proper options
- **Generator Skills**: Create structured content from templates
- **Analyzer Skills**: Analyze code or data and provide reports
- **Workflow Automation**: Automate multi-step processes

See FORMS.md for complete templates.

## Learn More

- [Claude Code Skills Documentation](https://docs.claude.com/en/docs/agents-and-tools/agent-skills/overview)
- [Skills Cookbook](https://github.com/anthropics/claude-cookbooks/tree/main/skills)
- [Main Skills Repository](https://github.com/WomenDefiningAI/claude-code-skills)

## Contributing

Found a bug or have a suggestion? Please open an issue in the main repository.

## License

MIT
