# Skill Contributor

A skill that guides contributors through adding new skills to the claude-code-skills repository via Pull Request with proper validation and documentation.

## What is This?

This skill helps you contribute new skills to the claude-code-skills repository by:

- Validating skill structure and content
- Updating repository documentation
- Creating properly formatted Pull Requests
- Ensuring all contribution requirements are met
- Running validation checks automatically

## Installation

### Quick Install

Copy this skill to your personal Claude Code skills directory:

```bash
# From the repository root
cp -r skill-contributor ~/.claude/skills/

# Or clone and copy directly
git clone https://github.com/WomenDefiningAI/claude-code-skills.git
cp -r claude-code-skills/skill-contributor ~/.claude/skills/
```

### Project-Specific Install

For use within the claude-code-skills repository:

```bash
# Already included if you've cloned the repository
cd claude-code-skills
# The skill is available in ./skill-contributor/
```

### Verify Installation

Check that the skill is installed correctly:

```bash
ls -la ~/.claude/skills/skill-contributor/SKILL.md
```

You should see the SKILL.md file.

## Usage

Once installed, Claude will automatically use this skill when you want to contribute a skill to the repository.

### Example Requests

- "I want to contribute my skill to the claude-code-skills repository"
- "Help me submit a PR for my new skill"
- "Add my code-review skill to the repo via pull request"
- "Contribute this skill to claude-code-skills"

### What Claude Will Do

When you request to contribute a skill, Claude will:

1. **Verify prerequisites**: Check working directory, git status, skill location
2. **Validate skill structure**: Run validation script to ensure proper format
3. **Update documentation**: Add skill entry to main README.md
4. **Create README.md**: Generate skill documentation if needed
5. **Git operations**: Create branch, commit changes with proper messages
6. **Submit PR**: Create Pull Request with detailed description
7. **Post-submission checklist**: Provide next steps and what to expect

## Workflow Steps

The skill guides you through this workflow:

### 1. Fork Verification
Checks if you're working from a fork of the repository

### 2. Skill Location
Verifies the skill exists and is in the correct location

### 3. Validation
Runs `python3 skill-builder/scripts/validate-skill.py` to check:
- Valid YAML frontmatter
- Proper naming (lowercase, hyphens, alphanumeric)
- Description requirements
- File references
- Recommended sections

### 4. README.md Update
Adds skill entry to main README.md with:
- Display name and description
- Features list
- Installation instructions
- Documentation link

### 5. Skill README
Creates or verifies skill README.md exists

### 6. Git Branch & Commit
Creates feature branch with descriptive commit message

### 7. Pull Request
Generates PR with:
- Clear title
- Detailed description
- Validation results
- Testing checklist

### 8. Post-PR Checklist
Reminds you what happens next

## Requirements

- Claude Code CLI
- Git
- Python 3.8+ (for validation script)
- PyYAML (for validation)
- GitHub CLI (gh) - optional but recommended

Install PyYAML if needed:
```bash
pip install pyyaml
```

Install GitHub CLI:
```bash
brew install gh  # macOS
# or follow https://cli.github.com/
```

## Validation

This skill uses the validation script from skill-builder:

```bash
python3 skill-builder/scripts/validate-skill.py your-skill/
```

The validation checks:
- Required SKILL.md file exists
- Valid YAML frontmatter
- Name follows rules (max 64 chars, lowercase, alphanumeric, hyphens)
- Description is valid (non-empty, max 1024 chars)
- Referenced files exist
- Scripts are executable
- Recommended sections present

## Common Issues

### "Directory not claude-code-skills repository"
**Solution**: Navigate to the repository root directory

### "Repository not forked"
**Solution**: Fork the repository at https://github.com/WomenDefiningAI/claude-code-skills

### "Validation failed"
**Solution**: Follow the error messages and fix issues in SKILL.md

### "GitHub CLI not available"
**Solution**: Install gh or create PR manually at the provided URL

## Contribution Checklist

Before creating a PR, verify:

- [ ] Skill has SKILL.md with valid YAML frontmatter
- [ ] Skill name follows naming rules
- [ ] Description is clear and concise
- [ ] Validation script passes
- [ ] README.md is updated with skill entry
- [ ] Skill directory is at repository root level
- [ ] All referenced files exist
- [ ] Skill has been tested locally

## Learn More

- [Contributing Guidelines](../README.md#contributing)
- [Skill Builder Documentation](../skill-builder/README.md)
- [Claude Code Skills Documentation](https://docs.claude.com/en/docs/agents-and-tools/agent-skills/overview)
- [Skills Cookbook](https://github.com/anthropics/claude-cookbooks/tree/main/skills)

## Support

- **Issues**: Report bugs via [GitHub Issues](https://github.com/WomenDefiningAI/claude-code-skills/issues)
- **Discussions**: Ask questions in [GitHub Discussions](https://github.com/WomenDefiningAI/claude-code-skills/discussions)

## License

MIT

## Acknowledgments

Built to streamline contributions to the claude-code-skills collection maintained by [Women Defining AI](https://github.com/WomenDefiningAI).
