# UI/UX Audit Skill

**Auto-prevents redundant UI implementations by auditing current state BEFORE making changes.**

## 🎯 What This Skill Does

This skill enforces a mandatory "READ FIRST, IMPLEMENT SECOND" workflow for all UI/UX changes. It prevents common mistakes like:

- ❌ Adding features that already exist
- ❌ Duplicating data displays
- ❌ Cluttering clean, minimal designs
- ❌ Implementing recommendations without checking current state

Instead, it ensures the AI:
- ✅ Reads all relevant files FIRST
- ✅ Documents what currently EXISTS
- ✅ Checks for redundancy systematically
- ✅ Identifies GENUINE gaps (not assumed gaps)
- ✅ Presents findings for approval BEFORE implementing

## 🚀 Installation

### Option 1: Copy to Your Project
```bash
# Copy the skill folder to your Claude Code skills directory
cp -r claude-code-skills/skills/ui-ux-audit ~/.claude/skills/

# Or if using project-level skills
cp -r claude-code-skills/skills/ui-ux-audit .claude/skills/
```

### Option 2: Manual Installation
1. Create folder: `.claude/skills/ui-ux-audit/`
2. Copy `SKILL.md` into that folder
3. Restart Claude Code or reload workspace

## 🔥 When It Auto-Invokes

This skill automatically activates when you mention:

**UI/UX Terms:**
- improve UI, enhance UX, better design, update layout
- redesign, refactor UI, update design, modernize

**Page Terms:**
- fix homepage, improve page, update page, enhance page
- homepage improvements, page redesign

**Component Terms:**
- add component, new feature, improve section
- add visualization, add dashboard, add metrics

**General Improvement:**
- make it better, improve experience, enhance site
- improve portfolio, better showcase

**Question Form:**
- "How can I improve X?"
- "What should I add to X?"
- "Should I add X to the page?"

## 📋 What to Expect

### Before This Skill (Common Problem):
```
User: "Improve the homepage"
AI: "I'll add a portfolio visualization, metrics dashboard,
     and enhanced hero section!"
     [Implements without checking current state]
Result: Redundant features, cluttered design, user reverts everything
```

### After This Skill (Solution):
```
User: "Improve the homepage"
AI: "Let me audit the current homepage first..."
    [Reads all files, checks for redundancy]
AI: "Current State Audit:
     - Impact cards already show portfolio data
     - Hero already has primary CTAs
     - Page has clean, minimal design

     GENUINE Gap: Missing CTA after testimonials
     NOT Recommended: Portfolio visualization (redundant)

     Shall I add the CTA only?"
User: "Yes, that's perfect!"
```

## 🎓 Real-World Example

**The October 2025 Session** (Why This Skill Was Created):

An AI assistant implemented Phase 3 UI/UX recommendations without reading existing pages:
- Added `PortfolioVisualization` component despite impact cards showing same data
- Added large AI Assistant card overshadowing primary CTAs
- Added bulk content making pages "look like two pages in one"
- User had to revert everything

**The Fix:** This skill now runs FIRST, auditing current state before any UI/UX work begins.

## 📚 Comprehensive Documentation

This skill now includes extensive resources for learning and executing UI/UX audits:

### Core Files

**SKILL.md** - Main skill definition
- 5-step audit workflow
- Mandatory process enforcement
- Integration with CLAUDE.md
- Auto-invoke trigger keywords

**FORMS.md** - 7 Pre-Filled Templates
- Quick Audit (5-10 minutes)
- Comprehensive Audit (30+ minutes)
- Redundancy Checklist
- Gap Analysis Template
- WCAG Compliance Checklist
- Mobile Optimization Checklist
- Performance Audit Template

**REFERENCE.md** - Detailed Research & Requirements
- UX research principles (Nielsen Norman Group)
- Left-attention pattern (80/20 rule)
- Complete WCAG 2.1 AA requirements
- Design pattern library
- Audit methodology
- Measurement frameworks

### Learning Resources

**resources/examples/**
- `good-audit-example.md` - Gold standard audit template
- `bad-audit-example.md` - Anti-patterns to avoid

**resources/case-studies/**
- `october-2025-incident.md` - Real incident that inspired this skill
- `success-story-post-skill.md` - Proof the skill works

**resources/README.md** - Navigation guide for all resources

## 📚 Workflow Overview

1. **Audit Current State** - Read all target files
2. **Document What EXISTS** - Evidence-based inventory
3. **Redundancy Check** - Verify no duplication
4. **Identify Genuine Gaps** - Proven missing features only
5. **Design Philosophy Check** - Respect clean, minimal aesthetic
6. **Present Findings** - Get user approval before implementing

## 🎓 Learning Path

### Beginner (First-Time Auditor)
1. Read `resources/examples/good-audit-example.md` - See gold standard
2. Read `resources/examples/bad-audit-example.md` - Learn what NOT to do
3. Read `resources/case-studies/october-2025-incident.md` - Understand the why
4. Use `FORMS.md` Quick Audit Template for first audit

### Intermediate (Regular Use)
1. Use `SKILL.md` for workflow process
2. Copy appropriate template from `FORMS.md`
3. Reference `REFERENCE.md` when needed (WCAG, research)
4. Compare output to good example

### Expert (Training Others)
1. Share all resources with new AI assistants
2. Customize templates for specific projects
3. Contribute new examples and case studies

## ✅ Success Indicators

You'll know the skill is working when:
- AI reads files BEFORE proposing changes
- AI shows you what EXISTS vs. what's ASSUMED to be missing
- AI identifies redundancy proactively
- AI presents audit report for your approval
- AI proposes minimal, targeted solutions

## 🔗 Full Documentation

For complete details, workflow steps, and verification checklists, see:
- [SKILL.md](./SKILL.md) - Full skill definition and workflow

## 📝 Integration with CLAUDE.md

This skill enforces the mandatory rules from CLAUDE.md:
1. READ FIRST, IMPLEMENT SECOND
2. REDUNDANCY CHECK
3. RESPECT DESIGN PHILOSOPHY
4. MANDATORY AUDIT BEFORE UI/UX WORK
5. VERIFICATION CHECKLIST

## 🛠️ Customization

To customize for your project:
1. Edit `SKILL.md` to match your project structure
2. Update file paths in "Read Current State" section
3. Adjust design philosophy checks for your aesthetic
4. Modify trigger keywords if needed

## 🙏 Attribution

**Created by:** Madina Gbotoe
**Portfolio:** [https://madinagbotoe.com/](https://madinagbotoe.com/)
**GitHub:** [https://github.com/madinagbotoe](https://github.com/madinagbotoe)
**License:** Creative Commons Attribution 4.0 International (CC BY 4.0)

**Version:** 1.0
**Created:** October 28, 2025
**Last Updated:** October 29, 2025

## 📞 Questions or Issues?

- **GitHub Issues:** Report bugs or suggest improvements
- **Pull Requests:** Contributions welcome!
- **Portfolio Contact:** Via [madinagbotoe.com](https://madinagbotoe.com/)

---

**Find latest version:** [https://github.com/madinagbotoe/portfolio/tree/main/.claude/plugins/marketplaces/custom-skills/ui-ux-audit](https://github.com/madinagbotoe/portfolio/tree/main/.claude/plugins/marketplaces/custom-skills/ui-ux-audit)
