# Veo prompt guide (summary + examples)

## Prompt basics

Include as many of these elements as needed:

- Subject: "An astronaut in space."
- Context: "An astronaut floating in a space station with Earth visible through the window."
- Action: "A cat chases a laser pointer across the floor."
- Style: "A black and white film noir scene of a detective smoking in the rain."
- Camera: "A POV shot driving through a tunnel with neon lights."
- Composition: "A wide shot of a desert landscape with a lone cactus."
- Ambiance: "A girl holding a puppy in a field at sunset, warm light, gentle breeze."

## Tips

- Be explicit about subject, action, and camera when you want precision.
- Use negative prompts to avoid unwanted elements.
- If the model struggles, add more constraints or specificity.

## Examples

### Short prompts

- "Icicles melting in the sun"

### Less vs more detail

- Less detail: "Man on the phone"
- More detail: "A shot following a man from behind as he walks down a city street while talking on a phone. The camera follows at waist height from behind. We see the city street with cars and pedestrians. The man is wearing a black jacket and jeans, and carries a leather satchel over his shoulder. The street is lit by late afternoon sunlight. The man looks serious as he speaks."

### Simple vs detailed (cartoon style)

- Simple: "A cute creature with snow leopard-like fur is walking in winter forest, 3D cartoon style render."
- Detailed: "Create a short 3D animated scene in a joyful cartoon style. A cute creature with snow leopard-like fur, large expressive eyes, and a friendly, rounded form happily prances through a whimsical winter forest. The scene should feature rounded, snow-covered trees, gentle falling snowflakes, and warm sunlight filtering through the branches. The creature's bouncy movements and wide smile should convey pure delight. Aim for an upbeat, heartwarming tone with bright, cheerful colors and playful animation."

### Examples by writing elements

- Subject + context: "An architectural rendering of a white concrete apartment building with flowing organic shapes, seamlessly blending with lush greenery and futuristic elements."
- Subject + context: "A satellite floating through outer space with the moon and some stars in the background."
- Action: "A wide shot of a woman walking along the beach, looking content and relaxed towards the horizon at sunset."
- Style: "Film noir style, man and woman walk on the street, mystery, cinematic, black and white."
- Camera motion + composition: "A POV shot from a vintage car driving in the rain, Canada at night, cinematic."
- Composition (close-up): "Extreme close-up of a an eye with city reflected in it."
- Ambiance: "A close-up of a girl holding adorable golden retriever puppy in the park, sunlight."
- Ambiance: "Cinematic close-up shot of a sad woman riding a bus in the rain, cool blue tones, sad mood."

### Negative prompt example

- Prompt: "Generate a short, stylized animation of a large, solitary oak tree with leaves blowing vigorously in a strong wind."
- Negative prompt: "urban background, man-made structures, dark, stormy, or threatening atmosphere."
 - Tip: avoid instructive phrases like "no" or "don't"; describe unwanted elements directly (for example, "no frame, no wall" becomes "frame, wall").

### Aspect ratio prompts

- Widescreen (16:9): "Create a video with a tracking drone view of a man driving a red convertible car in Palm Springs, 1970s, warm sunlight, long shadows."
- Portrait (9:16): "Create a video highlighting the smooth motion of a majestic Hawaiian waterfall within a lush rainforest. Focus on realistic water flow, detailed foliage, and natural lighting to convey tranquility. Capture the rushing water, misty atmosphere, and dappled sunlight filtering through the dense canopy. Use smooth, cinematic camera movements to showcase the waterfall and its surroundings. Aim for a peaceful, realistic tone, transporting the viewer to the serene beauty of the Hawaiian rainforest."

### Prompting with reference images

- "A small surfer riding a wave inside a sink, miniature scale."
- "An angler fish wearing a clown costume, deep sea, dramatic lighting."

### Prompting with first and last frames

- "A ginger cat jumping from a tall cliff, slow motion."

### Prompting with video extension

- "A paraglider soaring through a mountain valley, golden hour."
