# 5W2H Analysis Framework

## Overview

5W2H is a systematic questioning method to comprehensively understand any topic, problem, or plan through 7 fundamental questions.

**The 7 Core Questions**:
- **What** - Object, goal, content
- **Why** - Reason, purpose, significance  
- **Who** - People, stakeholders, responsibilities
- **When** - Timing, schedule, deadlines
- **Where** - Location, context, scope
- **How** - Methods, processes, steps
- **How much** - Cost, quantity, metrics

## When to Use

Ideal for:
- 📋 Quickly understanding complete article information
- 🔍 Discovering information gaps and omissions
- 📊 Evaluating plan feasibility
- 💼 Analyzing business cases and proposals
- 📝 Organizing complex information
- ✅ Verifying information completeness

## The 7 Questions in Detail

### W1: What (Content)

**Core Questions**:
1. What is the main topic?
2. What are the key claims/conclusions?
3. What solutions are proposed?
4. What core concepts are involved?
5. What are the expected outcomes?

**Deep Inquiry**:
- What's the real problem?
- What's missing?
- What could go wrong?
- What are the alternatives?

### W2: Why (Reasons)

**Core Questions**:
1. Why discuss this topic now?
2. Why is this solution effective?
3. Why not choose other approaches?
4. Why should the audience care?
5. Why this timing?

**Five Whys Technique**:
Ask "why" 5 times to reach root cause:
```
Problem: [Surface issue]
→ Why 1: [First layer]
  → Why 2: [Second layer]
    → Why 3: [Third layer]
      → Why 4: [Fourth layer]
        → Why 5: [Root cause] ← Real issue
```

### W3: Who (People)

**Core Questions**:
1. Who is the target audience?
2. Who are the stakeholders?
3. Who is responsible for execution?
4. Who benefits? Who loses?
5. Whose expertise/cases are cited?
6. Who is the author? (potential biases?)

**Deep Analysis**:
- Stakeholder mapping
- Decision-makers vs. executors
- Who has veto power?

### W4: When (Timing)

**Core Questions**:
1. When to start?
2. What's the timeline/schedule?
3. When will results appear?
4. How time-sensitive is this?
5. When are key decisions needed?
6. What's the historical context?

**Time Trap Identification**:
- Unrealistic time expectations?
- Missing key milestones?
- Buffer time considered?

### W5: Where (Context)

**Core Questions**:
1. Where does this apply? (geography, industry, organization)
2. Where is execution happening?
3. Where to get resources?
4. What are the limitations/constraints?
5. What's the scope of impact?

**Context Dependency**:
- Does it work in different environments?
- Cultural differences?
- Scale considerations?

### H1: How (Methods)

**Core Questions**:
1. What are the specific steps?
2. What tools/methods are used?
3. How to measure progress?
4. How to handle obstacles?
5. How to ensure quality?
6. How to get started?

**Process Mapping**:
```
[Start] → [Step 1] → [Decision Point]
                         ↓ Yes / ↓ No
                    [Step 2A]  [Step 2B]
                         ↓         ↓
                    [Step 3] ← [Converge]
                         ↓
                    [End]
```

### H2: How Much (Metrics)

**Core Questions**:
1. What's the cost? (money, time, opportunity, learning)
2. How many resources needed?
3. What's the expected ROI?
4. What's the scale/magnitude?
5. How big are the risks?
6. What are the target metrics?

**ROI Analysis**:
```
Investment:
- Direct costs: [$]
- Indirect costs: [$]
- Total: [$]

Returns:
- Expected benefit: [$]
- Timeframe: [X months]
- ROI = (Benefit - Cost) / Cost × 100%

Worth it?: [Yes/No]
```

## Complete Analysis Template

### Quick Version (15 min)

```markdown
# 5W2H Quick Analysis: [Article Title]

**What**: [One-line topic and solution]
**Why**: [Core motivation and value]
**Who**: [Target audience and executors]
**When**: [Timeline and urgency]
**Where**: [Applicability and context]
**How**: [Key steps (3-5)]
**How much**: [Main costs and expected returns]

## Gap Analysis
Missing information: [List unanswered questions from 5W2H]
Key risks: [Risks based on missing info]
```

### Deep Version (60 min)

```markdown
# 5W2H Deep Analysis: [Article Title]

## 📋 What - Content Analysis
[Detailed breakdown...]

## 🎯 Why - Reason Analysis  
[Detailed breakdown...]
[Five Whys analysis]

## 👥 Who - People Analysis
[Detailed breakdown...]
[Stakeholder map]

## ⏰ When - Time Analysis
[Detailed breakdown...]
[Timeline visualization]

## 🌍 Where - Context Analysis
[Detailed breakdown...]
[Applicability matrix]

## 🔧 How - Method Analysis
[Detailed breakdown...]
[Process flowchart]

## 💰 How Much - Cost-Benefit Analysis
[Detailed breakdown...]
[ROI calculation]

## 📊 Overall Assessment

### Information Completeness
- ✅ Clearly answered: [X/7]
- ⚠️  Partially answered: [List]
- ❌ Completely missing: [List]

### Feasibility Score
Based on 5W2H completeness: [X/10]

### Risk Level
Based on missing info: [High/Medium/Low]

### Action Recommendations
1. [Specific recommendation based on analysis]
2. [Information needed to supplement]
3. [Priority actions to take]
```

## Practical Example

### Example: Remote Work Article

**Article Title**: "How to Successfully Transition to Remote Work"

```markdown
## 5W2H Analysis

### What
- Topic: Company transition from office to remote work
- Solution: Phased transition plan
- Goal: Maintain or improve team productivity

### Why
- Background: Post-pandemic work model changes
- Value: Cost savings, increased flexibility
- Rationale: Mature technology + changing work nature
⚠️  Missing: Why not hybrid model?

### Who
- Target: SMB managers
- Executors: HR + IT teams
- Beneficiaries: Employees (flexibility) + Company (cost)
⚠️  Missing: How to handle resisters?

### When
- Recommended: 3-month transition
  - Month 1: Pilot
  - Month 2: Expand
  - Month 3: Full rollout
✅ Clear

### Where
- Applicable: Knowledge work
- Not suitable: Manufacturing, service industries
- Tools: Zoom, Slack, Asana
✅ Clear boundaries

### How
1. Establish remote work policies
2. Configure technical infrastructure
3. Train managers and employees
4. Build virtual collaboration norms
5. Regular evaluation and adjustment
✅ Clear steps

### How Much
- Tool costs: $50/person/month
- Training: 40 hours
- ROI: Office costs ↓50%
⚠️  Missing: Transition period productivity drop costs

## Gap Analysis

Missing critical information:
1. Why - Why not consider hybrid model
2. Who - How to handle change resisters
3. How much - Transition period hidden costs

Risk:
- Medium risk: 80% information complete
- Need supplement: Change management and hidden costs

Recommendations:
1. Research hybrid work models
2. Create change communication plan
3. Budget 15-20% for transition productivity dip
```

## Integration with Other Frameworks

### + Critical Thinking
```
5W2H → Identify missing information
Critical Thinking → Evaluate quality of existing information
```

### + SCQA
```
SCQA → Understand problem framework
5W2H → Analyze solution completeness
```

### + Inversion
```
5W2H → Forward analysis of plan
Inversion → For each W/H, ask "what if it's missing?"
```

## Advanced Techniques

### 1. Prioritized 5W2H

Not all 7 questions are equally important—adjust by article type:

```markdown
Strategy articles: Why (40%) > What (30%) > How (20%) > Others
How-to articles: How (40%) > What (25%) > How much (20%) > Others
Analysis articles: What (30%) > Why (30%) > Who (20%) > Others
```

### 2. Iterative 5W2H

```markdown
Round 1: Quick scan of all 7 questions (15 min)
Round 2: Deep dive on 2-3 most lacking (30 min)
Round 3: Cross-validate answer consistency (15 min)
```

### 3. Extended 5W2H (+ 2H)

Add two more Hows:
- **How to measure?** (metrics)
- **How to sustain?** (maintenance)

## Common Pitfalls

### ❌ Surface-Level Analysis
- Wrong: Mechanically answer 7 questions without depth
- Right: Dig 2-3 levels deep on each question

### ❌ Ignoring Gaps
- Wrong: Only analyze what article provides
- Right: Explicitly note what article doesn't answer

### ❌ Siloed Thinking
- Wrong: Analyze 7 questions independently
- Right: Look for consistency and contradictions across answers

## Practice Tips

1. **Print Checklist**: Prepare standard 5W2H template
2. **Timed Drills**: Complete quick analysis in 15 minutes
3. **Reverse Validation**: Use analysis to reconstruct article—is it complete?
4. **Comparative Application**: Compare 5W2H across multiple articles on same topic

## Summary

5W2H is:
- ✅ **Completeness Checker**: Ensures no information omissions
- ✅ **Quick Understanding Framework**: Systematically captures essence
- ✅ **Communication Bridge**: Standardized analysis language

Best for:
- 📋 Project plan evaluation
- 📊 Business proposal analysis
- 📝 Operational guide comprehension
- 🔍 Information gap identification

---

**Remember**: 5W2H's value isn't just answering these 7 questions, but discovering which questions *aren't* answered—and why.
