# First Principles Thinking

## Core Concept

Strip away assumptions and conventions to reach fundamental truths, then rebuild understanding from the ground up.

## Three-Step Process

### Step 1: Identify Assumptions

**Ask:** "What do we assume to be true about this?"

List all implicit and explicit assumptions in the content:
- Unstated premises
- Inherited wisdom ("everyone knows...")
- Industry conventions
- Historical precedents treated as universal laws

**Example from business:**
- Assumption: "We need a physical store to sell products"
- Question: Is this fundamentally true or historically convenient?

### Step 2: Break Down to Fundamentals

**Ask:** "What is definitely, provably true?"

Reduce to indisputable facts:
- Physical laws (if applicable)
- Mathematical truths
- Core human needs/behaviors
- Cause-effect relationships you can verify

**Sorting Framework:**
```
Claim → Ask: "How do I know this is true?"
    ↓
├─ "It just is" → Probably an assumption, dig deeper
├─ "That's how it's always done" → Convention, not fundamental
├─ "X happens, then Y happens" → Potential fundamental (verify causation)
└─ "Mathematically/physically must be true" → Fundamental
```

### Step 3: Rebuild from Scratch

**Ask:** "Starting from fundamentals only, what logically follows?"

Reconstruct without importing old assumptions:
1. Begin with verified fundamentals
2. Each step must logically follow from previous
3. Note where you make new assumptions (be explicit)
4. Compare new construction to original concept

## Application Template

```markdown
## Original Concept/Argument
[What the author claims]

## Hidden Assumptions
- Assumption 1: [Something taken as given]
- Assumption 2: [...]

## Verified Fundamentals
- Fundamental 1: [Provably true core fact]
- Fundamental 2: [...]

## Rebuilt Understanding
Starting from fundamentals only:
Step 1: [First logical derivation]
Step 2: [Second logical derivation]
...
Conclusion: [What actually follows]

## Comparison
Original vs. Rebuilt:
- What survived: [Fundamentally sound ideas]
- What doesn't hold: [Based on questionable assumptions]
- New insights: [What rebuilding revealed]
```

## Common First Principles in Different Domains

### Business/Economics
- People act in self-interest (with caveats)
- Supply and demand affect price
- Value = willingness to pay
- Scarcity creates value

### Psychology/Human Behavior
- Humans seek pleasure, avoid pain
- Social status matters to humans
- Cognitive biases exist (not "people are rational")
- Habits form through repetition

### Technology
- Information can be copied at near-zero cost
- Network effects: value ∝ n² (Metcalfe's law)
- Moore's law (transistor density doubles ~every 2 years)
- Computation has energy cost

### Physics/Reality
- Energy is conserved
- Entropy increases
- Speed of light is constant
- Cause precedes effect

## Red Flags: Pseudo-First Principles

Watch for claims disguised as fundamentals:
- "People always prefer X" (overgeneralization)
- "This is just human nature" (often cultural)
- "Economics proves..." (many schools of economics)
- "Science says..." (which study? replicated?)

**Test:** Can you point to specific evidence/mechanism, or is it folk wisdom?

## Powerful Questions

- "Why is this true?" (repeat 5 times - "5 Whys")
- "What must be true for this to work?"
- "If I couldn't do it this way, what's another path?"
- "What would an alien with no context think?"
- "What if the opposite were true?"

## Example: Deconstructing "Need for College Education"

**Assumptions:**
- Need degree to get good job
- Learning requires formal institution
- 18-22 is the right age
- Four years is optimal duration

**Fundamentals:**
- Employers want skilled workers
- Skills can be demonstrated
- Learning requires time + practice
- Knowledge can be transmitted

**Rebuilt:**
→ Employers want proof of skill
→ Proof can be: degree OR portfolio OR test OR track record
→ Therefore, degree is one option, not necessity
→ Insight: Focus on skill + proof, not credential alone

## Practical Use in Reading

When analyzing content:
1. **Identify claims** that seem absolute
2. **Challenge foundations:** "Does this HAVE to be true?"
3. **Verify causation:** "Does A truly cause B, or just correlate?"
4. **Rebuild the argument** from indisputable facts only
5. **Compare** what survives vs. what was assumption

This exposes weak arguments and strengthens valid ones.
