# Six Thinking Hats Framework

## Overview

Structured method to examine ideas from six distinct perspectives. Wear one hat at a time to avoid confusion.

**Purpose:** Separate thinking modes, reduce conflict, ensure comprehensive analysis.

## The Six Hats

### 🎩 White Hat: Facts & Data

**Focus:** Objective information only

**Questions:**
- What facts do we have?
- What data is available?
- What information is missing?
- What are the numbers?
- How do we verify this?

**Language:**
- "According to..."
- "The data shows..."
- "We know that..."
- "We don't know..."

**In Content Analysis:**
- Extract all factual claims
- Note cited sources
- Identify missing data
- Separate facts from interpretations

**Template:**
```markdown
## Known Facts
- [Verifiable fact 1]
- [Verifiable fact 2]

## Missing Information
- [ ] [Gap 1]
- [ ] [Gap 2]

## Data Sources
- [Citation 1]: [Quality rating]
```

---

### 🎩 Red Hat: Emotions & Intuition

**Focus:** Gut feelings, hunches, intuitive responses

**Questions:**
- What's my immediate reaction?
- What does my gut say?
- What emotions does this evoke?
- What's my intuition telling me?

**Language:**
- "I feel that..."
- "My gut says..."
- "This makes me uncomfortable because..."
- "I'm excited about..."

**In Content Analysis:**
- Note emotional response while reading
- Identify what triggers strong feelings
- Trust instincts about credibility
- Recognize persuasive emotional appeals in text

**Template:**
```markdown
## Immediate Reactions
- [Emotion] at [specific part]

## Gut Feelings
- Something feels off about: [intuition]
- Exciting/Compelling: [what resonates]

## Emotional Triggers in Text
- Author uses [emotion] to persuade
```

**Important:** No justification needed. This is pure feeling.

---

### 🎩 Black Hat: Caution & Risks

**Focus:** Critical judgment, potential problems

**Questions:**
- What could go wrong?
- What are the risks?
- What's unrealistic?
- Where's the weakness?
- What are the downsides?

**Language:**
- "A problem is..."
- "This won't work because..."
- "The risk here is..."
- "We're overlooking..."

**In Content Analysis:**
- Identify logical flaws
- Note unsupported claims
- Point out potential failures
- Question feasibility
- Consider unintended consequences

**Template:**
```markdown
## Logical Weaknesses
- [Flaw 1] in reasoning

## Risks If Applied
- Risk: [consequence]
- When it fails: [scenario]

## Missing Considerations
- Doesn't account for: [factor]

## Overly Optimistic Claims
- [Claim] seems unrealistic because [reason]
```

**Important:** This is critical, not cynical. Necessary for risk assessment.

---

### 🎩 Yellow Hat: Benefits & Optimism

**Focus:** Positive aspects, value, opportunities

**Questions:**
- What's the value here?
- What are the benefits?
- Why would this work?
- What's the best-case scenario?
- What opportunities does this create?

**Language:**
- "The benefit is..."
- "This could work because..."
- "The value here is..."
- "An opportunity is..."

**In Content Analysis:**
- Extract valuable insights
- Identify strong arguments
- Note practical applications
- Find novel perspectives
- Recognize what advances the field

**Template:**
```markdown
## Key Value Propositions
- Valuable insight: [what's useful]

## Strong Points
- Well-supported: [argument]

## Potential Applications
- Could be used for: [use case]

## Novel Contributions
- New perspective on: [topic]

## Best-Case Outcome
If fully applied: [positive scenario]
```

**Important:** Be realistic but generous. Find genuine value.

---

### 🎩 Green Hat: Creativity & Alternatives

**Focus:** New ideas, possibilities, innovations

**Questions:**
- What else is possible?
- How else could we think about this?
- What's a creative alternative?
- What if we combined X with Y?
- What's unconventional?

**Language:**
- "What if..."
- "Another way to look at it..."
- "We could also..."
- "An alternative is..."

**In Content Analysis:**
- Extend the author's ideas further
- Generate alternatives to proposed solutions
- Combine with other frameworks
- Apply to new domains
- Challenge assumptions creatively

**Template:**
```markdown
## Extensions of Ideas
- Taking [concept] further: [new application]

## Alternative Approaches
Instead of [author's method], what if: [alternative]

## Creative Combinations
- [Idea from text] + [other framework] = [new insight]

## Unconventional Applications
- Apply this to [unexpected domain]

## "What If" Scenarios
- What if [assumption] were reversed?
```

**Important:** No criticism in green hat mode. All ideas welcome.

---

### 🎩 Blue Hat: Process & Meta-Thinking

**Focus:** Managing thinking, overview, conclusions

**Questions:**
- What have we covered?
- What thinking mode do we need now?
- What's the summary?
- What's next?
- How should we think about this?

**Language:**
- "We've covered..."
- "The next step is..."
- "In summary..."
- "We need to focus on..."

**In Content Analysis:**
- Decide which hats to use when
- Synthesize findings from all hats
- Determine next steps
- Plan learning strategy
- Monitor the analysis process

**Template:**
```markdown
## Analysis Process
1. White: Gathered facts
2. Red: Noted reactions  
3. Black: Identified risks
4. Yellow: Found value
5. Green: Generated alternatives

## Synthesis
Combining all perspectives:
- [Integrated insight]

## Next Steps
- [ ] Further research: [area]
- [ ] Practical test: [action]
- [ ] Deep dive: [topic]

## Time Investment
Worth [X] time because [reason]
```

**Important:** Blue hat organizes the other hats. It's the conductor.

---

## Usage Patterns

### Quick Evaluation (15 min)
White → Red → Yellow → Black → Blue

### Deep Analysis (60 min)  
White → Red → Black → Yellow → Green → Blue → (Revisit any hat) → Blue

### Problem-Solving
White → Red → Green → Yellow → Black → Green → Blue

### Decision-Making
White → Yellow → Black → Red → Blue

## Rules of Engagement

1. **One hat at a time** - Don't mix modes
2. **Everyone wears same hat** - Parallel thinking (if group)
3. **Separate person from hat** - You're not "the critical person," you're wearing black hat
4. **Time-box** - Set limits per hat
5. **Blue hat controls** - Decides sequence and timing

## Common Mistakes

❌ **Mixing hats** - "This is good (yellow) but risky (black)"
✅ **Separate:** Yellow session: "This is good because X." Then Black session: "The risk is Y."

❌ **Judging feelings** - "That's irrational" during red hat
✅ **Accept feelings:** All emotions noted without judgment

❌ **Weak yellow** - "I guess there's some value..."
✅ **Genuine optimism:** Really find the good

❌ **Staying too long** - 30 min per hat
✅ **Move on:** 5-10 min per hat usually sufficient

## Application to Reading

**When to use which hat:**

- **Understanding stage:** White (facts), Red (reactions)
- **Evaluation stage:** Black (critique), Yellow (value)
- **Application stage:** Green (ideas), Blue (synthesis)

**Full Cycle:**
1. White: What does the text actually say?
2. Red: How do I feel about it?
3. Black: What's wrong with it?
4. Yellow: What's right with it?
5. Green: What else could we do with this?
6. Blue: So what? Now what?

## Integration with Other Models

- **After First Principles:** Use hats to evaluate rebuilt argument
- **After Systems Mapping:** Use yellow/black on leverage points
- **Before Critical Thinking:** Use red to surface biases
- **During Synthesis:** Use blue to organize findings

## Output Format

```markdown
# Six Hats Analysis: [Content Title]

## 🎩 White: Facts
[Objective data]

## 🎩 Red: Feelings  
[Emotional response]

## 🎩 Black: Cautions
[Risks and weaknesses]

## 🎩 Yellow: Benefits
[Value and opportunities]

## 🎩 Green: Possibilities
[Creative extensions]

## 🎩 Blue: Conclusions
[Synthesis and next steps]
```
