# Outline (描边/勾边)

描边主要分为外描边和内描边。通常需要多种方法配合。

## 1. 外描边 (Outer Outline)

### A. 基于视角的勾边 (Fresnel/Rim method)
**原理**: `dot(viewDir, normal)` 接近 0 时判定为边缘。
*   **基础公式**: `pow(dot(viewDir, normal), k)`。
*   **优点**: 极低开销，单 Pass，直接在 Base Pass 内计算。
*   **缺点**: 线宽不均匀（扁平处变宽，甚至覆盖整个面）。
*   **应用**: 水墨风格（如《大神》），或作为辅助风格化效果。

### B. 过程几何描边 (Inverted Hull / Back-face Extrusion)
**原理**: 也就是“背面膨胀法”。绘制两遍，第二遍剔除正面（`Cull Front`），顶点沿法线膨胀，输出纯色。
*   **基础公式**: `v.vertex.xyz += v.normal * _OutlineWidth;`
*   **优点**: 线宽均匀，控制灵活，效果稳定，易于分区指定颜色。
*   **缺点**: 双倍 DrawCall（需描边物体）；很难对面片结构（如头发片）勾边。
*   **关键技巧**:
    *   **深度控制 (Z-Test)**: 描边 pass 放在 Base pass 后，利用 Z-Test 剔除被遮挡部分。
    *   **粗细控制**: 使用顶点色或 Mask 贴图控制局部粗细（如发梢变细，避免像火腿肠）。可以使用顶点色通道控制：宽度、Z偏移、颜色索引。
    *   **硬边断裂 (Hard Edge Split)**: 硬边处的顶点法线是分裂的，会导致描边断裂。
        *   *解决方案*: 在建模软件中将平滑法线烘焙到切线数据或顶点色中（Smoothed Normal），Shader 中沿这个平滑法线膨胀。
    *   **Z-Bias (Z偏移)**: 将背面顶点的 Z 值向相机方向微调，而不是沿法线膨胀。适用于某些难以膨胀的结构。
    *   **NDC 空间膨胀**: 将法线转到 NDC 空间再挤出（忽略深度方向），可以保持描边在屏幕上的视觉宽度一致（不随距离变细），也可以解决透视导致的粗细不均。

### C. 基于后处理的描边 (Post-Processing)
**原理**: 对屏幕图像进行边缘检测（Sobel, Roberts, Canny 算子），检测深度（Depth）、法线（Normal）或 ID 的不连续性。
*   **Sobel 算子逻辑**:
    ```glsl
    // 简单的 Sobel 边缘检测伪代码
    float2 kernel[9] = { ... }; // 3x3 卷积核
    float2 gradX = 0, gradY = 0;
    for(int i=0; i<9; i++) {
        float sample = tex2D(_CameraDepthTexture, uv + offset[i]).r;
        gradX += sample * kernelX[i];
        gradY += sample * kernelY[i];
    }
    float edge = sqrt(gradX*gradX + gradY*gradY);
    bool isEdge = edge > _Threshold;
    ```
*   **优点**: 性能开销固定（与物体数量无关），可同时处理内描边，适合场景建筑。
*   **缺点**: 难以控制局部粗细和颜色（容易出现过度描边）；深度/法线检测需要额外 Pass 或 G-Buffer 支持；难以处理半透明物体。
*   **应用**: 《无主之地》场景描边，《崩坏3》背景描边。

---

## 2. 内描边 (Inner Outline)

### A. 贴图手绘
直接在 BaseMap 上画线。
*   **缺点**: 锯齿明显，精度受贴图分辨率限制，近看模糊。
*   **应用**: 《原神》部分细节使用了直接手绘。

### B. 本村线 (Motomura Line / UV Mapping)
利用 UV 映射技巧，将需要描边的边缘映射到贴图的直线上（通常是像素边缘）。
*   **原理**: 贴图上的水平/垂直线不会产生锯齿。将模型上需要描边的边缘 UV 拉直，对齐到贴图上的线条。
*   **优点**: 完美抗锯齿，节省贴图空间。
*   **缺点**: UV 展开极其困难，对模型拓扑有要求（主要用于 GUILTY GEAR 系列）。扭曲了 UV 空间，导致无法在这些区域绘制正常纹理。

### C. 独立 UV 壳
将描边部分拆分成独立的 UV 壳，集中排布到贴图的指定颜色区域。
*   **优点**: 比本村线简单，抗锯齿。
*   **缺点**: 增加模型面数（需要切分网格）。

### D. 几何检测 / 后处理遮罩分区
*   **顶点色分区**: 在角色不同部位（如皮肤与衣服交界）刷不同的顶点色 ID。
*   **后处理检测**: 后处理检测 ID 贴图或颜色贴图的色差，在交界处生成描边。
*   **优点**: 线条干净，动态可变。

---

## 3. 风格化描边
*   **水墨风**: 多次 Pass 叠加半透明描边 + 顶点随机偏移（Noise） + 噪点干扰。
*   **效果线**: 模拟素描线条或速度线，常用于特效或高动态画面（如《天元突破》风格）。
