# Lighting & Shadows (打光与投影)

## 1. Character Lighting (角色打光策略)

卡通角色往往需要独立于场景的打光策略，以保证任何角度下的美观。

### A. 独立光照方向
*   **全独立**: 角色使用一套专属的灯光方向，甚至随相机视角旋转（始终保持“最好看”的角度）。
*   **半独立**: 基于场景主光，但限制仰角（如《蓝色协议》限制光照仰角不超过 45 度，防止产生难看的“阴阳脸”）。
*   **分区打光**:
    *   **身体**: 偏顶光（展示体积感）。
    *   **面部**: 偏平光（减少法令纹等丑阴影）。可通过 Mask 区分区域应用不同光照方向。

### B. 补光 (Fill Light)
*   **背光补正**: 防止角色在逆光下全黑。可使用 SH（球谐光照）均值或专门的背部补光灯（180度相反方向）。
*   **无方向光**: 对于非主光源，舍弃方向性（NdotL），仅计算距离衰减和颜色叠加，作为“氛围光”处理，避免多重阴影的混乱。

### C. 特效打光 (VFX Lighting)
特效（如爆炸、魔法）应带有并点光源照亮角色和场景，增强打击感和融合度。

## 2. Shadows (投影处理)

### A. 高质量 ShadowMap
*   **自投影 (Self-Shadow)**: 角色自身的阴影（如手投在身上）。需要高分辨率 ShadowMap 或专门的 Character Shadow Pass（如米哈游 2K ShadowMap）。
*   **Bias 问题**: 调整 Bias 以解决漏光或自身阴影条纹（Acne）。常需对脸部、头发做特殊 Bias 设置（甚至关闭头发对脸的 ShadowMap 投影，改用假阴影）。

### B. 额发投影 (Bangs Shadow)
前发投在脸上的阴影是二次元的重要特征，ShadowMap 精度通常不够且形状难看。
*   **AO 法**: 绘制面部 AO 贴图模拟。
*   **深度偏移法 (Depth Offset)**: 偏移采样深度图生成阴影（类似于屏幕空间描边）。
*   **Stencil 法**: 
    1.  先画脸写入 Stencil。
    2.  画头发时，再次渲染一个 Pass，根据光照方向偏移顶点（屏幕空间偏移），只在 Stencil 匹配区域（脸部）写入阴影色。
    3.  优点是边缘极其锐利，形状可控。

### C. 风格化投影 (Stylized Shadow)
*   **形状控制**: 使用 SDF 或后处理简化阴影形状，去除锯齿和噪点。
*   **平面投影 (Planar Shadow)**: 脚底阴影使用平面投影技术（把模型压扁投射到地面），性能极高且边缘锐利完美，适合平坦地面。
    ```csharp
    // 阴影矩阵计算 (C#)
    Vector4 lightDir; // 光源方向
    float d = -Vector3.Dot(planeNormal, planePoint);
    Matrix4x4 shadowMatrix;
    shadowMatrix.m00 = d + planeNormal.x * lightDir.x; // ... 构建压扁矩阵
    // Shader 中应用矩阵: v.vertex = mul(_ShadowMatrix, v.vertex);
    ```

### D. 面部“脏”阴影解决
*   **问题**: 树叶、栏杆等细碎物体投在脸上的阴影会破坏面部美感（“麻子脸”）。
*   **方案**:
    *   **SDF 面部阴影**: 完全放弃接收外部投影（《原神》）。
    *   **伪光追 (Fake Ray Tracing)**: 检测到视线方向有遮挡物时（Raycast），整体压暗面部，而不是投射具体形状的阴影。
