# Modeling & Pipeline (建模与管线)

## 1. Character Modeling (建模要点)

### A. 设计语言与简化
*   **信息量控制**: 游戏模型不同于插画，缩小后过多的细节会糊成一团。赛璐璐风格要求模型结构清晰、设计概括。
*   **LOD 策略**: 为了保证远景的表现力，可以为远景专门制作一套夸张了五官和轮廓的模型（如《罪恶装备》战斗远景用模型）。

### B. 头部建模
*   **斜脸成立**: 动漫脸在三维上是不成立的。建模重点在于**斜侧面（半侧面）**的观感，这是展示频率最高的角度。如果斜侧面成立，正面和侧面通常也能接受。
*   **头型**: 二次元头顶普遍偏“鸡蛋型”或头顶略尖，避免做成写实的“灯泡型”或头顶过于蓬松。
*   **头发处理**:
    *   **球形法线**: 头发整体法线应趋向于球形（可使用 Normal Transfer 工具），以获得整洁的高光带。
    *   **发梢切角**: 头发末端不要做成纸片，最好有一个小的切角或厚度，这样在正面光照下能自然产生底部暗部，增加体积感。

### C. 风格还原
*   **警示**: 不要为了所谓的“3D化”或“写实化”而牺牲原画的萌点（如《新樱花大战》的建模争议）。3D 应当服务于原画的美感。

## 2. Pipeline Optimization (管线优化)

### A. Unity HDRP (米哈游方案)
*   **为什么选 HDRP?**: 默认管线（Built-in）对屏幕空间纹理（Depth, Normal, Motion Vectors）的控制是黑盒的，难以定制。HDRP 允许高度定制 Lighting 和 Shader。
*   **Custom Pass**: 角色渲染常需额外 Pass（如描边），HDRP 的 Custom Pass 框架方便实现这些，且解决了描边区域 TAA 错误的问题（需提供正确的 Motion Vector）。
*   **优势**: 支持 Forward 和 Deferred 混合渲染，方便处理大量光源（Tile/Cluster Lighting）的同时保留自定义材质特性。

### B. Unreal Engine & Ray Tracing
*   **光追尝试**: UE 的光追（GI, Reflection, Shadow）可以极大地加速场景制作（免烘焙），但需要深度定制以适应卡通风格（防止画面过于写实）。
*   **应用**: 适合高精度的实时 CG 或过场动画（如《鹿鸣》）。需重写光追 Shader 以支持卡通的色阶和材质。

### C. Forward vs. Deferred
*   **Forward**: 传统卡通渲染首选（如《罪恶装备》），因为不需要处理大量点光源，且对半透明和描边支持更好。
*   **Deferred**: 适合需要大量光源或 PBR 混合的项目（如《噬血代码》），利用 G-Buffer 存储 PBR Mask 等信息。

### D. 技术取舍
*   **核心原则**: 技术必须服务于美术风格。不要为了炫技（如强行上光追）而破坏画面风格或牺牲性能。
*   **性能优先**: 在资源有限时，优先优化加载速度（SSD 优化）和帧率，比增加一个不明显的光影特效更重要。
