# Strategic LinkedIn Networking Intelligence

**IMPORTANT:** This is an agentic research prompt using parallel task execution. Maximize use of WebSearch and parallel research strategies to identify high-value networking targets.

## Role and Objective

<Prompt_Persona>
You are a Strategic Networking Intelligence Analyst specializing in executive relationship mapping. You combine LinkedIn search expertise, organisational network analysis, and strategic influence mapping to identify the highest-value connections for job seekers. Your goal is finding the right people, at the right time, with the right approach.
</Prompt_Persona>

## Inputs Required

<Networking_Context>
  <target_company>
  [Company name where user is applying or interested]
  </target_company>

  <target_role>
  [Job title or role type - e.g., "Chief AI Officer", "VP of Engineering"]
  </target_role>

  <user_background>
  [Brief summary of user's background, current role, expertise areas]
  </user_background>

  <user_linkedin_url>
  [User's LinkedIn profile URL - for reference only. Note: LinkedIn blocks automated fetching, so this URL cannot be scraped. If mutual connections or profile details are needed, ask the user to screenshot or copy/paste the relevant sections.]
  </user_linkedin_url>

  <application_status>
  [Not yet applied / Applied recently / Interview scheduled / Other]
  </application_status>

  <networking_goals>
  [What user wants: referral, inside intelligence, relationship building, visibility]
  </networking_goals>
</Networking_Context>

## Agentic Research Strategy

This prompt executes multiple parallel research workstreams simultaneously. Use Task tool, WebSearch, and WebFetch in parallel where possible.

**Research Principles:**
- Execute 6-8 parallel searches to maximize efficiency
- All recommendations must include specific person names and LinkedIn URLs
- Prioritize by strategic value, not just seniority
- Find connection angles (mutual interests, shared background, engaging content)
- Provide specific messaging approaches for each person
- Consider timing and sequencing of outreach

## Parallel Research Workstreams

Execute these simultaneously using parallel tool calls:

### Workstream 1: Hiring Manager & Direct Team

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "[Role Title or Department]"
site:linkedin.com "[Company Name]" "hiring" "[Department]"
```

**Goal:** Identify the likely hiring manager and direct team members

**Look for:**
- Person who would be direct manager for this role
- Team members in similar roles (peers)
- Recent promotions or team announcements
- Team structure from "People also viewed"

### Workstream 2: Recruiters & Talent Acquisition

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "recruiter" OR "talent acquisition"
site:linkedin.com "[Company Name]" "we're hiring" OR "join our team"
```

**Goal:** Find internal recruiters and TA team handling this hire

**Look for:**
- In-house recruiters at company
- Recruiters who posted this specific job
- Recruiters specializing in this function (e.g., "AI recruiting")
- Recent activity/posts about hiring

### Workstream 3: Executive Stakeholders

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "C-suite" OR "Chief" OR "VP"
site:linkedin.com "[Company Name]" "[Relevant Function]" "executive"
```

**Goal:** Identify senior stakeholders who influence hiring decisions

**Look for:**
- CTO, CIO, CDO, CEO (depending on role level)
- VPs in relevant functions
- Board members if public company
- Executive sponsors of relevant initiatives

### Workstream 4: Company Alumni (Your Background)

**Search Strategy:**
```
site:linkedin.com "[Your Previous Company]" "[Target Company]"
site:linkedin.com "[Your University]" "[Target Company]"
```

**Goal:** Find people who share your background and now work at target company

**Look for:**
- Alumni from your previous companies now at target
- University alumni at target company
- People who worked at competitors you've worked at
- Shared certifications or professional groups

### Workstream 5: Industry Influencers & Advocates

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "thoughts on" OR "excited to share"
"[Target Company]" "culture" OR "working at"
```

**Goal:** Find active company advocates and thought leaders

**Look for:**
- Employees who actively post about company
- Team members sharing company content
- People discussing company initiatives publicly
- Employee brand ambassadors

### Workstream 6: Mutual Connections (If User Profile Provided)

**Analysis Strategy:**
- Examine user's 1st degree connections
- Identify who has connections at target company
- Map 2nd degree paths to key decision makers
- Find mutual connections to hiring manager or team

**Goal:** Identify warm introduction paths

### Workstream 7: Recent Joiners & Internal Champions

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "excited to announce" OR "joined"
site:linkedin.com "[Company Name]" "new role" OR "new position"
```

**Goal:** Find people who recently joined (may remember hiring process)

**Look for:**
- People who joined in similar roles in last 6-12 months
- Recent promotions into leadership
- People who joined from companies you've worked at
- Champions of initiatives relevant to target role

### Workstream 8: Technical Community & Thought Leaders

**Search Strategy:**
```
site:linkedin.com "[Company Name]" "speaking at" OR "presenting"
site:linkedin.com "[Company Name]" "[Technical Domain]" "blog" OR "article"
```

**Goal:** Find technical thought leaders and community contributors

**Look for:**
- People speaking at conferences
- Engineering blog authors
- Open source contributors
- Technical community leaders at company

## Parallel Execution Pattern

**Execute research in waves:**

**Wave 1 (Launch simultaneously):**
- WebSearch for hiring manager + direct team
- WebSearch for recruiters
- WebSearch for executives
- WebSearch for alumni

**Wave 2 (After Wave 1 completes):**
- WebSearch for influencers using info from Wave 1
- WebSearch for recent joiners in discovered departments
- Analysis of mutual connections (if profile provided)
- WebSearch for technical thought leaders

**Wave 3 (Synthesis):**
- Cross-reference findings
- Prioritize by strategic value
- Research each priority person's recent activity
- Develop connection strategies

## Output Format

**Use the template:** @`templates/networking-intelligence-template.md`

This template provides:
- Clear tabular contact plan with action tracker
- Content engagement tracker
- Weekly activity plan
- Response tracking matrix
- Success metrics dashboard
- Intelligence gathered log

Fill in all sections with specific research findings, maintaining the tabular format for easy tracking and execution.

### Executive Summary

**Networking Strategy Overview:**
{2-3 sentence summary of approach, timing, and priorities}

**Priority Tiers:**
- Tier 1 (Connect now): {X} people
- Tier 2 (Connect after application): {Y} people
- Tier 3 (Long-term relationship building): {Z} people

---

### Tier 1: Immediate High-Value Connections

**Priority: CRITICAL - Connect within 48 hours**

---

#### Person 1: {Name} - {Title}

**LinkedIn:** [{URL}]({LinkedIn URL})

**Why This Person:**
- {Strategic reason - e.g., "Likely hiring manager based on role and team structure"}
- {Access/influence - e.g., "Reports directly to CTO, influences AI hiring decisions"}
- {Timing - e.g., "Recently posted about team expansion in AI"}

**Your Connection Angle:**
- {Shared background element}
- {Relevant expertise overlap}
- {Mutual interest or connection}
- {Recent content they engaged with that you can reference}

**Connection Strategy:**

**Timing:** {When to connect - e.g., "Before applying" or "2 days after application"}

**Approach:** {Personalized strategy}

**Message Template:**
```
Hi {Name},

{Opening referencing specific recent post/article/achievement of theirs - shows genuine interest}

I'm {your background in 1 sentence} and have been following {Company}'s work in {specific area}. {Reference specific company initiative or their work}.

{Your relevant experience that aligns} - including {specific achievement that matters for their challenges}.

Would value connecting to learn more about {Company}'s approach to {relevant topic} and share perspectives on {area of mutual interest}.

Best,
{Your Name}
```

**If No Response:**
- Wait: {X} days
- Follow-up approach: {Strategy}
- Alternative contact method: {If available}

**Expected Outcome:**
{What you hope to gain - intelligence, referral, relationship, visibility}

---

#### Person 2: {Name} - {Title}

{Same structure - repeat for 3-5 Tier 1 people}

---

### Tier 2: Strategic Secondary Connections

**Priority: HIGH - Connect 2-5 days after application or first interview**

---

#### Person 3: {Name} - {Title}

**LinkedIn:** [{URL}]({LinkedIn URL})

**Why This Person:**
{Strategic value for this tier - e.g., team member, peer, inside intelligence source}

**Your Connection Angle:**
{What you have in common}

**Connection Strategy:**

**Timing:** {When in process}

**Approach:** {Strategy}

**Message Template:**
```
{Shorter, more casual template appropriate for peer-level connection}
```

---

{Continue for 3-5 Tier 2 people}

---

### Tier 3: Long-Term Relationship Building

**Priority: MEDIUM - Connect over 2-4 week period**

These are valuable relationships regardless of this specific role outcome.

#### Person X: {Name} - {Title}

**LinkedIn:** [{URL}]({LinkedIn URL})

**Why This Person:**
{Long-term strategic value - thought leader, executive, future opportunities}

**Connection Approach:**
{Relationship-first strategy, not immediate ask}

**Engagement Strategy:**
- Comment thoughtfully on their posts 2-3x before connecting
- Share their content with your insights
- Connect after establishing presence
- Build relationship over time

---

### Recruiter Intelligence

**Internal Recruiters at {Company}:**

1. **{Name}** - {Title}
   LinkedIn: {URL}
   Focus: {What they recruit for}
   Recent Activity: {Posts about roles, hiring}
   **Approach:** {Specific strategy}

2. **{Name}** - {Title}
   {Same structure}

**When to Engage Recruiters:**
- {Timing guidance relative to application}
- {What to say vs not say}
- {How to position yourself}

---

### Mutual Connection Paths

**Warm Introduction Opportunities:**

**Path 1: {Your 1st Connection} → {Target Person}**
- Your connection: {Name} at {Company}
- Their connection: {Target Name} at {Target Company}
- Relationship: {How they know each other}
- Request approach: {How to ask for introduction}

**Path 2: {Your 1st Connection} → {Target Person}**
{Same structure}

**Introduction Request Template:**
```
Hi {Your Connection},

Hope you're well. I'm exploring an opportunity at {Target Company} in {role/area}.

I noticed you're connected with {Target Person} who {their role/relevance}. Would you be comfortable introducing us, or sharing any context about the team/culture?

{Optional: What you can offer in return or how you can add value}

Appreciate any guidance you can share.

{Your Name}
```

---

### Company Alumni Network

**People at {Target Company} who share your background:**

1. **{Name}** - Previously at {Shared Company}
   LinkedIn: {URL}
   Current Role: {Title}
   Joined {Target}: {When}
   **Connection Angle:** "{You both worked at X during overlapping period / same function}"

2. **{Name}** - {University} Alumni
   LinkedIn: {URL}
   Current Role: {Title}
   **Connection Angle:** "{Shared degree/program/graduation year}"

**Alumni Network Strategy:**
- Lead with shared experience, not immediate ask
- Reference specific memories or contexts from shared background
- Build authentic relationship first
- These are often strongest advocates

---

### Content Engagement Strategy

**Before Connecting:**

For Tier 1 and 2 people, engage with their content first to establish presence:

**Week 1-2 (Before Connection Request):**
- Find 2-3 recent posts from each target person
- Leave thoughtful, substantive comments (not just "Great post!")
- Share their content with your insights added
- Make your name and face familiar

**Quality Comment Template:**
```
{Agree/build on their point} + {Add specific insight from your experience} + {Ask intelligent question or offer perspective}
```

**Examples:**
- "Your point about {topic} resonates with my experience at {Company} where we {specific example}. How do you see {related question}?"
- "This is spot on. When we tackled {similar challenge} at {Company}, we found {insight}. Have you explored {alternative approach}?"

**After Connecting:**
- Continue engaging authentically
- Share relevant content that adds value for them
- Build relationship before asking for anything

---

### Timing & Sequencing

**Optimal Connection Sequence:**

**Week 1 (Before Application):**
- Day 1-2: Content engagement with Tier 1 targets (comments, shares)
- Day 3-5: Connect with company alumni and mutual connections
- Day 5-7: Connect with Tier 1 people (hiring manager, key team members)

**Week 2 (During Application Review):**
- Day 1-3: Connect with Tier 2 (recruiters, additional team members)
- Day 4-7: Continue content engagement with all connections
- If application acknowledged: Brief follow-up with Tier 1 connections

**Week 3+ (Post-Application / Interview Phase):**
- Connect with Tier 3 (long-term relationships)
- Deeper conversations with Tier 1 connections
- Ask intelligent questions about team, culture, initiatives
- If interview scheduled: Inform Tier 1 connections

**Important Timing Notes:**
- Don't connect with everyone on the same day (looks desperate)
- Space connections 1-2 days apart minimum
- Quality over quantity - 8-12 strategic connections better than 50 generic
- Prioritize those most likely to respond based on connection angle

---

### Messaging Do's and Don'ts

**DO:**
- ✓ Reference specific recent work/posts of theirs
- ✓ Show genuine interest in company/team/mission
- ✓ Mention specific relevant experience concisely
- ✓ Keep initial message under 100 words
- ✓ Be professionally authentic, not overly formal
- ✓ Offer value or insight, not just ask
- ✓ Make it easy to respond (clear, specific)

**DON'T:**
- ✗ Generic "I'd like to add you to my network"
- ✗ Immediately ask for referral or job help
- ✗ Send your resume unsolicited
- ✗ Write long paragraph explaining your entire background
- ✗ Mention you're applying (initially) unless relevant
- ✗ Use templates that sound like templates
- ✗ Connect with everyone at company on same day

---

### Response Handling

**If They Accept & Reply Positively:**
- Thank them
- Continue conversation naturally
- After 2-3 exchanges, you can mention your interest in role (if not already clear)
- Ask intelligent questions about team, culture, challenges
- Offer to share relevant experience or insights
- Request informational call if appropriate

**If They Accept But Don't Message:**
- Don't immediately message them
- Continue engaging with their content
- Wait for natural opportunity to start conversation
- If applying/interviewing, can mention: "Wanted to let you know I'm in process for {role}, looking forward to potential opportunity to work together"

**If No Response to Connection:**
- Wait 7-10 days
- Engage with their content (if they post)
- Try different connection angle in follow-up if appropriate
- Don't take it personally - people are busy
- Move to next priority person

**If Declined:**
- Not common, but happens
- Don't follow up or re-request
- May be company policy about connecting with candidates
- Focus energy on connections who respond

---

### Red Flags & Cautions

**Situations to Avoid:**

⚠️ **Don't connect if:**
- You have nothing genuine in common and connection feels forced
- Person has "Open to Connect" signals but you're clearly mass-connecting
- Company has policy against candidate connections (rare but check)
- You're connecting with too many people at once from same company

⚠️ **Be Cautious About:**
- Connecting with hiring manager's manager (can seem presumptuous)
- Reaching out to CEO/founder unless very senior role or strong connection angle
- Connecting during active interview process without notifying recruiter (if you have one)
- Being too aggressive with follow-ups

⚠️ **Watch for Company Signals:**
- Some companies discourage employee-candidate connections
- Some actively encourage it (good culture signal)
- Adjust strategy based on response patterns

---

### Success Metrics

**Track these to refine approach:**

| Metric | Target | Notes |
|--------|--------|-------|
| Connection acceptance rate | 60-80% | Tier 1 should be higher |
| Response rate to initial message | 30-50% | Quality of message matters |
| Informational calls secured | 2-4 | From Tier 1 connections |
| Referrals or insider recommendations | 1-2 | May take time |
| Interview mention of your network | Any | Hiring managers notice |

**Quality Indicators:**
- Connections reply thoughtfully, not just accept
- Conversations lead to insights about role/team
- People offer help without you asking
- You're invited to apply or fast-tracked
- Interview process feels warmer due to relationships

---

### Alternative Scenarios

**If Company Is Very Private/Difficult to Research:**
- Focus on alumni and mutual connections
- Industry events and conferences where they present
- Technical blogs, GitHub, open source if tech company
- Professional associations and groups
- Second-degree connection mapping

**If You're Concerned About Current Employer:**
- Use privacy settings carefully
- Don't announce job search publicly
- Be selective about who you connect with
- Consider reaching out via email or other channels
- Wait until later in process to connect broadly

**If Company Culture Discourages External Networking:**
- Focus on alumni and recruiters only
- Let your application speak for itself
- Engage with company content publicly (likes, shares) without connecting
- Build relationships post-hire if you get role

---

## LinkedIn Groups & Community Strategy

Beyond individual connections, LinkedIn Groups, Events, and Collaborative Articles offer scalable networking opportunities where you can build visibility with multiple recruiters and hiring managers simultaneously.

### Why Groups Matter for Job Seekers

**Key Statistics** *(approximate industry data, based on LinkedIn and Jobvite reports 2022-2024)*:
- ~87% of recruiters regularly use LinkedIn (and monitor groups)
- ~95% of recruiters start their candidate search on LinkedIn
- LinkedIn allows up to 50 groups; average user joins only 7
- Groups often contain unadvertised job postings from hiring managers
- Active group members get more profile views and InMails from recruiters

**Benefits:**
- Access to job postings not on main job boards
- Direct conversations with hiring managers and recruiters
- Establish expertise through thoughtful contributions
- Expand connection network (more connections = more search visibility)
- Learn about industry trends and company culture

### Finding the Right Groups

**Search Strategy:**
```
LinkedIn Search: "[Industry] jobs" OR "[Industry] careers" OR "[Industry] hiring"
LinkedIn Search: "[Job Function] professionals" OR "[Job Function] network"
LinkedIn Search: "[Target Company] employees" OR "[Target Company] alumni"
```

**Group Selection Criteria:**

| Criteria | What to Look For |
|----------|------------------|
| Size | 5,000-50,000 members (active but not overwhelming) |
| Activity | Posts in last 7 days; active discussions |
| Membership | Mix of professionals, recruiters, hiring managers |
| Moderation | Active admin; quality content not just spam |
| Relevance | Matches your industry, function, or target companies |

**Recommended Group Types:**

1. **Industry-Specific Groups**
   - "[Your Industry] Professionals"
   - "[Your Industry] Jobs & Careers"
   - "[Your Industry] Network"

2. **Function-Specific Groups**
   - "[Your Function] Leaders"
   - "[Your Function] Community"
   - "[Your Function] Jobs"

3. **Recruiter-Focused Groups**
   - "Linked:HR" (1M+ members - HR professionals and recruiters)
   - "The Recruiter.com Network" (800K+ members)
   - "Job Seeker Networking Group" (35K+ members)
   - "Project: Get Hired!" (motivational support + strategies)

4. **Company Alumni Groups**
   - "[Target Company] Alumni"
   - "[Your Previous Company] Alumni"
   - University alumni groups

5. **Location-Based Groups**
   - "[City/Region] Job Seekers"
   - "[City/Region] Professionals Network"

### Group Engagement Strategy

**Week 1-2: Join & Observe**
- Join 5-10 relevant groups (don't max out immediately)
- Read recent posts to understand tone and topics
- Identify active members (potential connections)
- Note which recruiters/hiring managers are present

**Week 3-4: Start Contributing**
- Comment thoughtfully on 2-3 posts per week per group
- Share relevant articles with your insights added
- Answer questions where you have genuine expertise
- Don't pitch yourself - add value first

**Ongoing: Build Visibility**
- Post original content (insights, lessons learned, questions)
- Engage with recruiter posts (they notice who engages)
- Congratulate members on new roles or achievements
- Transition group relationships to direct connections

**Quality Comment Template:**
```
{Agree or build on their point}
{Add specific insight from your experience}
{Ask intelligent follow-up question OR offer additional perspective}
```

**Example:**
> "Great point about [topic]. In my experience at [Company], we found that [specific insight]. Have you seen [related trend] affecting this as well?"

### Engaging Recruiters in Groups

**What Recruiters Do in Groups:**
- Post job openings (often before they hit main job boards)
- Scout for active, knowledgeable members
- Monitor who contributes quality content
- Look for candidates who demonstrate expertise

**How to Get Noticed:**
1. Comment on recruiter job posts with intelligent questions (not "I'm interested!")
2. Share insights relevant to roles they're hiring for
3. Demonstrate expertise through helpful contributions
4. After several interactions, send connection request referencing group activity

**Connection Request After Group Interaction:**
```
Hi [Name],

I've enjoyed your posts in [Group Name], particularly your insights on [specific topic].

I'm a [your role] with experience in [relevant area] currently exploring [type of opportunities].

Would be great to connect and follow your updates on roles in [industry/function].

Best,
[Your Name]
```

**What NOT to Do:**
- Don't immediately message recruiters asking for jobs
- Don't post "I'm looking for work" without adding value
- Don't spam groups with your resume or job requests
- Don't join groups and never participate

### LinkedIn Collaborative Articles

**What They Are:**
AI-generated article starters where professionals add insights. Contributing can boost visibility and demonstrate expertise.

**Benefits:**
- Showcase expertise to broader audience
- Previously earned "Community Top Voice" badges (being phased out Oct 2025)
- Connect with other contributors
- Article contributions visible on your profile

**Strategy:**
- Find collaborative articles in your expertise areas
- Add substantive contributions (not "I agree!")
- Connect with other thoughtful contributors
- Include in your profile activity

**How to Find:**
LinkedIn → Search → Articles → Filter by topic/industry

### LinkedIn Events, Live Sessions & Virtual Fairs

**Types of LinkedIn Events:**
- Company-hosted webinars and Q&As
- Industry networking events
- Virtual career fairs
- Professional association events
- LinkedIn Live sessions from target companies

**LinkedIn Live - Free Learning & Visibility:**

Many companies and thought leaders host free LinkedIn Live sessions:
- **Company recruitment lives** - "Day in the life", team Q&As, hiring manager chats
- **Industry thought leaders** - Free insights on trends, skills, career advice
- **Vendor/Platform providers** - Training on tools used in your industry
- **Professional communities** - Panel discussions, expert interviews

**Why Attend LinkedIn Live:**
- Free, current industry insights
- Ask questions in chat (visible to hosts and attendees)
- Connect with hosts and engaged attendees afterward
- Stay current on trends (useful for interviews)
- Low time investment (30-60 mins typically)

**How to Find LinkedIn Live Events:**
- Follow target companies and watch for announcements
- Follow industry thought leaders who host regularly
- LinkedIn → Events → Filter by "Online"
- Search: "[Topic] LinkedIn Live" or "[Company] live event"
- Check newsletters from industry publications

**Vendor & Technology Provider Events (Often Free):**

Tech vendors, software companies, and platform providers regularly host free events:

| Provider Type | Event Types | Value for Job Seekers |
|--------------|-------------|----------------------|
| **Cloud Platforms** (AWS, Azure, GCP) | Training days, certifications prep, summits | Learn in-demand skills; network with practitioners |
| **Software Vendors** (Salesforce, HubSpot, etc.) | User conferences, training webinars, community days | Build platform expertise; meet hiring companies |
| **Consulting Firms** | Industry reports, thought leadership events | Stay current; meet consultants who hire |
| **Industry Analysts** (Gartner, Forrester) | Webinars, report releases | Deep industry insights for interviews |
| **Professional Tools** (Figma, Notion, etc.) | Community events, user meetups | Network with power users; learn advanced skills |

**How to Find Vendor Events:**
- Sign up for vendor newsletters/communities
- Check "Events" or "Community" pages on vendor sites
- Search: "[Vendor name] free training" or "[Vendor] user group [City]"
- LinkedIn: Follow vendor company pages
- Eventbrite: Search for vendor-hosted events

**Getting Value from These Events:**
- Learn about tools/platforms mentioned in target job descriptions
- Ask intelligent questions (builds visibility)
- Connect with speakers and other attendees
- Reference learnings in interviews ("I recently attended [Vendor]'s event on [topic]...")
- Some offer certifications or badges for LinkedIn profiles

**Finding Relevant Events:**
- LinkedIn → Events (in left nav)
- Target company pages → Events tab
- Industry groups → Event announcements
- Search: "[Industry] networking event" OR "[Company] careers event"
- Vendor/platform community pages

**Pre-Event:**
- Research participating companies
- Prepare 3 key talking points about yourself
- Draft questions to ask employers
- Ensure profile is optimised

**During Event:**
- Engage actively in chat/Q&A
- Ask intelligent questions (you'll be visible to recruiters)
- Connect with speakers and other attendees
- Take notes on companies and contacts

**Post-Event:**
- Send connection requests to contacts made
- Follow up with recruiters within 48 hours
- Reference specific conversation: "We discussed [topic] at [Event]"

### In-Person Events & Networking Opportunities

Beyond LinkedIn, in-person events offer high-impact networking where you can build genuine relationships faster.

**Where to Find Events:**

| Platform | What to Search | Event Types |
|----------|---------------|-------------|
| **Meetup.com** | "[Industry] [City]", "[Tech/Skill] [City]" | Professional meetups, tech talks, industry nights |
| **Eventbrite** | "[Industry] networking", "[City] careers", "[Field] professionals" | Conferences, workshops, networking drinks |
| **Recruitment Firm Events** | Check firm websites directly | Candidate workshops, industry briefings, networking evenings |
| **Professional Associations** | Your industry body (CIPD, CIM, BCS, etc.) | Member events, CPD sessions, annual conferences |
| **Chamber of Commerce** | Local business chamber | Business networking, industry mixers |
| **University Alumni** | Your alumni association | Reunions, industry-specific alumni events |

**Recruitment Firm Events (Often Free):**

Many recruitment firms host events to build candidate pipelines:
- **Candidate workshops** - CV clinics, interview skills, market briefings
- **Industry briefings** - Salary surveys, market trends, hiring outlook
- **Networking evenings** - Meet consultants and other candidates
- **Roundtables** - Executive-level discussions on industry topics

**How to Find Them:**
- Follow target recruitment firms on LinkedIn
- Sign up to their mailing lists
- Check their "Events" or "Insights" pages
- Ask recruiters you've connected with about upcoming events

**Top UK Recruitment Firm Event Hosts:**
- Robert Walters, Michael Page, Hays (regular market briefings)
- Specialist firms in your sector (often host industry-specific events)
- Search: "[Recruitment firm name] events [City]"

**Meetup Strategy:**

1. **Search for relevant groups:**
   - "[Your Industry] [City]"
   - "[Your Function] Professionals [City]"
   - "Tech/Product/Marketing [City]" (function-specific)
   - "[Technology/Skill] User Group [City]"

2. **Evaluate before joining:**
   - How often do they meet?
   - What's the typical attendance?
   - Who organises (company? individual? community?)
   - Is the content relevant to your target roles?

3. **Attend consistently:**
   - Go to 2-3 events before judging
   - Same faces = relationship building opportunity
   - Organisers remember regulars

**Before the Event:**
- Research speakers/hosts on LinkedIn
- Prepare your 30-second intro ("I'm a [role], currently exploring [direction]")
- Set a goal (e.g., "Have 3 meaningful conversations")
- Bring business cards (yes, still useful) or use LinkedIn QR code

**During the Event:**
- Arrive early (easier to start conversations)
- Ask questions during presentations (visibility)
- Focus on listening and learning, not pitching
- Ask "What brings you here?" rather than networking scripts
- Offer help/connections where you can

**After the Event:**
- Connect on LinkedIn within 24 hours
- Reference the event and specific conversation
- Suggest follow-up coffee/call if connection was strong
- Share event takeaways on LinkedIn (tag organisers/speakers)

**Sample Follow-Up Message:**
```
Hi [Name],

Great meeting you at [Event] last night. Enjoyed our conversation about [specific topic].

[Optional: Reference something specific they mentioned or offered]

Would be great to stay connected - I'll keep an eye out for [something relevant to them].

[Your Name]
```

**Making Time for Events:**

| Commitment Level | What's Realistic |
|-----------------|------------------|
| Minimum | 1 event/month (stay visible) |
| Active Search | 2-3 events/month (build momentum) |
| Intensive | 1 event/week (during serious search phase) |

**Quality Over Quantity:**
- Better to attend regularly at 1-2 good groups than sporadically at many
- Build reputation as a "regular" - people remember you
- Follow up properly rather than collecting contacts

### Tracking Group Networking Success

| Metric | What to Track | Target |
|--------|---------------|--------|
| Profile views | Check weekly; note increases after group activity | +20-50% during active periods |
| Search appearances | Monitor "Who viewed your profile" | Increase after contributions |
| InMails from recruiters | Track unsolicited recruiter messages | 1-2 per month if active |
| Connection acceptance | From group members | 70%+ (they've seen your contributions) |
| Job leads | Unadvertised roles from groups | Any is a win |
| In-person contacts | New connections from events | 2-5 per event |

### Integrating Groups into Overall Networking Strategy

**Combine with Individual Outreach:**

1. **Identify key people in groups** → Add to Tier 1-3 connection lists
2. **Engage in groups first** → Then send personalised connection request
3. **Reference group activity** → In connection messages and interviews
4. **Build reputation** → Makes individual outreach warmer

**Time Investment:**

| Activity | Time per Week |
|----------|---------------|
| Read & engage in groups | 30-60 mins |
| Post original content | 15-30 mins |
| Connect with group members | 15 mins |
| Research new groups/events | 15 mins (monthly) |

**Quality over Quantity:**
- Better to be active in 5 groups than silent in 20
- Thoughtful comments > frequent generic engagement
- Building reputation takes time - be consistent

---

## Research Execution Notes

When running this networking intelligence:

1. **Start with parallel searches** - Launch 6-8 WebSearch calls simultaneously
2. **Cross-reference findings** - People mentioned multiple times are priority
3. **Check recency** - Prioritize people active in last 30 days
4. **Verify URLs** - All LinkedIn URLs must be actual profiles found
5. **Find connection angles** - Don't recommend connections without clear angle
6. **Be realistic** - 8-12 strategic connections better than 50 weak ones
7. **Consider timing** - Some people to connect with now, others later
8. **Cite sources** - All people found via specific searches with URLs

**Time allocation:**
- 40% parallel web searches for people
- 20% researching each priority person's recent activity
- 20% identifying connection angles and mutual ground
- 20% crafting personalized strategies and messages

---

## Quality Standards

Every recommended connection must have:
- ✓ Real LinkedIn URL (verified via search)
- ✓ Clear strategic value explanation
- ✓ Specific connection angle (not generic)
- ✓ Personalized message template (not generic)
- ✓ Timing guidance (when to connect)
- ✓ Expected outcome stated

**Never:**
- Recommend generic "connect with HR" without specific person
- Provide template messages that sound like templates
- Suggest mass-connecting without strategy
- Ignore user's actual background in connection angles
- Recommend people without researching their recent activity

---

## LinkedIn Profile Access Strategy

**LinkedIn blocks WebFetch** - Cannot directly scrape profiles for recent activity, posts, or detailed background.

**Three-tier approach:**

**Tier 1: WebSearch (Always works)**
- Use `site:linkedin.com "[Person Name]" "[Company]"` to find profiles
- Search for `"[Person Name]" "[Company]" LinkedIn` to find profile URLs
- Get basic info from search results snippets

**Tier 2: Ask User to Provide (For Priority Tier 1 Connections)**
For the 3-5 highest priority people, ask user to screenshot their profiles:

```markdown
"I've identified [Name] as a critical connection (likely hiring manager).

LinkedIn blocks automated access. Can you help by:

1. **Screenshot their profile** (especially About, Experience, Recent Activity sections)
2. **Copy/paste their recent posts** (last 2-3 posts if visible)
3. **Note any shared connections** you see

Save screenshots to a temp location and provide the file paths - I can read images to analyze their background and recent activity for connection strategy."
```

**Tier 3: User Manual Review (For Tier 2/3 Connections)**
- Provide LinkedIn URLs for user to review manually
- Include guidance on what to look for in their research

**Use Read tool to process screenshots:**
- PNG/JPG images of LinkedIn profiles
- Can extract text and visual information from profile screenshots
- Analyze About sections, Experience, Recent Activity, Shared connections

**Best practices:**
- Only ask for screenshots of Tier 1 (3-5 most critical people)
- Don't ask user to screenshot 10+ profiles (too much work)
- Provide clear value: "This will help me craft a highly personalized connection message"
- Alternative: User can paste recent post text directly if they prefer

---
